/*	--------------------------------------------------
 *	Script:	    raintodayeditor.js
 *  Author:     Neil Thomas
 *  Last edit:  7th Mar 2023
 *	Based on:   /js/raintodayeditor.js
 *          By: Mark Crossley
 *      Edited: 2021/05/16 20:55:14
 *  -------------------------------------------------
 *  Changelog (NT)
 *  Added call to getData() function on document.ready
 * 	Altered all API calls to use host root
 *  Made button call dedicated procedure rather than as form submit
 * -------------------------------------------------------------------*/

$(document).ready(function() {
    getData();

    $("#rainform").submit(function(event){
        event.preventDefault();
		console.log("Form Sunbit button");
        $.post( "/api/edit/raintoday", $( "#rainform" ).serialize(), function() {
               location.href="raintodayeditor.html";
           });
    });
});

let getData = function() {
    $.ajax({url: "/api/edit/raintodayeditdata.json", dataType:"json", success: function (result) {
        $('#inputCurrentCounter').val(result.raincounter);
        $('#inputStartCounter').val(result.startofdayrain);
        $('#inputRainMultiplier').val(result.rainmult);
        $('#inputRainToday').val(result.raintoday);
        $('#inputRainToday').attr("step",result.step);
    }});
};
