/*	---------------------------------------------------------
 * 	Script:		noaayearlyreports.js
 * 	Author:		Neil Thomas
 * 	Last Edit:	7th Mar 2023
 * 	Based on:	embedded script in parent html page
 * 			By:	Mark Crossley
 * 	--------------------------------------------------------- */

$(document).ready(function () {
    $.ajax({
        url: "/api/tags/process.json?recordsbegandate",
             dataType: "json"
        })
        .done(function (result) {
            var now = new Date();
            // subtract 1 day
            now.setTime(now.getTime()-(1*24*3600000));
            var yr = now.getFullYear();
            var start = result.recordsbegandate.split(" ")[2];

            for (var i = yr; i >= start; i--) {
                $('#datepicker').append($('<option>', {
                    value: i,
                    text: i
                }));
            }

            load();
        });
    });

function load() {
    var year = $('#datepicker').val();
    console.log("Year: " + year);
    $.ajax({
        url: '/api/reports/noaayear?year='+year
    })
    .done(function(data) {
        $('#report').text(data);
    })
    .fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}

function generate() {
    var year = $('#datepicker').val();
    $.ajax({
        url: '/api/genreports/noaayear?year='+year
    })
    .done(function(data) {
        $('#report').text(data);
        alert("Report (Re)generated");
    })
    .fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}
