/*	----------------------------------------------------------
 *	Script:	    thisperiod.js
 * 	Author:  	Neil Thomas
 *	Last Edit:	7th Mar 2023
 * 	Based on:	/js/thisperiod.js
 *			By:	Mark Crossley
 * 		Edited:	2022/07/26 23:48:42 
 *  ----------------------------------------------------------
 *  Changelog (NT)
 * 	Removed api call for version data - now in Page-Manager.js
 * 	Altered all API calls to use host root
 *  Made calendar popups autoclose
 *  Added routine to change '-' to 'No data ' as required
 * -----------------------------------------------------------
*/

$(document).ready(function() {

    $('.loading-overlay').show();

    var now = new Date();
    now.setHours(0,0,0,0);

    var fromDate = $('#dateFrom').datepicker({
            dateFormat: 'dd-mm-yy',
            maxDate: '-1d',
            firstDay: 1,
            changeMonth: true,
            changeYear: true,
            autoclose: true
         }).val(formatUserDateStr(now))
        .on('change', function() {
            var date = fromDate.datepicker('getDate');
            if (toDate.datepicker('getDate') < date) {
                toDate.datepicker('setDate', date);
            }
            toDate.datepicker('option', { minDate: date });
        });

    var toDate = $('#dateTo').datepicker({
            dateFormat: 'dd-mm-yy',
            maxDate: '-1d',
            firstDay: 1,
            changeMonth: true,
            changeYear: true,
            autoclose: true
        }).val(formatUserDateStr(now))
        .on('change', function() {
            var date = fromDate.datepicker('getDate');
            if (toDate.datepicker('getDate') < date) {
                toDate.datepicker('setDate', date);
            }
            toDate.datepicker('option', { minDate: date });
        });

    fromDate.datepicker('setDate', now);
    toDate.datepicker('setDate', now);

    $.ajax({
        url: '/api/graphdata/units.json',
        dataType: 'json',
        success: function (result) {
            $.each(result, function(key, value) {
                $('.unit-' + key).text(value);
            });
        }
    });

    $.ajax({
        url: '/api/settings/dateformat.txt',
        dataType: 'text',
        success: function (result) {
            // we want all lower case and yy for the year not yyyy
            var format = result.toLowerCase().replace('yyyy','yy');
            fromDate.datepicker('option', 'dateFormat', format);
            toDate.datepicker('option', 'dateFormat', format);
        }
    });
    load();
});


function load() {
    var startDate = $('#dateFrom').datepicker('getDate');
    var endDate = $('#dateTo').datepicker('getDate');
    $.ajax({
        url: '/api/records/thisperiod?startdate=' + formatDateStr(startDate) + '&enddate=' + formatDateStr(endDate),
        dataType: 'json',
        success: function (result) {
            $.each(result, function(key, value) {
                // convert the date time to local format
                /*if (key.includes('Time') && value != '-') {
                    var split = value.split(' ');
                    var date = split[0].split('/');
                    var time = split.length === 1 ? null : split[1].split(':');

                    if (time == null ) {
                        if (date.length === 2) {
                            var d = new Date(date[1], date[0] - 1);
                            value = d.toLocaleDateString(userLocale, {year: 'numeric', month: 'long'});
                        } else {
                            var d = new Date(date[2], date[1] - 1, date[0]);
                            value = d.toLocaleDateString(userLocale, {year: 'numeric', month: 'short', day: '2-digit'});
                        }
                    } else {
                        var d = new Date(date[2], date[1] - 1, date[0], time[0], time[1]);
                        value = d.toLocaleDateString(userLocale, {year: 'numeric', month: 'short', day: '2-digit'}) + " " + d.toLocaleTimeString();
                    }
                }*/
                if (value === '-') {
                    value = "No data ";
                }
                $('#' + key).text(value);
            });
            $('.loading-overlay').hide();
        }
    });
}

function formatDateStr(inDate) {
    return '' + inDate.getFullYear() + '-' + (inDate.getMonth() + 1) + '-' + (inDate.getDate());
}

function formatUserDateStr(inDate) {
    return  addLeadingZeros(inDate.getDate()) + '-' + addLeadingZeros(inDate.getMonth() + 1) + '-' + inDate.getFullYear();
}

function addLeadingZeros(n) {
    return n <= 9 ? '0' + n : n;
}

