/*	--------------------------------------------------
 *	Script:	    records.js
 *  Author:     Neil Thomas
 *  Last Edit:  10th Feb 2023
 *	Based on:   /js/records.js
 *          by:	Mark Crossley
 *      Edited: 2021/05/16 20:55:18
 *  -------------------------------------------------
 *  Changelog (NT)
 * 	Altered all API calls to use host root
 * --------------------------------------------------*/


$(document).ready(function () {
    var tempTable=$('#temperature').dataTable({
        "paging": false,
        "searching": false,
        "info": false,
        "ordering": false,
        "columns": [{"width": "40%"}, {"width": "15%"}, null],
        "columnDefs": [
            {"className": "left", "targets": [0,2]},
            {"className": "w3-center", "targets": [1]}
        ],
        "ajax": '/api/records/alltime/temperature.json'
    });

    var humTable=$('#humidity').dataTable({
        "paging": false,
        "searching": false,
        "info": false,
        "ordering": false,
        "columns": [{"width": "40%"}, {"width": "15%"}, null],
        "columnDefs": [
            {"className": "left", "targets": [0,2]},
            {"className": "right", "targets": [1]}
        ],
        "ajax": '/api/records/alltime/humidity.json'
    });

    var pressTable=$('#pressure').dataTable({
        "paging": false,
        "searching": false,
        "info": false,
        "ordering": false,
        "columns": [{"width": "40%"}, {"width": "15%"}, null],
        "columnDefs": [
            {"className": "left", "targets": [0,2]},
            {"className": "right", "targets": [1]}
        ],
        "ajax": '/api/records/alltime/pressure.json'
    });

    var windTable=$('#wind').dataTable({
        "paging": false,
        "searching": false,
        "info": false,
        "ordering": false,
        "columns": [{"width": "40%"}, {"width": "15%"}, null],
        "columnDefs": [
            {"className": "left", "targets": [0,2]},
            {"className": "right", "targets": [1]}
        ],
        "ajax": '/api/records/alltime/wind.json'
    });

    var rainTable=$('#rain').dataTable({
        "paging": false,
        "searching": false,
        "info": false,
        "ordering": false,
        "columns": [{"width": "40%"}, {"width": "15%"}, null],
        "columnDefs": [
            {"className": "left", "targets": [0,2]},
            {"className": "right", "targets": [1]}
        ],
        "ajax": '/api/records/alltime/rain.json'
    });

	$("#Period").html("All-time");

    $(document).ready(function () {
        $('.period').click(function () {
			var periods = {"alltime":"All Time","thismonth":"this Month","thisyear":"this Year","1":"Jan","2":"Feb","3":"Mar","4":"Apr","5":"May","6":"Jun"};
			var months1 = {"1":"January","2":"February","3":"March","4":"April","5":"May","6":"June"};
			var months2 = {"7":"July","8":"August","9":"September","10":"October","11":"November","12":"December"};
			$.extend(periods, months1, months2);
			switch (this.name) {
				case 'alltime':
				case 'thisyear':
				case 'thismonth':
					urlPrefix = "/api/records/" + this.name ;
					break;
				default:
					urlPrefix = "/api/records/month/" + this.name;
			}
			$("#Period").html( periods[ this.name ]);
			tempTable.api().ajax.url( urlPrefix + '/temperature.json' ).load();
            humTable.api().ajax.url(  urlPrefix + '/humidity.json' ).load();
            pressTable.api().ajax.url( urlPrefix + '/pressure.json' ).load();
            windTable.api().ajax.url( urlPrefix + '/wind.json' ).load();
            rainTable.api().ajax.url( urlPrefix + '/rain.json' ).load();
        });

    });
});

