/*	--------------------------------------------------
 *	Script:	    datalogs.js
 *  Author:     Neil Thomas
 *  Last Edit:  7th Mar 2023
 *	Based on:   /js/datalogs.js
 *          By: Mark Crossley
 *      Edited: 2022/11/23 16:10:52 
 * -------------------------------------------------
 * Changelog (NT)
 * 	Removed API call for version data - now in Page-Manager.js
 * 	Altered all API calls to use host root
 * 	Added 'then' date to enable from date to default to 1 day earlier
 * 	Added 'autoclose' to both calendars
 * 	Modified 'fromDate' calendar to prevent false readings of 'toDate'
 * 	Added 'className's to table data to display units.
 *  Added FixedColumns: 2 to the generated table
 * -------------------------------------------------------------------*/


var myTable;
var currMonth;
$(document).ready(function () {

    $.fn.dataTable.ext.errMode = 'none';

    var now = new Date();
    now.setHours(0,0,0,0);
    var then = new Date(now.getFullYear(), now.getMonth(), now.getDate() - 1);
    then.setHours(0,0,0,0);

    var fromDate = $('#dateFrom').datepicker({
            dateFormat: 'dd-mm-yy',
            maxDate: '0d',
            firstDay: 1,
            changeMonth: true,
            changeYear: true,
            autoclose: true,
         }).val(formatUserDateStr(then))
        .on('change', function() {
            var date = fromDate.datepicker('getDate');
            if (toDate.datepicker('getDate') < date) {
                toDate.datepicker('setDate', date);
            }
            toDate.datepicker('option', { minDate: date });
        });

    var toDate = $('#dateTo').datepicker({
            dateFormat: "dd-mm-yy",
            maxDate: '0d',
            firstDay: 1,
            changeMonth: true,
            changeYear: true,
            autoclose: true,
        }).val(formatUserDateStr(now))
        .on('change', function() {
            var date = fromDate.datepicker('getDate');
            if (toDate.datepicker('getDate') < date) {
                toDate.datepicker('setDate', date);
            }
            toDate.datepicker('option', { minDate: date });
        });

    fromDate.datepicker('setDate', then);
    toDate.datepicker('setDate', now);

    $.ajax({
        url: '/api/settings/dateformat.txt',
        dataType: 'text',
        success: function (result) {
            // we want all lower case and yy for the year not yyyy
            var format = result.toLowerCase().replace('yyyy','yy');
            fromDate.datepicker('option', 'dateFormat', format);
            toDate.datepicker('option', 'dateFormat', format);
        }
    });

    var columnDefs = [
        {
            title: "Line No.",
            readonly: true
        },
        {
            title: "Date (dd/mm/yy)",
            readonly: true
        },
        {
            title: "Time",
            readonly: true
        },
        {title: "Temp", className:"tempUnits"},
        {title: "Hum", className:"percent"},
        {title: "Dew point", className:"tempUnits"},
        {title: "Wind speed", className:"windUnits"},
        {title: "Recent high gust", className:"windUnits"},
        {title: "Average wind bearing", className:"bearing"},
        {title: "Rainfall rate", className:"rainUnits"},
        {title: "Rainfall so far", className:"rainUnits"},
        {title: "Sea level pressure", className:"pressUnits"},
        {title: "Rainfall counter"},
        {title: "Inside temp", className:"tempUnits"},
        {title: "Inside hum", className:"percent"},
        {title: "Current gust", className:"windUnits"},
        {title: "Wind chill", className:"tempUnits"},
        {title: "Heat Index", className:"tempUnits"},
        {title: "UV Index"},
        {title: "Solar Rad", className:"solarUnits"},
        {title: "ET"},
        {title: "Annual ET"},
        {title: "Apparent temp", className:"tempUnits"},
        {title: "Max Solar rad", className:"solarUnits"},
        {title: "Sun hours", className:"hours"},
        {title: "Wind bearing", className:"hours"},
        {title: "RG-11 Rain", className:"rainUnits"},
        {title: "Rain Since Midnight", className:"rainUnits"},
        {title: "Feels like", className:"tempUnits"},
        {title: "Humidex"}
    ];

    myTable = $('#datalog').dataTable({
        pagingType: "input",
        processing: true,
        serverSide: true,
        searching: true,
        searchDelay: 750,
        ordering: false,
        pageLength: 10,
        lengthMenu: [10,20,50,100],
        fixedColumns: { left: 3 },
        ajax: {
            url: "/api/data/logfile?from="+formatDateStr(now)+"&to="+formatDateStr(now),
            data: function (data) {
                delete data.columns;
            }
        },
        deferLoading: 0,
        columns: columnDefs,
        dom: '<"top"Bfip<"clear">>t<"bottom"fip<"clear">>',
        select: 'single',
        responsive: false,
        altEditor: true,     // Enable altEditor
        buttons: [
            {
                extend: 'selected', // Bind to Selected row
                text: 'Edit',
                name: 'edit'        // do not change name
            },
            {
                extend: 'selected', // Bind to Selected row
                text: 'Delete',
                name: 'delete'      // do not change name
            },
            {
                text: 'Refresh',
                name: 'refresh'      // do not change name
            },
            'pageLength'
        ],
        language: {
            altEditor: {
                modalClose: 'Close',
                edit: {
                    title: 'Edit record',
                    button: 'Save'
                }
            }
        },
        onEditRow: function(datatable, rowdata, success, error) {
            var selector = datatable.modal_selector;
            $(selector + ' .modal-body .alert').remove();

            $.ajax({
                url: "/api/edit/datalogs",
                type: 'POST',
                data: formatResponse("Edit", rowdata),
                success: success,
                error: function(response, status, more) {
                    // Output the error message
                    var selector = datatable.modal_selector;
                    $(selector + ' .modal-body .alert').remove();
                    var message = '<div class="alert alert-danger" role="alert">' +
                    '<strong>' + datatable.language.error.label + '</strong> ';
                    for (var key in response.responseJSON.errors) {
                        message += response.responseJSON.errors[key][0];
                    }
                    message +='</div>';
                    $(selector + ' .modal-body').append(message);

                    // error 501 means MySQL failed but file update was OK
                    if (response.status == 501) {
                        // We have updated the dayfile data, so update the form
                        datatable.s.dt.row(response.responseJSON.data[0]).data(response.responseJSON.data);
                        datatable.s.dt.draw('page');
                    }
                }
            });
        },
        onDeleteRow: function(datatable, rowdata, success, error) {
            $.ajax({
                url: "/api/edit/datalogs",
                type: 'POST',
                data: formatResponse("Delete", rowdata),
                success: success,
                error: error
            });
        }
    });

    function formatResponse(action, rowdata) {
        response = '{"action":"' + action + '","line":' + rowdata[0] + ',"date":"' + rowdata[1] + '","extra":"false","data": [';
        for (var key in rowdata) {
            if (!isNaN(key) && key > 0) {
                response += '"' + rowdata[key] + '",';
            }
        }
        // remove trailing comma
        response = response.slice(0, -1);
        response += ']}';
        return response;
    };
    $(".dt-button").addClass("ai-thin");
    load();
});

function load() {
    var startDate = $("#dateFrom").datepicker('getDate');
    var endDate = $("#dateTo").datepicker('getDate');
    myTable.api().ajax.url('/api/data/logfile'+'?from='+formatDateStr(startDate)+'&to='+formatDateStr(endDate)).load();
}

function formatDateStr(inDate) {
    return '' + inDate.getFullYear() + '-' + (inDate.getMonth() + 1) + '-' + (inDate.getDate());
}

function formatUserDateStr(inDate) {
    return  addLeadingZeros(inDate.getDate()) + '-' + addLeadingZeros(inDate.getMonth() + 1) + '-' + inDate.getFullYear();
}

function addLeadingZeros(n) {
    return n <= 9 ? '0' + n : n;
}
