/*	-------------------------------------------------
 * 	Script:	utils_all.js
 *	Role:	Initiate an FTP upload of selected files,
 * 			Reload Dayfile AND/OR purge MySQL queue
 * 	Version:	1.0.3-ai
 * 	------------------------------------------------*/

$(document).ready( function() {
    $("#startFtp").click(function(event) {
	$('#ftp_status').text('Running...');
	$.post(
	    "/api/utils/ftpnow.json",
		{data: "{'dailygraphs':" + $('#dailygraphs').prop('checked') + "}"},
	    ).done(function (response) {
		$('#ftp_status').text(response.result)
	    }).fail(function (jqXHR, response) {
		$('#ftp_status').text(response)
	    });
	timeOut("ftp_status");
	});

    $("#reload").click(function(event) {
	$('#dayfile_status').text('Re-loading');
        $.ajax({
            url: "/api/utils/reloaddayfile",
            dataType: 'text'
        })
        .done(function (response) {
            $('#dayfile_status').text(response)
        })
        .fail(function (jqXHR, response) {
            $('#dayfile_status').text(response)
        });
	timeOut("dayfile_status");
    });

    $("#purge").click(function(event) {
	$('#purge_status').text('Purging MySQL tables');
        $.ajax({
            url: "/api/utils/purgemysql",
            dataType: 'text'
        })
        .done(function (response) {
            $('#purge_status').text(response)
        })
        .fail(function (jqXHR, response) {
            $('#purge_status').text(response)
        });
	timeOut("purge_status");
    });
    
        var columnDefs = [{
        title: "Key",
        readonly: true
    }, {
        title: 'MySQL Statement',
        type: 'textarea'
    }];

    var myTable = $('#sqlcache').DataTable({
        pagingType: 'input',
        processing: true,
        serverSide: true,
        searching: true,
        searchDelay: 750,
        ordering: false,
        pageLength: 10,
        lengthMenu: [10,20,50,100],
        autoWidth: false,
        rowId: 'key',
        ajax: {
            url: '/api/data/mysqlcache.json',
            data: function (data) {
                delete data.columns;
            }
        },
        columns: columnDefs,
        dom: '<"top"Bfip<"clear">>t<"bottom"fip<"clear">>',
        select: 'single',
        responsive: false,
        altEditor: true,     // Enable altEditor
        buttons: [
            {
                extend: 'selected', // Bind to Selected row
                text: 'Edit',
                name: 'edit'        // do not change name
            },
            {
                extend: 'selected', // Bind to Selected row
                text: 'Delete',
                name: 'delete'      // do not change name
            },
            {
                text: 'Refresh',
                name: 'refresh'      // do not change name
            },
            'pageLength'
        ],
        language: {
            altEditor: {
                modalClose: 'Close',
                edit: {
                    title: 'Edit record',
                    button: 'Save'
                }
            }
        },
        onEditRow: function(datatable, rowdata, success, error) {
            var selector = datatable.modal_selector;
            $(selector + ' .modal-body .alert').remove();

            $.ajax({
                url: '/api/edit/mysqlcache',
                type: 'POST',
                data: formatResponse('Edit', rowdata),
                success: success,
                error: function(response, status, more) {
                    // Output the error message
                    var selector = datatable.modal_selector;
                    $(selector + ' .modal-body .alert').remove();
                    var message = '<div class="alert alert-danger" role="alert">' +
                    '<strong>' + datatable.language.error.label + '</strong> ';
                    for (var key in response.responseJSON.errors) {
                        message += response.responseJSON.errors[key][0];
                    }
                    message +='</div>';
                    $(selector + ' .modal-body').append(message);

                    // error 501 means MySQL failed but file update was OK
                    if (response.status == 501) {
                        // We have updated the dayfile data, so update the form
                        datatable.s.dt.row(response.responseJSON.data[0]).data(response.responseJSON.data);
                        datatable.s.dt.draw('page');
                    }
                }
            });
        },
        onDeleteRow: function(datatable, rowdata, success, error) {
            $.ajax({
                url: '/api/edit/mysqlcache',
                type: 'POST',
                data: formatResponse('Delete', rowdata),
                success: success,
                error: error
            });
        }
    });

    function formatResponse(action, rowdata) {
        response = '{"action":"' + action + '","line":' + rowdata[0] + ',"data": [';
        for (var key in rowdata) {
            if (!isNaN(key) && key > 0) {
                response += '"' + rowdata[key] + '",';
            }
        }
        // remove trailing comma
        response = response.slice(0, -1);
        response += ']}';
        return response;
    }
});

//  --  Timout for status messages        
let timeOut = function(elId) {
    window.setTimeout( function(){$("#" + elId).html("&nbsp;");}, 8000);
};
