/*  ----------------------------------------------------------------
 *  Script: AI-Config.js      v:0.0.1     A:Neil Thomas
 *  Role:   To enable users to manage the theme dynamicaly and to
 * 			change to the current theme on any page running the
 * 			Page-Manager.js script.
 *  Option: An element with the ID ThemeSelector if the user is
 *          allowed to change theme on that page
 *  --------------------------------------------------------------- */

// theme - an array of the colours (css) that you allow - first one is YOUR default - MUST be at least one
let themes = ["AlmondBuff", "AlmostMauve", "Arcadia", "BasicGrey", "CherryTomato", "ChiliOil", "colours",
			  "CrocusPetal", "CylonYellow","Emporador", "GreyBlue", "GreyGreen", "GreyRed", "HarbourMist", "Limelight",
			  "LimePunch", "Marsala", "MartiniOlive", "MeerKat", "NebulasBlue", "QuietGrey", "RedPear", "RussetOrange",
			  "SailorBlue", "SargassoSea", "SlateGrey", "SpringCrocus", "Tofu", "UltraViolet", "ValiantPoppy", "WarmSand"];

let currentTheme;  // Global theme variable - not required, available in AIConfig.Theme

$(document).ready( function() {
    //console.log("AIConfig containes: " + JSON.stringify(AIConfig));
    populateSelector('ThemeSelector', AIConfig.Theme);

    if( typeof(Storage) !== "undefined" ) {
        if ( $('#ThemeSelector').length) {
	    console.log("Theme changes available");
        } else {
            console.log("Theme changes disabled.");
        }
    } else {
        console.log("Browser doesn't support storage")
        $("#ThemeSelector").html("Sorry but your browser doesn't support theme changes.")
    }
    readSettings();
})

let readSettings = function() {
    $('#TopMargin').val(AIConfig.TopMargin );
    $('#BottomMargin').val(AIConfig.BottomMargin);
    if( AIConfig.StaticHead ) {
	$('#BannerState').prop('checked', 'checked');
    } else {
	$('#BannerState').prop('checked','');
    }
    if( AIConfig.StaticFoot ) {
	$('#FooterState').prop('checked', 'checked');
    } else {
	$('#FooterState').prop('checked','');
    }
    Top_N_Tail();
};

let populateSelector = function(elem, activeTheme) {
    var selector = '<select id="ThemeList" class="w3-select w3-theme w3-theme-d5-hvr" style="max-width:130px;">\n';
    for ( var theme = 0; theme < themes.length; theme++ ) {
        selector += '<option value="' + themes[theme] + '"' + (activeTheme == themes[theme] ? " selected" : "") + '>' + themes[theme] + '</option>\n';
    }
    //  End required selector html
    selector += "</select>\n";
    $('#' + elem).html(selector);
};

let viewChanges = function() {
    var tempMargin = parseInt($('#TopMargin').val());
    if( $('#BannerState').is(':checked' ) ) {
	$('#Banner').addClass('w3-top');
	tempMargin += HeaderHeight;
	$('#Content').css('margin-top', tempMargin + 'px');
    } else {
	$('#Banner').removeClass('w3-top');
	$('#Content').css('margin-top', tempMargin );
    }
    tempMargin = parseInt($('#BottomMargin').val());
    if( $('#FooterState').is(':checked') ) {
	$('#Footer').addClass('w3-bottom');
	tempMargin += FooterHeight;
	$('#Content').css('margin-bottom', tempMargin);
    } else {
	$('#Footer').removeClass('w3-bottom');
	$('#Content').css( 'margin-bottom', tempMargin );
    }
    //console.log("Selected theme: " + $('#ThemeList').val());
    var reqTheme = $('#ThemeList').val();
    $('head').append('<link href="css/' + reqTheme + '.css" rel="stylesheet" type="text/css">');
};

let setScheme = function() {
    var marginTop = parseInt($('#TopMargin').val());
    var marginBottom = parseInt($('#BottomMargin').val());
    var reqTheme = $('#ThemeList').val();
    var head = $('#BannerState').is(':checked');
    var foot = $('#FooterState').is(':checked');
    var newConfig = {'Theme': reqTheme, 'StaticHead': head, 'StaticFoot': foot, 'TopMargin': marginTop, 'BottomMargin': marginBottom };
    localStorage.setItem( "CMXai", JSON.stringify( newConfig ));
    alert("Selected configuration set for all pages.");
};

var clearScheme = function() {
   localStorage.removeItem("CMXai");
   alert("Saved configuration removed");
   window.location.assign("AI-Config.html");
};

