/*	--------------------------------------------------
 * 	noaamonthreport.js
 * 	Extraction of javascript from noaamonthreport.html
 * 	-------------------------------------------------- */

var thisYear;
var thisMonth;
var startYear;
var startMonth;


$(document).ready(function () {

    $.ajax({
        url: '/api/tags/process.txt',
        dataType: 'json',
        type: 'POST',
        data: '{"month": <#recordsbegandate format="%M">, "year": <#recordsbegandate format="yyyy">}'
    })
    .done(function (result) {
        var now = new Date();
        // subtract 1 day
        now.setTime(now.getTime()-(1*24*3600000));
        thisYear = now.getFullYear();
        thisMonth = now.getMonth() + 1;
        startMonth =  result.month;
        startYear = result.year;

        for (var i = thisYear; i >= startYear; i--) {
            $('#selYear').append($('<option>', {
                value: i,
                text: i
            }));
        }

        changeYear();

        load();
    });

    $('#selYear').on('change', function () {
        changeYear();
        load();
    });
    
    $('#selMonth').on('change', function () {
        load();
    });

});

function changeYear() {
    var year = $('#selYear').val();
    var firstMonth = 1;
    var lastMonth = 12;
    if (year == thisYear) {
        lastMonth = thisMonth;
    }
    if (year == startYear) {
        firstMonth = startMonth;
    }

    var now = new Date();
    // subtract 1 day
    now.setTime(now.getTime()-(1*24*3600000));

    $('#selMonth').empty();

    for (var i = firstMonth; i <= lastMonth; i++) {
        now.setMonth(i - 1);
        $('#selMonth').append($('<option>', {
            value: i,
            text: now.toLocaleString('default', {month: "long"}),
            selected: year == thisYear && i === thisMonth
        }));
    }
}

function load() {
    var year = $('#selYear').val();
    var month = $('#selMonth').val();
    $.ajax({
        url: '/api/reports/noaamonth?year='+year+'&month='+month,
    })
    .done(function(data) {
        $('#report').text(data);
    })
    .fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}

function generate() {
    var year = $('#selYear').val();
    var month = $('#selMonth').val();
    $.ajax({
        url: '/api/genreports/noaamonth?year='+year+'&month='+month
    })
    .done(function(data) {
        $('#report').text(data);
        alert("Report (Re)generated");
    })
    .fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}

