/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Script:	ows-menu.js			*		Ver: 5.0.0
  Author:	Neil Thomas			*	  October 2025
  Created:	M.Crossley.
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Last Ed:	2025-10-01 15:39:06
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Role:
  Menu configuration file for NEW CumulusMX alternative public website

  It is STRONGLY RECOMMENDED that if you customise this file, you create a new file 
  with a different name, e.g. mymenu.js and change cmxConfig in page-manager.js to 
  use that file. This will avoid your customisations being accidentally overwritten 
  during upgrades
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Properties:
   .title			- This is what appears in the displayed menu.  Note that it can contain html.
   .url				- This is the html address of the required page.  If it is external it will need to be the
					  FULL url starting with http....
					  It can be a '_' character in which case it will be replaced with a menu bar to separate
					  sections of your drop down.  ONLY use in sub-menus.
   .icon            - Font Awsome icon to use or ommitted is none required - use both classes from Font Awsome
   .new_window:true - forces the link to open in new browser window
   .forum:true      - flags a forum link menu item, it will use the url provided in CumulusMX config, if that 
   					  is blank the menu item will be hidden
   .webcam:true     - flags a webcam link menu item, it will use the url provided in CumulusMX config, if that
    				  is blank the menu item will be hidden
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

menuSrc = [
	{title: "Dashboard",	url: "index.html"},
	{title: "Today",		url: "today.html"},
	{title: "Yesterday",	url: "yesterday.html"},
	{title: "Today v Yesterday",	url: "todayVyest.html"},
	{title: "Gauges",			url: "gauges.html"},
	{title: "Weather Records",	subMenu: true,	items: [
		{title: "This Month",   url: "recordsthismonth.html",    icon: "fa-solid fa-list"},
		{title: "This Year",    url: "recordsthisyear.html",     icon: "fa-solid fa-list-ul"},
		{title: "All Time",     url: "recordsalltime.html",      icon: "fa-solid fa-list"},
		{title: "Monthly",      url: "recordsmonthly.html",      icon: "fa-solid fa-list"},
		{title: "",				url: ""},
		{title:	"All records",	url: "recordsall.html",          icon: "fa-solid fa-list"}
	]},
	{title: "Charts",       	subMenu: true,  icon: "fa-solid fa-chart-simple",  items: [
		{title: "Trends",       url: "chartstrends.html",    icon: "fa-solid fa-chart-line"},
		{title: "Select-a-graph",url: "chartsselect.html",   icon: "fa-solid fa-chart-line"},
		{title: "Historic",     url: "chartshistoric.html",  icon: "fa-solid fa-chart-column"}
	]},
	{title: "Reports",   		url: "noaareports.html"},
	{title: "Forum",     	    url: "#",    forum: true,    icon: "fa-solid fa-people-group fa-xs", new_window: true},
	{title: "Webcam",    		url: "#",    webcam: true, 	 icon: "fa-solid fa-camera fa-xs"}
];