/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Script:	chartstrends.js     *        v:5.0.1
  Author:	Neil Thomas		    *   October 2025
  Original: M Crossley, 2025/09/03 16:13:24
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Last Ed:	2025-09-11 12:54:26
  Role:     Draw charts based on readings
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

var chart, config, avail;

//	Added by NT
var myTooltipHead = '<h4 class="ows-theme1"">{point.key}</h4><div class="grid">';
var myTooltipPoint = '<div><i class="fa-solid fa-diamond fa-xs" style="color:{series.color}"></i>&nbsp;{series.name}</div>' +
                   '<div><strong>{point.y}</strong></div>';

var beaufortScale, beaufortDesc, chillZone, freezing;
beaufortDesc = ['Calm','Light Air','Light breeze','Gentle breeze','Moderate breeze','Fresh breeze','Strong breeze','Near gale','Gale','Strong gale','Storm','Violent storm','Hurricane'];
var noData = '<div class="err">No Data found</div>';
//	End section added ny NT

var myRangeBtns = {
    buttons: [{
        count: 12,
        type: 'hour',
        text: '12h'
    }, {
        count: 24,
        type: 'hour',
        text: '24h'
    }, {
        count: 2,
        type: 'day',
        text: '2d'
    }, {
        type: 'all',
        text: 'All'
    }],
    inputEnabled: false,
    selected: 1
};
//console.log("Config: " + JSON.stringify(cmxConfig));
dataPath = cmxConfig.Data + '/';
$().ready(function () {
    /*$('#mySelect').change(function () {
        changeGraph($('#mySelect').val()); 
    });
    */
    $('#graphSelect').children().on('click', function() {
		cmxConfig.Charts.Trends = this.id;
		sessionStorage.setItem(owsStore, JSON.stringify( cmxConfig ) );
        changeGraph( this.id );
	});

    const availRes = $.ajax({ url: dataPath + 'availabledata.json', dataType: 'json' });
    const configRes = $.ajax({ url: dataPath + 'graphconfig.json', dataType: 'json' });

    Promise.all([availRes, configRes])
    .then(function (results) {
        avail = results[0];
        config = results[1];

        Highcharts.setOptions({
            credits: {
                enabled: true
            },
            time: {
                timezone: config.tz
            },
            chart: {
                zooming: {
                    key: 'ctrl',
                    pinchType: 'x',
                    type: 'x'
                }
            },
            legend: { margin: 20 },
            xAxis: {
                type: 'datetime',
                ordinal: false,
                dateTimeLabelFormats: {
                    hour: config.timeformat,
                    day: '%e %b',
                    week: '%e %b %y',
                    month: '%b %y',
                    year: '%Y'
                }
            },
            navigator: {
                xAxis: {
                    dateTimeLabelFormats: {
                        hour: config.timeformat
                    }
                }
            },
            tooltip: {
                shared: true,
                crosshairs: true,
                split: false,
                className: 'ows-ToolTip',
                useHTML: true,
                headerFormat: myTooltipHead,
                pointFormat: myTooltipPoint,
                footerFormat: '</div>',
                dateTimeLabelFormats: {
                    hour: config.timeformat
                },
                xDateFormat: "%a, %b %e, " + config.timeformat
            }
        });

        if (avail.Temperature === undefined || avail.Temperature.Count == 0) {
            $('#temp').remove();
        }
        if (avail.DailyTemps === undefined || avail.DailyTemps.Count == 0) {
            $('#dailytemp').remove();
        }
        if (avail.Humidity === undefined || avail.Humidity.Count == 0) {
            $('#humidity').remove();
        }
        if (avail.Solar === undefined || avail.Solar.Count == 0) {
            $('#solar').remove();
        }
        if (avail.Sunshine === undefined || avail.Sunshine.Count == 0) {
            $('#sunhours').remove();
        }
        if (avail.AirQuality === undefined || avail.AirQuality.Count == 0) {
            $('#airquality').remove();
        }
        if (avail.ExtraTemp == undefined || avail.ExtraTemp.Count == 0) {
            $('#extratemp').remove();
        }
        if (avail.ExtraHum == undefined || avail.ExtraHum.Count == 0) {
            $('#extrahum').remove();
        }
        if (avail.ExtraDewPoint == undefined || avail.ExtraDewPoint.Count == 0) {
            $('#extradew').remove();
        }
        if (avail.SoilTemp == undefined || avail.SoilTemp.Count == 0) {
            $('#soiltemp').remove();
        }
        if (avail.SoilMoist == undefined || avail.SoilMoist.Count == 0) {
            $('#soilmoist').remove();
        }
        if (avail.LeafWetness == undefined || avail.LeafWetness.Count == 0) {
            $('#leafwet').remove();
        }
        if (avail.UserTemp == undefined || avail.UserTemp.Count == 0) {
            $('#usertemp').remove();
        }
        if (avail.CO2 == undefined || avail.CO2.Count == 0) {
            $('#co2').remove();
        }

        chillZone = config.temp.units === 'C' ? 4 : parseInt(4  * 9 / 5 + 32 );

        freezing = config.temp.units === 'C' ? 0 : 32 ;

        switch( config.wind.units) {
            case 'mph': beaufortScale = [ 1, 3, 7,12,18,24,31,38,46,54, 63, 72]; break;
			case 'km/h':  beaufortScale = [ 2, 5,11,19,29,39,50,61,74,87,101,116]; break;
			case 'm/s':   beaufortScale = [ 0, 0, 1, 1, 2, 3, 4, 5, 7,10, 12, 16]; break;
			case 'knots': beaufortScale = [ 3, 6,10,16,21,27,33,40,47,55, 63, 65]; break;
			default: 	  beaufortScale = [-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, -1, -1];
			// NOTE: Using -1 means the line will never be seen.  No line is drawn for Hurricane.
        }
        /*
        var value = parent.location.hash.replace('#', '');
        if (value == '')
            value = 'temp';
        */

        cmxConfig = JSON.parse(sessionStorage.getItem(owsStore));
        var value = cmxConfig.Charts.Trends;
        if( value ==='') {
            value = 'temp';
        } else {
            value = cmxConfig.Charts.Trends;
        }

        changeGraph(value);
        // set the correct option
        $('#mySelect option[value="' + value + '"]').attr('selected', true);
    });
});


function changeGraph(graph) {
    //  Process chart selection
    $('#graphSelect').children().removeClass('w3-disabled');
    $('#' + graph).addClass('w3-disabled');
    switch (graph) {
        case 'temp':        doTemp();       break;
        case 'dailytemp':   doDailyTemp();  break;
        case 'press':       doPress();      break;
        case 'wind':        doWind();       break;
        case 'windDir':     doWindDir();    break;
        case 'rain':        doRain();       break;
        case 'dailyrain':   doDailyRain();  break;
        case 'humidity':    doHum();        break;
        case 'solar':       doSolar();      break;
        case 'sunhours':    doSunHours();   break;
        case 'airquality':  doAirQuality(); break;
        case 'extratemp':   doExtraTemp();  break;
        case 'extrahum':    doExtraHum();   break;
        case 'extradew':    doExtraDew();   break;
        case 'soiltemp':    doSoilTemp();   break;
        case 'soilmoist':   doSoilMoist();  break;
        case 'leafwet':     doLeafWet();    break;
        case 'usertemp':    doUserTemp();   break;
        case 'co2':         doCO2();        break;
        default:
            doTemp();
            break;
        }
        //parent.location.hash = graph;
}

var doTemp = function () {
    //var freezing = config.temp.units === 'C' ? 0 : 32;
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'line',
            alignTicks: false
        },
        title: {
            text: 'Temperature'
        },
        yAxis: [{
            // left
            title: {
                text: 'Temperature (°' + config.temp.units + ')'
            },
            opposite: false,
            labels: {
                align: 'right',
                x: -5,
                formatter: function () {
                    return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                }
            },
            plotLines: [{
                // freezing line
                value: freezing,
                color: 'rgb(0, 0, 180)',
                width: 1,
                zIndex: 2
            },{
                value: chillZone,
                color: 'rgb(0, 0, 255)',
                width: 1,
                zIndex: 2,
                label: { text: 'Chill zone', x: 30, y: 12, style:{ color:'var(--color5)'}}
            }]
        }, {
            // right
            gridLineWidth: 0,
            linkedTo: 0,
            opposite: true,
            labels: {
                align: 'left',
                x: 5,
                formatter: function () {
                    return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                }
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {
                lineWidth: 2
            }
        },
        tooltip: {
            valueDecimals: config.temp.decimals
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'tempdata.json',
        cache: false,
        dataType: 'json',
        success: function (resp) {
            var titles = {
                'temp'     : 'Temperature',
                'dew'      : 'Dew Point',
                'apptemp'  : 'Apparent',
                'feelslike': 'Feels Like',
                'wchill'   : 'Wind Chill',
                'heatindex': 'Heat Index',
                'humidex'  : 'Humidex',
                'intemp'   : 'Inside'
            };
            var idxs = ['temp', 'dew', 'apptemp', 'feelslike', 'wchill', 'heatindex', 'humidex', 'intemp'];
            var yaxis = 0;

            idxs.forEach(function(idx) {
                var valueSuffix = ' °' + config.temp.units;
                yaxis = 0;

                if (idx in resp) {
                    if (idx === 'humidex') {
                        valueSuffix = null;
                        if (config.temp.units == 'F') {
                            chart.yAxis[1].remove();
                            chart.addAxis({
                                id: 'humidex',
                                title:{text: 'Humidex'},
                                opposite: true,
                                labels: {
                                    align: 'left'
                                },
                                alignTicks: true,
                                gridLineWidth: 0, // Not working?
                                gridZIndex: -10, // Hides the grid lines for this axis
                                showEmpty: false
                            }, false, false);

                            yaxis = 'humidex';
                        }
                    }

                    chart.addSeries({
                        name: titles[idx],
                        id: 'series-' + idx,
                        data: resp[idx],
                        color: config.series[idx].colour,
                        yAxis: yaxis,
                        tooltip: {valueSuffix: valueSuffix}
                    }, false);

                    if (idx === 'temp') {
                        chart.get('series-' + idx).options.zIndex = 99;
                    }
                }
            });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doPress = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {
            text: 'Pressure'
        },
        yAxis: [{
            // left
            title: {
                text: 'Pressure (' + config.press.units + ')'
            },
            opposite: false,
            labels: {
                align: 'right',
                x: -5
            }
        }, {
            // right
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            title: {
                text: null
            },
            labels: {
                align: 'left',
                x: 5
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {
                lineWidth: 2
            }
        },
        tooltip: {
            valueSuffix: ' ' + config.press.units,
            valueDecimals: config.press.decimals,
        },
        series: [{
            name: 'Pressure',
            color: config.series.press.colour
    }],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'pressdata.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            chart.hideLoading();
            chart.series[0].setData(resp.press);
        }
    });
};

var compassP = function (deg) {
    var a = ['N', 'NE', 'E', 'SE', 'S', 'SW', 'W', 'NW'];
    return a[Math.floor((deg + 22.5) / 45) % 8];
};

var doWindDir = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'scatter',
            alignTicks: false
        },
        title: {
            text: 'Wind Direction'
        },
        navigator: {
            series: {
                // pseudo scatter
                type: 'line',
                dataGrouping: {
                    groupPixelWidth: 1,
                    anchor: 1
                },
                lineWidth: 0,
                marker   : {
                    // enable the marker to simulate a scatter
                    enabled: true,
                    radius : 1
                }
            }
        },
        yAxis: [{
            // left
            title: {
                text: 'Bearing'
            },
            opposite: false,
            min: 0,
            max: 360,
            tickInterval: 45,
            labels: {
                align: 'right',
                x: -5,
                formatter: function () {
                    return compassP(this.value);
                }
            }
        }, {
            // right
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            title: {
                text: null
            },
            min: 0,
            max: 360,
            tickInterval: 45,
            labels: {
                align: 'left',
                x: 5,
                formatter: function () {
                    return compassP(this.value);
                }
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            scatter: {
                cursor: 'pointer',
                enableMouseTracking: true,
                boostThreshold: 200,
                marker: {
                    states: {
                        hover: {
                            enabled: false
                        },
                        select: {
                            enabled: false
                        }
                    }
                },
                shadow: false,
                label: {
                    enabled: false
                }
            }
        },
        series: [{
            name: 'Bearing',
            type: 'scatter',
            color: config.series.bearing.colour,
            marker: {
                symbol: 'circle',
                radius: 2
            },
            enableMouseTracking: false,
            showInNavigator: false
        }, {
            name: 'Avg Bearing',
            type: 'scatter',
            color: config.series.avgbearing.colour,
            marker: {
                symbol: 'circle',
                radius: 2
            },
            showInNavigator: true,
            tooltip: {
                headerFormat: '',
                pointFormatter() {
                    return '<span style="color:' + this.color + '">\u25CF</span> ' +
                        this.series.name + ': <b>' + (this.y == 0 ? 'calm' : this.y + '°') + '</b><br/>';
                }
            }
        }],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'wdirdata.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            chart.hideLoading();
            chart.series[0].setData(resp.bearing);
            chart.series[1].setData(resp.avgbearing);
        }
    });
};

var doWind = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {
            text: 'Wind Speed'
        },
        yAxis: [{
            // left
            title: {
                text: 'Wind Speed (' + config.wind.units + ')'
            },
            opposite: false,
            min: 0,
            labels: {
                align: 'right',
                x: -5
            },
            plotLines: [{
				value: beaufortScale[1],
				color: 'rgb(255,220,0)', width: 1, zIndex:1,
				label: { text: beaufortDesc[1], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[2],
				color: 'rgb(255,200,0)', width:1, zIndex:1,
				label: {text: beaufortDesc[2], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[3],
				color: 'rgb(255,180,0)', width:1, zIndex:1,
				label: {text: beaufortDesc[3], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[4],
				color: 'rgb(255,160,0)', width:1, zIndex:1,
				label: {text: beaufortDesc[4], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[5],
				color: 'rgb(255,140,0)', width:1, zIndex:1,
				label: {text:beaufortDesc[5], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[6],
				color: 'rgb(255,120,0)', width:1, zIndex:1,
				label: { text: beaufortDesc[6], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[7],
				color: 'rgb(255,100,0)', width:1, zIndex:1,
				label: {text: beaufortDesc[7], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[8],
				color: 'rgb(255,80,0)', width:1, zIndex:1,
				label: {text: beaufortDesc[8], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[9],
				color: 'rgb(255,60,0)', width:1, zIndex:1,
				label: {text: beaufortDesc[9], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[10],
				color: 'rgb(255,40,0)', width:1, zIndex:1,
				label: {text:beaufortDesc[10], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[11],
				color: 'rgb(255,20,0)', width:1, zIndex:1,
				label: { text: beaufortDesc[11], y:12, style:{color:'var(--color5)'}}
			},{
				value: beaufortScale[11],// Note use of previous line
				//color: 'rgb(255,0,0)', width:1, zIndex:12,
				label: {text: beaufortDesc[12]}
			}]
        }, {
            // right
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            min: 0,
            title: {
                text: null
            },
            labels: {
                align: 'left',
                x: 5
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {
                lineWidth: 2
            }
        },
        tooltip: {
            valueSuffix: ' ' + config.wind.units,
        },
        series: [{
            name: 'Wind Speed',
            color: config.series.wspeed.colour,
            tooltip: {
                valueDecimals: config.wind.avgdecimals
            }
        }, {
            name: 'Wind Gust',
            color: config.series.wgust.colour,
            tooltip: {
                valueDecimals: config.wind.gustdecimals
            }
        }],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'winddata.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            chart.hideLoading();
            chart.series[0].setData(resp.wspeed);
            chart.series[1].setData(resp.wgust);
        }
    });
};

var doRain = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'line',
            alignTicks: true
        },
        title: {
            text: 'Rainfall'
        },
        yAxis: [{
            // left
            title: {
                text: 'Rainfall rate (' + config.rain.units + '/hr)'
            },
            min: 0,
            opposite: false,
            labels: {
                align: 'right',
                x: -5
            },
            showEmpty: false
        }, {
            // right
            opposite: true,
            title: {
                text: 'Rainfall (' + config.rain.units + ')'
            },
            min: 0,
            labels: {
                align: 'left',
                x: 5
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                boostThreshold: 0,
                dataGrouping: {
                    enabled: false
                },
                showInNavigator: true,
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {
                lineWidth: 2
            }
        },
        tooltip: {
            valueDecimals: config.rain.decimals,
        },
        series: [{
                name: 'Daily rain',
                type: 'area',
                color: config.series.rfall.colour,
                yAxis: 1,
                tooltip: {valueSuffix: ' ' + config.rain.units},
                fillOpacity: 0.3
            }, {
                name: 'Rain rate',
                type: 'line',
                color: config.series.rrate.colour,
                yAxis: 0,
                tooltip: {valueSuffix: ' ' + config.rain.units + '/hr'}
        }],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'raindata.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            chart.hideLoading();
            chart.series[0].setData(resp.rfall);
            chart.series[1].setData(resp.rrate);
        }
    });
};

var doHum = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'line',
            alignTicks: false
        },
        title: {
            text: 'Relative Humidity'
        },
        yAxis: [{
            // left
            title: {
                text: 'Humidity (%)'
            },
            opposite: false,
            min: 0,
            max: 100,
            labels: {
                align: 'right',
                x: -5
            }
        }, {
            // right
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            min: 0,
            max: 100,
            title: {
                text: null
            },
            labels: {
                align: 'left',
                x: 5
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {
                lineWidth: 2
            }
        },
        tooltip: {
            valueSuffix: ' %',
            valueDecimals: config.hum.decimals,
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'humdata.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            var titles = {
                'hum'  : 'Outdoor Humidity',
                'inhum': 'Indoor Humidity'
             }
             var idxs = ['hum', 'inhum'];
             var cnt = 0;
             idxs.forEach(function(idx) {
                 if (idx in resp) {
                     chart.addSeries({
                         name: titles[idx],
                         color: config.series[idx].colour,
                         data: resp[idx]
                     }, false);

                     cnt++;
                 }
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doSolar = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'line',
            alignTicks: true
        },
        title: {
            text: 'Solar'
        },
        yAxis: [],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                boostThreshold: 0,
                dataGrouping: {
                    enabled: false
                },
                showInNavigator: true,
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {
                lineWidth: 2
            }
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'solardata.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            var titles = {
                SolarRad       : 'Solar Radiation',
                CurrentSolarMax: 'Theoretical Max',
                UV: 'UV Index'
            };
            var types = {
                SolarRad: 'area',
                CurrentSolarMax: 'area',
                UV: 'line'
            };
            var colours = {
                SolarRad: 'rgb(255,165,0)',
                CurrentSolarMax: 'rgb(128,128,128)',
                UV: 'rgb(0,0,255)'
            };
            var tooltips = {
                SolarRad: {
                    valueSuffix: ' W/m\u00B2',
                    valueDecimals: 0
                },
                CurrentSolarMax: {
                    valueSuffix: ' W/m\u00B2',
                    valueDecimals: 0
                },
                UV: {
                    valueSuffix: null,
                    valueDecimals: config.uv.decimals
                }
            };

            var idxs = ['SolarRad', 'CurrentSolarMax', 'UV'];
            var cnt = 0;
            var solarAxisCreated = false;

            idxs.forEach(function(idx) {
                if (idx in resp) {
                    if (idx === 'UV') {
                        chart.addAxis({
                            id: 'uv',
                            title:{text: 'UV Index'},
                            opposite: true,
                            min: 0,
                            labels: {
                                align: 'left'
                            },
                            showEmpty: false
                        });
                    } else if (!solarAxisCreated) {
                        chart.addAxis({
                            id: 'solar',
                            title: {text: 'Solar Radiation (W/m\u00B2)'},
                            min: 0,
                            opposite: false,
                            labels: {
                                align: 'right',
                                x: -5
                            },
                            showEmpty: false
                        });
                        solarAxisCreated = true;
                    }


                    chart.addSeries({
                        name: titles[idx],
                        type: types[idx],
                        yAxis: idx === 'UV' ? 'uv' : 'solar',
                        tooltip: tooltips[idx],
                        data: resp[idx],
                        color: config.series[idx.toLowerCase()].colour,
                        fillOpacity: idx === 'CurrentSolarMax' ? 0.2 : 0.5,
                        zIndex: 100 - cnt
                    }, false);

                    cnt++;
                }
            });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doSunHours = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'column',
            alignTicks: false
        },
        title: {
            text: 'Sunshine Hours'
        },
        yAxis: [{
            // left
            title: {
                text: 'Sunshine Hours'
            },
            min: 0,
            opposite: false,
            labels: {
                align: 'right',
                x: -12
            }
        }, {
            // right
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            title: {
                text: null
            },
            labels: {
                align: 'left',
                x: 12
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                pointPadding: 0,
                groupPadding: 0.1,
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            }
        },
        series: [{
            name: 'Sunshine Hours',
            type: 'column',
            color: config.series.sunshine.colour,
            yAxis: 0,
            valueDecimals: 1,
            tooltip: {
                valueSuffix: ' Hrs'
            }
        }]
    };

    chart = new Highcharts.Chart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'sunhours.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            chart.hideLoading();
            chart.series[0].setData(resp.sunhours);
        }
    });
};

var doDailyRain = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'column',
            alignTicks: false
        },
        title: {
            text: 'Daily Rainfall'
        },
        yAxis: [{
            // left
            title: {
                text: 'Daily Rainfall'
            },
            min: 0,
            opposite: false,
            labels: {
                align: 'right',
                x: -12
            }
        }, {
            // right
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            title: {
                text: null
            },
            labels: {
                align: 'left',
                x: 12
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                pointPadding: 0,
                groupPadding: 0.1,
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            }
        },
        series: [{
            name: 'Daily Rainfall',
            type: 'column',
            color: config.series.rfall.colour,
            yAxis: 0,
            valueDecimals: config.rain.decimals,
            tooltip: {
                valueSuffix: ' ' + config.rain.units
            }
        }]
    };

    chart = new Highcharts.Chart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'dailyrain.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            chart.hideLoading();
            chart.series[0].setData(resp.dailyrain);
        }
    });
};

var doDailyTemp = function () {
    var freezing = config.temp.units === 'C' ? 0 : 32;
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {
            text: 'Daily Temperature'
        },
        yAxis: [{
            // left
            title: {
                text: 'Daily Temperature (°' + config.temp.units + ')'
            },
            opposite: false,
            labels: {
                align: 'right',
                x: -5,
                formatter: function () {
                    return '<span style="fill: ' + (this.value <= 0 ? 'blue' : 'red') + ';">' + this.value + '</span>';
                }
            },
            plotLines: [{
                // freezing line
                value: freezing,
                color: 'rgb(0, 0, 180)',
                width: 1,
                zIndex: 2
            }]
        }, {
            // right
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            title: {
                text: null
            },
            labels: {
                align: 'left',
                x: 5,
                formatter: function () {
                    return '<span style="fill: ' + (this.value <= 0 ? 'blue' : 'red') + ';">' + this.value + '</span>';
                }
            }
        }],
        legend: {
            enabled: true
        },
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {
                lineWidth: 2
            }
        },
        tooltip: {
            valueSuffix: ' °' + config.temp.units,
            valueDecimals: config.temp.decimals,
        },
        rangeSelector: {
            enabled: false
        },
        series: []
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'dailytemp.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            var titles = {
                'avgtemp': 'Avg Temp',
                'mintemp': 'Min Temp',
                'maxtemp': 'Max Temp'
            };
            var idxs = ['avgtemp', 'mintemp', 'maxtemp'];

            idxs.forEach(function (idx) {
                if (idx in resp) {
                    chart.addSeries({
                        name: titles[idx],
                        data: resp[idx],
                        color: config.series[idx].colour
                    }, false);
                }
            });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doAirQuality = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'line',
            alignTicks: false
        },
        title: {text: 'Air Quality'},
        yAxis: [{
                // left
                title: {text: 'µg/m³'},
                opposite: false,
                min: 0,
                labels: {
                    align: 'right',
                    x: -5
                }
            }, {
                // right
                linkedTo: 0,
                gridLineWidth: 0,
                opposite: true,
                min: 0,
                title: {text: null},
                labels: {
                    align: 'left',
                    x: 5
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }
                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            valueSuffix: ' µg/m³',
            valueDecimals: 1,
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'airquality.json',
        dataType: 'json',
        cache: false,
        success: function (resp) {
            var titles = {
                'pm2p5': 'PM 2.5',
                'pm10' : 'PM 10'
             }
             var idxs = ['pm2p5', 'pm10'];
             idxs.forEach(function(idx) {
                 if (idx in resp) {
                     chart.addSeries({
                         name: titles[idx],
                         color: config.series[idx].colour,
                         data: resp[idx]
                    }, false);
                 }
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doExtraTemp = function () {
    var freezing = config.temp.units === 'C' ? 0 : 32;
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {text: 'Extra Temperature'},
        yAxis: [{
                // left
                title: {text: 'Temperature (°' + config.temp.units + ')'},
                opposite: false,
                labels: {
                    align: 'right',
                    x: -5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                },
                plotLines: [{
                        // freezing line
                        value: freezing,
                        color: 'rgb(0, 0, 180)',
                        width: 1,
                        zIndex: 2
                    }]
            }, {
                // right
                gridLineWidth: 0,
                opposite: true,
                linkedTo: 0,
                labels: {
                    align: 'left',
                    x: 5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            valueSuffix: ' °' + config.temp.units,
            valueDecimals: config.temp.decimals,
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'extratempdata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var id = config.series.extratemp.name.findIndex(val => val == key);
                chart.addSeries({
                    name: key,
                    color: config.series.extratemp.colour[id],
                    data: value
                });
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doExtraHum = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'line',
            alignTicks: false
        },
        title: {text: 'Extra Humidity'},
        yAxis: [{
                // left
                title: {text: 'Humidity (%)'},
                opposite: false,
                min: 0,
                max: 100,
                labels: {
                    align: 'right',
                    x: -5
                }
            }, {
                // right
                linkedTo: 0,
                gridLineWidth: 0,
                opposite: true,
                min: 0,
                max: 100,
                title: {text: null},
                labels: {
                    align: 'left',
                    x: 5
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            valueSuffix: ' %',
            valueDecimals: config.hum.decimals,
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'extrahumdata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var id = config.series.extrahum.name.findIndex(val => val == key);
                chart.addSeries({
                    name: key,
                    color: config.series.extrahum.colour[id],
                    data: value
                });
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doExtraDew = function () {
    var freezing = config.temp.units === 'C' ? 0 : 32;
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {text: 'Extra Dew Point'},
        yAxis: [{
                // left
                title: {text: 'Dew Point (°' + config.temp.units + ')'},
                opposite: false,
                labels: {
                    align: 'right',
                    x: -5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                },
                plotLines: [{
                        // freezing line
                        value: freezing,
                        color: 'rgb(0, 0, 180)',
                        width: 1,
                        zIndex: 2
                    }]
            }, {
                // right
                gridLineWidth: 0,
                opposite: true,
                linkedTo: 0,
                labels: {
                    align: 'left',
                    x: 5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            valueSuffix: ' °' + config.temp.units,
            valueDecimals: config.temp.decimals,
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'extradewdata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var id = config.series.extradew.name.findIndex(val => val == key);
                chart.addSeries({
                    name: key,
                    color: config.series.extradew.colour[id],
                    data: value
                });
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doSoilTemp = function () {
    var freezing = config.temp.units === 'C' ? 0 : 32;
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {text: 'Soil Temperature'},
        yAxis: [{
                // left
                title: {text: 'Temperature (°' + config.temp.units + ')'},
                opposite: false,
                labels: {
                    align: 'right',
                    x: -5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                },
                plotLines: [{
                        // freezing line
                        value: freezing,
                        color: 'rgb(0, 0, 180)',
                        width: 1,
                        zIndex: 2
                    }]
            }, {
                // right
                gridLineWidth: 0,
                opposite: true,
                linkedTo: 0,
                labels: {
                    align: 'left',
                    x: 5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            valueSuffix: ' °' + config.temp.units,
            valueDecimals: config.temp.decimals,
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'soiltempdata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var id = config.series.soiltemp.name.findIndex(val => val == key);
                chart.addSeries({
                    name: key,
                    color: config.series.soiltemp.colour[id],
                    data: value
                });
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doSoilMoist = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {text: 'Soil Moisture'},
        yAxis: [{
                // left
                title: {text: 'Moisture'},
                opposite: false,
                labels: {
                    align: 'right',
                    x: -5
                }
            }, {
                // right
                gridLineWidth: 0,
                opposite: true,
                linkedTo: 0,
                labels: {
                    align: 'left',
                    x: 5
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            //valueSuffix: ' ' + config.soilmoisture.units[id],
            valueDecimals: 0,
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'soilmoistdata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var id = config.series.soilmoist.name.findIndex(val => val == key);
                chart.addSeries({
                    name: key,
                    color: config.series.soilmoist.colour[id],
                    data: value,
                    tooltip: {valueSuffix: ' ' + config.soilmoisture.units[id]}
                });
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doLeafWet = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {text: 'Leaf Wetness'},
        yAxis: [{
                // left
                title: {text: 'Leaf Wetness' + (config.leafwet.units == '' ? '' : '(' + config.leafwet.units + ')')},
                opposite: false,
                min: 0,
                labels: {
                    align: 'right',
                    x: -5
                }
            }, {
                // right
                gridLineWidth: 0,
                opposite: true,
                min: 0,
                linkedTo: 0,
                labels: {
                    align: 'left',
                    x: 5
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            //shared: true,
            //split: false,
            //useHTML: true,
			//className: 'cmxToolTip',
			//headerFormat: myTooltipHead,
			//pointFormat:  myTooltipPoint,
			//footerFormat: '</table>',
            valueSuffix: ' ' + config.leafwet.units,
            valueDecimals: config.leafwet.decimals,
            //xDateFormat: "%A, %b %e, " + config.timeformat
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'leafwetdata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var id = config.series.leafwet.name.findIndex(val => val == key);
                chart.addSeries({
                    name: key,
                    color: config.series.leafwet.colour[id],
                    data: value
                });
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doUserTemp = function () {
    var freezing = config.temp.units === 'C' ? 0 : 32;
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {text: 'User Temperature'},
        yAxis: [{
                // left
                title: {text: 'Temperature (°' + config.temp.units + ')'},
                opposite: false,
                labels: {
                    align: 'right',
                    x: -5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                },
                plotLines: [{
                        // freezing line
                        value: freezing,
                        color: 'rgb(0, 0, 180)',
                        width: 1,
                        zIndex: 2
                    }]
            }, {
                // right
                gridLineWidth: 0,
                opposite: true,
                linkedTo: 0,
                labels: {
                    align: 'left',
                    x: 5,
                    formatter: function () {
                        return '<span style="fill: ' + (this.value <= freezing ? 'blue' : 'red') + ';">' + this.value + '</span>';
                    }
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            shared: true,
            split: false,
            useHTML: true,
			className: 'cmxToolTip',
			headerFormat: myTooltipHead,
			pointFormat:  myTooltipPoint,
			footerFormat: '</table>',
            valueSuffix: ' °' + config.temp.units,
            valueDecimals: config.temp.decimals,
            xDateFormat: "%A, %b %e, " + config.timeformat
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'usertempdata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var id = config.series.usertemp.name.findIndex(val => val == key);
                chart.addSeries({
                    name: key,
                    color: config.series.usertemp.colour[id],
                    data: value
                });
             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};

var doCO2 = function () {
    var options = {
        chart: {
            renderTo: 'chartcontainer',
            type: 'spline',
            alignTicks: false
        },
        title: {text: 'CO&#8322; Sensor'},
        yAxis: [{
                // left
                id: 'co2',
                title: {text: 'CO&#8322; (ppm)'},
                opposite: false,
                min: 0,
                minRange: 10,
                alignTicks: true,
                showEmpty: false,
                labels: {
                    align: 'right',
                    x: -5
                }
            }],
        legend: {enabled: true},
        plotOptions: {
            series: {
                dataGrouping: {
                    enabled: false
                },
                states: {
                    hover: {
                        halo: {
                            size: 5,
                            opacity: 0.25
                        }

                    }
                },
                cursor: 'pointer',
                marker: {
                    enabled: false,
                    states: {
                        hover: {
                            enabled: true,
                            radius: 0.1
                        }
                    }
                }
            },
            line: {lineWidth: 2}
        },
        tooltip: {
            shared: true,
            split: false,
            useHTML: true,
			className: 'cmxToolTip',
			headerFormat: myTooltipHead,
			pointFormat:  myTooltipPoint,
			footerFormat: '</table>',
            //xDateFormat: "%A, %b %e, " + config.timeformat
        },
        series: [],
        rangeSelector: myRangeBtns
    };

    chart = new Highcharts.StockChart(options);
    chart.showLoading();

    $.ajax({
        url: dataPath + 'co2sensordata.json',
        dataType: 'json',
        success: function (resp) {
            Object.entries(resp).forEach(([key, value]) => {
                var yaxis = 0;
                var tooltip;
                // id - remove all spaces and lowercase
                var id = key.toLowerCase().split(' ').join('');

                if (key == 'CO2' || key == 'CO2 Average') {
                    yaxis = 'co2';
                    tooltip = {valueSuffix: ' ppm'};
                } else if (key.startsWith('PM')) {
                    yaxis = 'pm';
                    tooltip = {valueSuffix: ' &#181;g/m&#179;'};


                    if (!chart.get('pm')) {
                        chart.addAxis({
                            // left
                            id: 'pm',
                            title: {text: 'PM (&#181;g/m&#179;)'},
                            opposite: false,
                            min: 0,
                            minRange: 10,
                            alignTicks: true,
                            showEmpty: false,
                            labels: {
                                align: 'right',
                                x: -5
                            }
                        });
                    }
                } else if (key == 'Temperature') {
                    yaxis = 'temp';
                    tooltip = {valueSuffix: ' °' + config.temp.units};
                    chart.addAxis({
                        // right
                        id: 'temp',
                        title: {text: 'Temperature (°' + config.temp.units + ')'},
                        //gridLineWidth: 0,
                        opposite: true,
                        alignTicks: true,
                        showEmpty: false,
                        labels: {
                            align: 'left',
                            x: 5
                        }
                    });
                } else if (key == 'Humidity') {
                    yaxis = 'hum';
                    tooltip = {valueSuffix: ' %'};
                    chart.addAxis({
                        // right
                        id: 'hum',
                        title: {text: 'Humidity (%)'},
                        min: 0,
                        //gridLineWidth: 0,
                        opposite: true,
                        alignTicks: true,
                        showEmpty: false,
                        labels: {
                            align: 'left',
                            x: 5
                        }
                    });
                }

                chart.addSeries({
                    name: config.series.co2[id].name,
                    color: config.series.co2[id].colour,
                    data: value,
                    yAxis: yaxis,
                    tooltip: tooltip
                });

             });

            chart.hideLoading();
            chart.redraw();
        }
    });
};
