/*	---------------------------------------------------------
 * 	noaayearlyreports.js
 * 	Extraction of embedded javascript for NOAA Yearly Reports
 * 	--------------------------------------------------------- */

$(document).ready(function () {
    var now = new Date();
    // subtract 1 day
    now.setTime(now.getTime()-(1*24*3600000));
    var dateStr = now.getFullYear();

    $('#datepicker').datepicker({
	format: "yyyy",
	viewMode: "years",
	minViewMode: "years",
	autoclose: true,
	endDate: '-1d'
    }).val(dateStr);

    $("#datepicker").on('changeDate', function() {
        console.log("Date Changed");
        load();
    });

    load();
});

function load() {
	var year = $('#datepicker').val();
    $.ajax({
        url: '/api/reports/noaayear?year='+year
    }).done(function(data) {
        $('#report').text(data.join('\n'));
    }).fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}

function generate() {
    var year = $('#datepicker').val();
    $.ajax({
        url: '/api/genreports/noaayear?year='+year
    }).done(function(data) {
        $('#report').text(data.join('\n'));
        alert("Report (Re)generated");
    }).fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}
