/*	--------------------------------------
 * 	Script:	AI-PageManager.js
 * 	Purpose:	Utility for all pages:
 * 		a) Setting margins top & bottom
 * 		b) Setting the theme required
 * 		c) Providing utility scripts 
 * 	Version:	1.0.3-ai
 * 	Author:	Neil Thomas
 * 	Last edit:
 * 	Validated:
 * 	-------------------------------------*/

//	Global configuration
//	These values are used if local Storage is NOT available and can be edited directly.
let AIConfig = {'Theme': 'QuietGrey', 'StaticHead': true, 'StaticFoot': true, 'TopMargin': 10, 'BottomMargin': 10 };
let HeaderHeight, FooterHeight;

$(document).ready ( function() {
	//	Clean out any existing storage from previous versions
	localStorage.removeItem('CMXaiFixedHead');
	localStorage.removeItem('CMXaiSettings');
	localStorage.removeItem('CMXaiTheme');
	/*	----------------------------------------------------------------
	*	If you do have local storage (modern browser), and you have
	* 	made changes to AIConfig above, then Un-Comment the line below,
	* 	load any page and then Re-Comment it. Your settings will be saved
	* 	--------------------------------------------------------------*/
	//localStorage.removeItem('CMXai');
	
	if( typeof( Storage ) !== 'undefined' ) {
		if( localStorage.getItem("CMXai") === null ) {
			// Need to write basic settings
			storeConfig();
		} else {
			readConfig();
		}
	} else {
		console.log("Browser storage not available");
	}
	//	Other processes.
	$.ajax({
		url: "/api/settings/version.json",
		dataType: "json",
		success: function (result) {
			$('.Version').text(result.Version);
			$('.Build').text(result.Build);
		},
		error: function (xhr) {
			console.log("Failed to load Version data" + xhr.status);
		}
    }); 
	
	setTheme()
	loadMenus();
});

var storeConfig = function() {
	//	No CMX settings found so store them
	localStorage.setItem( "CMXai", JSON.stringify( AIConfig ));
};

let readConfig = function() {
	AIConfig = JSON.parse(localStorage.getItem("CMXai"));
}

let loadMenus = function() {
	$.ajax({
		url: 'MainMenu.html',
		cache: true,
		dataType: 'text',
		success: function(result) {
			$("#MainMenu").html(result);
		},
		error: function(xhr) {
			console.log("Failed to load main menu: " + xhr.status);
		},
		complete: function() {
			Top_N_Tail(); // only do topNtail after the Main Menu has loaded
		}
	});
	$.ajax({
		url: 'MobileMenu.html',
		cache: true,
		dataType: 'text',
		success: function(result) {
			$("#MobileMenu").html(result);
		},
		error: function(xhr) {
			console.log("Failed to load mobile menu: " + xhr.status);
		}
	});
};

let setTheme = function() {
	if( AIConfig.Theme !== "QuietGrey") {
		$("head").append('<link href="css/' + AIConfig.Theme + '.css" rel="stylesheet" type="text/css">');
	};
};

let Top_N_Tail = function() {
	//	Adjust margins based on AIConfig values
	HeaderHeight = parseInt($('header').outerHeight(true));
    FooterHeight = parseInt($('footer').outerHeight(true));
	if( AIConfig.StaticHead ) {
		//	Static header
		var Top_Margin;
		Top_Margin = HeaderHeight + AIConfig.TopMargin;
		$('#Content').css('margin-top', Top_Margin + 'px');
		$('#Banner').addClass('w3-top');
	} else {
		$('#Banner').removeClass('w3-top');
		$('#Content').css('margin-top', AIConfig.TopMargin + "px");
	}

	if( AIConfig.StaticFoot ) {
		//	Static footer
		var Bottom_Margin;
		Bottom_Margin = FooterHeight + AIConfig.BottomMargin;
		$('#Footer').addClass('w3-bottom');
		$('#Content').css('margin-bottom', Bottom_Margin + 'px');
	} else {
		//	Scrolling footer
		$('#Footer').removeClass('w3-bottom');
		$('#Content').css('margin-bottom', AIConfig.BottomMargin + 'px');
	}
};

$(window).resize( function () {
	//	Deal with changing window size
	Top_N_Tail();
	if( $(window).height() < 600 && AIConfig.StaticFoot) {
		$("#Footer").removeClass("w3-bottom");
		$("#Content").css("margin-bottom", AIConfig.BottomMargin + 'px' );
	} else {
		$("#Footer").addClass("w3-bottom");
		$("#Content").css("margin-bottom", AIConfig.BottomMargin + $("#Footer").outerHeight(true));
	}
})

let toggleMenu = function(menuId) {
	//	Assums currently hidden
	console.log("Toggling menu: " + menuId);
	$('#' + menuId).toggleClass( 'w3-show', 'w3-hide' );
};

let toggleTabs = function(tabId, tabCls) {
	$("." + tabCls).addClass("w3-hide");
	$("#" + tabId).removeClass("w3-hide");
};

let showModal = function(modalID) {
	$('#' + modalID).toggleClass('w3-show', 'w3-hide');
};

let togglePanel = function(panel) {
	//	Assumes currently visible
	$("#" +  panel).toggleClass("w3-hide", "w3-show");
	if( $("#AlarmSet").text() == "Show Alarms") {
		$("#AlarmSet").text("Hide Alarms");
	} else {
		$("#AlarmSet").text("Show Alarms");
	}
}

let toggleArea = function(area) {
	//	Duplicate of TogglePanel but for additional areas
	$('#' + area + 'Panel').toggleClass("w3-hide", "w3-show");
	var btnText = $('#' + area + 'Set').text();
	if( btnText.slice(0,4) == "Show") {
		$('#' + area + 'Set').text(btnText.replace("Show","Hide"));
	} else {
		$('#' + area + 'Set').text(btnText.replace("Hide","Show"));
	}
}

