/*	-----------------------------------
 * 	Script:	weathereditor.js
 * 	Role:	Service the new weatehreditor page
 * 	Version:	1.0.2-ai
 * 	Author:	Neil Thomas
 * 	------------------------------------------*/

var activeDates;

$(document).ready(function () {
	var date = new Date();
    var currYear = date.getFullYear();
    var currMonth = date.getMonth() + 1;

	$('#datepicker').datepicker({
        format       : 'yyyy-mm-dd',
        endDate      : '0d',
        startDate    : '-20y',
        todayBtn      : "linked",
        weekStart: 1,
        beforeShowDay: function (date) {
            var localDate = getLocalFormattedString(date);
            if ($.inArray(localDate, activeDates) != -1) {
                return {classes: 'hasData'};
            }
            return;
        }
    });

	$('#datepicker').on('changeDate', function () {
		var date = $('#datepicker').datepicker('getUTCDate');
		var dateString = getUTCFormattedString(date, false);
		$.ajax({
			url: '/api/data/diarydata?date=' + dateString ,
			dataType: 'json',
			success: function (result) {
				$('#inputComment').val(result.entry);
				$('#XComment').html("<em>" + result.entry + "</em>");
				$('#inputSnowFalling').prop('checked', (result.snowFalling === 1));
				$('#inputSnowLying').prop('checked', (result.snowLying === 1));
				$('#inputSnowDepth').val(result.snowDepth);
				$('#status').text('');
			},
			error: function (jqXHR, textStatus, errorThrown) {
				$('#status').text('Error: ' + textStatus);
			}
		});
	});


    $("#datepicker").datepicker('setDate', '0');
    getSummaryData(currYear, currMonth);

    load();


});

function load() {
    $.ajax({
        url: '/api/edit/currentcond.json'
    }).done(function(resp) {
        //$('#inputCurrCond').val(resp.data);
                $('#inputCurrCond')[0].value = resp.data;
    }).fail(function(jqXHR, textStatus) {
        $("#CCstatus").html("Something went wrong loading text! (" + textStatus + ')');
    });
}


function applyEntry() {
	//	Services CurrentConditions Apply Button
    var body = $('#inputCurrCond')[0].value;
    body = body.replace(/\n/g, ' ');
    $.ajax({
        url     : '/api/edit/currcond',
        type    : 'POST',
        data    : body,
        dataType: 'json'
    }).done(function (result) {
        console.log(result.result);
        // notify user
        if (result.result === 'Success') {
            //alert('Entry added/updated OK.');
            $("#CCstatus").html("Your entry has been added/updated.");
            timeOut("CCstatus");
            load();
        } else {
            //alert('Failed to add/update entry!');
            $("#CCstatus").html("Failed to save/update entry!");
            timeOut("CCstatus");
        }
    }
    ).fail(function(jqXHR, textStatus) {
        alert('Something went wrong updating the text! (' + textStatus + ')');
    });
}

//	Diary
function getSummaryData() {
    var date = $('#datepicker').datepicker('getFormattedDate');
    $.ajax({
        url     : '/api/data/diarysummary',
        dataType: 'json',
        success : function (result) {
            activeDates = result.dates;
            $('#datepicker').datepicker('update', date);
        },
        error: function (jqXHR, textStatus, errorThrown) {
            $('#status').text('Error: ' + textStatus);
        }
    });
}

function deleteDiaryEntry() {
    var date = $('#datepicker').datepicker('getUTCDate');
    var body = '{"Timestamp":"' + getUTCFormattedString(date, true) + '"}';
    if ('' == date) {
        $('#status').text('Error: You must select a date first.');
    } else {
        $.ajax({
            url     : '/api/edit/diarydelete',
            type    : 'POST',
            data    : body,
            dataType: 'json',
            success : function (result) {
                console.log(result.result);
                // notify user
                if (result.result === 'Success') {
                    $('#inputComment').val(null);
                    $('#inputSnowFalling').prop('checked', false);
                    $('#inputSnowLying').prop('checked', false);
                    $('#inputSnowDepth').val(null);
                    $('#status').text('Entry deleted.');
                    timeOut("status");
                }
                // update datepicker
                getSummaryData();
            }
        });
    }
}

function applyDiaryEntry() {
    var date = $('#datepicker').datepicker('getUTCDate');
    var body = '{"Timestamp":"' + getUTCFormattedString(date, true) + '",' +
        '"entry":"' + $('#inputComment').val() + '",' +
        '"snowFalling":"' + ($('#inputSnowFalling').prop('checked') ? 1 : 0) + '",' +
        '"snowLying":"' + ($('#inputSnowLying').prop('checked') ? 1 : 0) + '",' +
        '"snowDepth":"' + ($('#inputSnowDepth').val() ? $('#inputSnowDepth').val() : 0) + '"}';
    if ('' == date) {
        $('#status').text('Error: You must select a date first.');
        timeOut("status");
    } else {
        $.ajax({
            url     : '/api/edit/diarydata',
            type    : 'POST',
            data    : body,
            dataType: 'json',
            success : function (result) {
                console.log(result.result);
                // notify user
                if (result.result === 'Success') {
                    $('#status').text('Entry added/updated OK.');
                    timeOut("status");
                   // window.setTimeout(function(){  $('#status').text(""); }, 5000);
                }
                // update datepicker
                getSummaryData();
            }
        });
    }
}

function getUTCFormattedString(date, long) {
    return date.getUTCFullYear() + '-' + ('0' + (date.getUTCMonth() + 1)).slice(-2) + '-' + ('0' + date.getUTCDate()).slice(-2) + (long ? 'T00:00:00Z' : '');
}

function getLocalFormattedString(date) {
    return date.getFullYear() + '-' + ('0' + (date.getMonth() + 1)).slice(-2) + '-' + ('0' + date.getDate()).slice(-2);
}

let timeOut = function(elId) {
    window,setTimeout( function(){$("#" + elId).html("");}, 4000);
};
