/*	--------------------------------------------------
 * 	noaamonthreport.js
 * 	Extraction of javascript from noaamonthreport.html
 * 	-------------------------------------------------- */

$(document).ready(function () {
    var now = new Date();
    // subtract 1 day
    now.setTime(now.getTime()-(1*24*3600000));
    var dateStr = now.getFullYear() + '-' + (now.getMonth() + 1);

    $('#datepicker').datepicker({
        format: "yyyy-mm",
        viewMode: "months",
        minViewMode: "months",
        autoclose: true,
        endDate: '-1d'
    }).val(dateStr);

    $("#datepicker").on('changeDate', function() {
        console.log("Date Changed");
        load();
    });

    load();
});

function load() {
    var date = $('#datepicker').val();
    var year = date.split('-')[0];
    var month = date.split('-')[1];
    $.ajax({
        url: '/api/reports/noaamonth?year='+year+'&month='+month
    }).done(function(data) {
        $('#report').text(data.join('\n'));
    }).fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}

function generate() {
    var date = $('#datepicker').val();
    var year = date.split('-')[0];
    var month = date.split('-')[1];
    $.ajax({
        url: '/api/genreports/noaamonth?year='+year+'&month='+month
    }).done(function(data) {
        $('#report').text(data.join('\n'));
        alert("Report (Re)generated");
    }).fail(function(jqXHR, textStatus) {
        $('#report').text('Something went wrong! (' + textStatus + ')');
    });
}


