/*	-----------------------------------------------
 * 	Script:	ChartsPlus.js	version: 0.0.1
 * 	Author:	Neil Thomas
 * 	Role:	To supplement the default charts.js &
 * 			chartshistoric.js script to enable buttons
 *	Last modified: 2nd Jun 2021
 * 	----------------------------------------------- */

//	Modifications by Neil
var getGraph = function(graph) {
	switch (graph ) {
		case 'temp' 	 : doTemp();		break;
		case 'dailytemp' : doDailyTemp();	break;
		case 'press'	 : doPress();		break;
		case 'wind' 	 : doWind();		break;
		case 'windDir'	 : doWindDir();		break;
		case 'rain'		 : doRain();		break;
		case 'dailyrain' : doDailyRain();	break;
		case 'humidity'	 : doHum();			break;
		case 'solar'	 : doSolar();		break;
		case 'sunhours'	 : doSunHours();	break;
		case 'airquality': doAirQuality();	break;
		case 'degdays'   : doDegDays();	 	break;
		case 'tempsum'	 : doTempSum();		break;
		default : doTemp();
	}
}

$(document).ready( function() {
	$.ajax({
		url: "/api/graphdata/availabledata.json",
        dataType: "json",
        success: function (result) {
            if (result.Temperature === undefined || result.Temperature.Count == 0) {
                $('#tempNT').remove();
            }
            if (result.DailyTemps === undefined || result.DailyTemps.Count == 0) {
                $('#dailytempNT').remove();
            }
            if (result.Humidity === undefined || result.Humidity.Count == 0) {
                $('#humidityNT').remove();
            }
            if (result.Solar === undefined || result.Solar.Count == 0) {
                $('#solarNT').remove();
            }
            if (result.Sunshine === undefined || result.Sunshine.Count == 0) {
                $('#sunhoursNT').remove();
            }
            if (result.AirQuality === undefined || result.AirQuality.Count == 0) {
                $('#airqualityNT').remove();
            }
            if (result.DegreeDays === undefined || result.DegreeDays.Count == 0) {
                $('#degdaysNT').remove();
            }
            if (result.TempSum === undefined || result.TempSum.Count == 0) {
                $('#tempsumNT').remove();
            }
        }
	})
});
