/*  ----------------------------------------------------------------
 *  Script: theme-manager.js      v:0.0.1     A:Neil Thomas
 *  Role:   To enable users to change theme dynamicaly and to change
 *          to the current theme on any page running this script.
 *  Option: An element with the ID ThemeSelector if the user is
 *          allowed to change theme on that page
 *  --------------------------------------------------------------- */

// theme - an array of the colours (css) that you allow - first one is YOUR default - MUST be at least one
let themes = ["AlmondBuff", "AlmostMauve", "Arcadia", "CherryTomato", "ChiliOil", "CoconutMilk", "CrocusPetal", "CylonYellow",
              "Emporador", "HarbourMist", "Limelight", "LimePunch", "Marsala", "MartiniOlive", "MeerKat", "NebulasBlue", "QuietGrey",
              "RedPear", "RussetOrange", "SailorBlue", "SandDollar", "SargassoSea", "SlateGrey", "SpringCrocus", "Tofu", "UltraViolet", "ValiantPoppy", "WarmSand"];

let currentTheme;  // Global theme variable

$(document).ready( function() {
    var themeL, themeS;
    themeL = localStorage.getItem("CMXaiTheme");
    themeS = sessionStorage.getItem("CMXaiTheme");
    if ((themeL === null) && (themeS === null)) {
        currentTheme = "SargassoSea" ;
    } else {
        currentTheme = (themeS === null) ? themeL : themeS ;
    }
    console.log("Selected theme is " + currentTheme);
    $("#CurrentTheme").text(currentTheme);
    //  Populate theme selector
    if( typeof(Storage) !== "undefined" ) {
        if ( $('#ThemeSelector').length) {
            populateSelector('ThemeSelector', currentTheme );
        } else {
            console.log("Theme changes disabled.");
        }
    } else {
        console.log("Browser doesn't support storage")
        $("#ThemeSelector").html("Sorry but your browser doesn't support theme changes.")
    }
})

let populateSelector = function(elem, activeTheme) {
    var selector = '<select id="ThemeList" class="w3-select w3-theme" style="max-width:130px;" onChange="useSession(this.value)">\n';
    for ( var theme = 0; theme < themes.length; theme++ ) {
        selector += '<option value="' + themes[theme] + '"' + (activeTheme == themes[theme] ? " selected" : "") + '>' + themes[theme] + '</option>\n';
    }
    //  End required selector html
    selector += "</select>\n";
    $('#' + elem).html(selector);
};

let useSession = function( selectedTheme ) {
    //  Set selection as 'session' theme.
    sessionStorage.setItem("CMXaiTheme", selectedTheme );
    console.log("Session theme: " + selectedTheme );
    $("head").append('<link href="css/' + selectedTheme + '.css" rel="stylesheet" type="text/css">');
    $("#CurrentTheme").html(selectedTheme);
    //alert("Theme " + selectedTheme + " active for this session only");
}

let useAlways = function() {
    //  Set current theme as permenant  theme
    currentTheme = sessionStorage.getItem("CMXaiTheme");
    console.log("Setting " + currentTheme + " as permanent theme.");
    localStorage.setItem("CMXaiTheme", currentTheme );
    sessionStorage.removeItem("CMXaiTheme");
    alert("Theme " + currentTheme + " is now set as the default theme.");
}

let clearStorage = function() {
    sessionStorage.removeItem("CMXaiTheme");
    localStorage.removeItem("CMXaiTheme");
    populateSelector('ThemeSelector', 'SargassoSea');
    $("head").append('<link href="css/SargassoSea.css" rel="stylesheet" type="text/css">');
    $("#CurrentTheme").html(selectedTheme);
}
