/*	-----------------------------------------------
 * 	page-manager.js		V:0.0.1		Neil T
 * 	General utilities for the Alternative Interface
 * 	----------------------------------------------- */

let topMargin = 10 ;
let footerMargin = 10 ;
let fixedBanner = true;
let fixedFooter = true;

$(document).ready( function() {
	setTheme();
	includeMenus();
	topNtail();
	$.ajax({url: "/api/settings/version.json", dataType: "json", success: function (result) {
        $('.Version').text(result.Version);
        $('.Build').text(result.Build);
    }});
})

var setTheme = function() {
	//	Check if starage supported
	if( typeof(Storage) !== "undefined") {
		console.log("Storage supported");
		var theme = sessionStorage.getItem("CMXaiTheme");
		if( theme !== null ) {
			$('head').append('<link href="css/' + theme + '.css" rel="stylesheet" type="text/css">');
		} else {
			theme = localStorage.getItem("CMXaiTheme");
			if( theme !== null ) {
				$('head').append('<link href="css/' + theme + '.css" rel="stylesheet" type="text/css">');
			}
		}
	} else {
		//	Browser does NOT support storage
		console.log("Browser does NOT support storage");
	} /**/
};

var includeMenus = function() {
	$.ajax({
		url: 'MainMenu.html',
		cache: true,
		dataType: 'text',
		success: function(result) {
			$("#MenuMain").html(result);
		},
		error: function(xhr) {
			console.log("Failed to load main menu");
		}
	});
	$.ajax({
		url: 'MobileMenu.html',
		cache: true,
		dataType: 'text',
		success: function(result) {
			$("#MenuMobile").html(result);
		},
		error: function(xhr) {
			console.log("Failed to load mobile menu: " + xhr.status);
		}
	});
};

var topNtail = function() {
	var bannerHeight, marginTop, footerHeight, marginBottom;
	if ( fixedBanner ) {
		$("#Banner").addClass( 'w3-top' );
		bannerHeight = $("#Banner").outerHeight();
		marginTop =  topMargin + bannerHeight;
		$("#Content").css("margin-top", marginTop );
	} else {
		$("#Banner").removeClass( 'w3-top' );
		marginTop = topMargin;
		$("#Content").css("margin-top", marginTop) ;
	}
	console.log("Content top margin set to: " + marginTop);

	if ( fixedFooter ) {
		$("#Footer").addClass("w3-bottom");
		footerHeight = $("#Footer").outerHeight(true);
		console.log("Footer height is: " + footerHeight);
		marginBottom = footerMargin + footerHeight ;
		$("#Content").css("margin-bottom", marginBottom );
	} else {
		$("#Footer").removeClass("w3-bottom");
		marginBottom = footerMargin ;
		$("#Content").css("margin-bottom", marginBottom );
	}
	console.log("Content bottom margin set to: " + marginBottom);
};

$(window).resize( function () {
	//topNtail();
	if( $(window).height() < 600 &&  fixedFooter) {
		$("#Footer").removeClass("w3-bottom");
		$("#Content").css("margin-bottom", footerMargin );
	} else {
		$("#Footer").addClass("w3-bottom");
		$("#Content").css("margin-bottom", footerMargin + $("#Footer").outerHeight());
	}
})

let toggleMenu = function(menuId) {
	$('#' + menuId).toggleClass( 'w3-show', '' );
};

let toggleTabs = function(tabId, tabCls) {
	$("." + tabCls).addClass("w3-hide");
	$("#" + tabId).removeClass("w3-hide");
};
