/*	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * 	Script:	monthlyrecsdata2.js
 * 	Role:	Collect and insert data into
 * 			monthly records page.
 * 			Uses data attributes rather than ID
 *  Based on monthlyrecsdata.js
 * 	V:		3.0.0
 * 	Author:	Neil Thomas
 * 	Edited:	23-06-2023 11:40
 * 	Checked:23-06-2023 11:40
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

// Last modified: 2022/07/27 15:35:57

$( function() {
	dataLoadedPromise.then( function() {
		var yesterday = new Date();
		yesterday.setDate(yesterday.getDate() - 1);
		changeData(yesterday.getMonth());
		$('#btnMon' + yesterday.getMonth()).attr('aria-pressed', true).addClass('ow-theme-sub4');
	});
});

var monthnames = new Array("January","February","March","April","May","June","July","August","September","October","November","December");

function changeData(month) {
	$('#MonthName').html( monthnames[month] );
	$('[data-cmxdata="TempH"]').html( cmx_data.monthlyrecs.hightemp[month] );
	$('[data-cmxdata="TempHT"]').html( cmx_data.monthlyrecs.hightempT[month]);

	$('[data-cmxdata="TempL"]').html( cmx_data.monthlyrecs.lowtemp[month]);
	$('[data-cmxdata="TempLT"]').html( cmx_data.monthlyrecs.lowtempT[month]);
	$('[data-cmxdata="DewPointH"]').html( cmx_data.monthlyrecs.highDP[month]);
	$('[data-cmxdata="DewPointHT"]').html(cmx_data.monthlyrecs.highDPT[month]);

	$("[data-cmxdata='DewPointL']").html( cmx_data.monthlyrecs.lowDP[month]);
	$("[data-cmxdata='DewPointLT']").html( cmx_data.monthlyrecs.lowDPT[month]);
	$("[data-cmxdata='AppTempH']").html( cmx_data.monthlyrecs.highapptemp[month]);
	$("[data-cmxdata='AppTempHT']").html( cmx_data.monthlyrecs.highapptempT[month]);
	$("[data-cmxdata='AppTempL']").html( cmx_data.monthlyrecs.lowapptemp[month]);
	$("[data-cmxdata='AppTempLT']").html( cmx_data.monthlyrecs.lowapptempT[month]);
	$("[data-cmxdata='FeelsLikeH']").html( cmx_data.monthlyrecs.highfeelslike[month]);
	$("[data-cmxdata='FeelsLikeHT']").html( cmx_data.monthlyrecs.highfeelslikeT[month]);
	$("[data-cmxdata='FeelsLikeL']").html( cmx_data.monthlyrecs.lowfeelslike[month]);
	$("[data-cmxdata='FeelsLikeLT']").html( cmx_data.monthlyrecs.lowfeelslikeT[month]);
	$("[data-cmxdata='WChillL']").html( cmx_data.monthlyrecs.lowchill[month]);

	$("[data-cmxdata='WChillLT']").html( cmx_data.monthlyrecs.lowchillT[month]);
	$("[data-cmxdata='HeatIndexH']").html( cmx_data.monthlyrecs.highheatindex[month]);
	$("[data-cmxdata='HeatIndexHT']").html( cmx_data.monthlyrecs.highheatindexT[month]);

	$("[data-cmxdata='MinTempH']").html( cmx_data.monthlyrecs.highmintemp[month]);
	$("[data-cmxdata='MinTempHT']").html( cmx_data.monthlyrecs.highmintempT[month]);

	$("[data-cmxdata='MaxTempL']").html( cmx_data.monthlyrecs.lowmaxtemp[month]);
	$("[data-cmxdata='MaxTempLT']").html( cmx_data.monthlyrecs.lowmaxtempT[month]);

	$("[data-cmxdata='HumH']").html( cmx_data.monthlyrecs.highhum[month]);
	$("[data-cmxdata='HumHT']").html( cmx_data.monthlyrecs.highhumT[month]);
	$("[data-cmxdata='HumL']").html( cmx_data.monthlyrecs.lowhum[month]);
	$("[data-cmxdata='HumLT']").html( cmx_data.monthlyrecs.lowhumT[month]);

	$("[data-cmxdata='HighDailyTempRange']").html( cmx_data.monthlyrecs.hightemprange[month]);
	$("[data-cmxdata='HighDailyTempRangeT']").html( cmx_data.monthlyrecs.hightemprangeT[month]);
	$("[data-cmxdata='LowDailyTempRange']").html( cmx_data.monthlyrecs.lowtemprange[month]);
	$("[data-cmxdata='LowDailyTempRangeT']").html( cmx_data.monthlyrecs.lowtemprangeT[month]);

	$("[data-cmxdata='RainRateH']").html( cmx_data.monthlyrecs.rainrate[month]);
	$("[data-cmxdata='RainRateHT']").html( cmx_data.monthlyrecs.rainrateT[month]);
	$("[data-cmxdata='HourlyRainH']").html( cmx_data.monthlyrecs.hourlyrain[month]);
	$("[data-cmxdata='HourlyRainHT']").html( cmx_data.monthlyrecs.hourlyrainT[month]);
	$("[data-cmxdata='Rain24HourH']").html( cmx_data.monthlyrecs.rain24h[month]);
	$("[data-cmxdata='Rain24HourHT']").html( cmx_data.monthlyrecs.rain24hT[month]);
	$("[data-cmxdata='DailyRainH']").html( cmx_data.monthlyrecs.dailyrain[month]);
	$("[data-cmxdata='DailyRainHT']").html( cmx_data.monthlyrecs.dailyrainT[month]);
	$("[data-cmxdata='MonthlyRainH']").html( cmx_data.monthlyrecs.monthlyrain[month]);
	$("[data-cmxdata='MonthlyRainHT']").html( cmx_data.monthlyrecs.monthlyrainT[month]);
	$("[data-cmxdata='LongestDryPeriod']").html( cmx_data.monthlyrecs.dryperiod[month]);
	$("[data-cmxdata='LongestDryPeriodT']").html( cmx_data.monthlyrecs.dryperiodT[month]);
	$("[data-cmxdata='LongestWetPeriod']").html( cmx_data.monthlyrecs.wetperiod[month]);
	$("[data-cmxdata='LongestWetPeriodT']").html( cmx_data.monthlyrecs.wetperiodT[month]);
	$("[data-cmxdata='GustH']").html( cmx_data.monthlyrecs.highgust[month]);
	$("[data-cmxdata='GustHT']").html( cmx_data.monthlyrecs.highgustT[month]);
	$("[data-cmxdata='WindH']").html( cmx_data.monthlyrecs.highwind[month]);
	$("[data-cmxdata='WindHT']").html( cmx_data.monthlyrecs.highwindT[month]);
	$("[data-cmxdata='WindRunH']").html( cmx_data.monthlyrecs.highwindrun[month]);
	$("[data-cmxdata='WindRunHT']").html( cmx_data.monthlyrecs.highwindrunT[month]);
	$("[data-cmxdata='PressL']").html( cmx_data.monthlyrecs.lowpress[month]);
	$("[data-cmxdata='PressLT']").html( cmx_data.monthlyrecs.lowpressT[month]);
	$("[data-cmxdata='PressH']").html( cmx_data.monthlyrecs.highpress[month]);
	$("[data-cmxdata='PressHT']").html( cmx_data.monthlyrecs.highpressT[month]);
	$('#btnArray').children('button').attr("aria-pressed", false).removeClass('ow-theme-sub4');
	$('#btnMon' + month).attr('aria-pressed', true).addClass('ow-theme-sub4');
}
