/*
 Menu configuration file for NEW CuMX template
 Last modified: 2022/07/05 11:39:38
 menu.js - typical name, you define the one used in setpagedata.js

 It is STRONGLY RECOMMENDED that if you customise this file, you create a new file with a different name, e.g. mymenu.js
 and change setpagedata.js to use that file. This will avoid your customisations being accidentally overwritten during upgrades

 Properties:
   .menu             - can be 'b' (both menus), 'w' (wide menu ONLY), 'n' (narrow menu ONLY)
   .new_window:true  - forces the link to open in new browser window
   .forum:true       - flags a forum link menu item, it will use the url provided in CuMX config, if that is blank the menu item will be hidden
   .webcam:true      - flags a webcam link menu item, it will use the url provided in CuMX config, if that is blank the menu item will be hidden
*/

menuSrc = [
	{title: "Dashboard",    menu: "b",    url: "index.html"},
	{title: "Today",        menu: "b",    url: "today.html"},
	{title: "Yesterday",    menu: "b",    url: "yesterday.html"},
	{title: "Today-Yest",   menu: "b",    url: "todayyest.html"},
	{title: "Gauges",       menu: "b",    url: "gauges.html"},
	{title: "Records",      menu: "b",    submenu: true,       items: [
		{title: "This Month",        menu: "b",    url: "thismonth.html"},
		{title: "This Year",         menu: "b",    url: "thisyear.html"},
		{title: "All Time",          menu: "b",    url: "record.html"},
		{title: "Monthly",           menu: "b",    url: "monthlyrecord.html"}
	]},
	{title: "Charts",    menu: "b",    submenu: true,    items: [
		{title: "Trends",            menu: "b",    url: "trends.html"},
		{title: "Select-a-graph",    menu: "b",    url: "selectachart.html"},
		{title: "Historic",          menu: "b",    url: "historic.html"}
	]},
	{title: "Reports",   menu: "b",    url: "noaareport.html"},
	{title: "Forum",     menu: "b",    url: "#",    forum: true,    new_window: true},
	{title: "Webcam",    menu: "b",    url: "#",    webcam: true}
];
