/*	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * 	Script:	Monthly Records Data
 * 	File:	recordsmonthly.js
 * 	Role:	Collect and insert data into
 * 			monthly records page.
 * 			Uses data attributes rather than ID
 *  Based on monthlyrecsdata.js
 * 	V:		3.0.0
 * 	Author:	Neil Thomas
 * 	Edited:	30/11/2023 11:12
 * 	Checked:
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

// Last modified: 2022/07/27 15:35:57

$(function() {
	//console.log("Event triggered: " + JSON.stringify( dataLoadedPromise));
	dataLoadedPromise.then(function() {
		console.log('Promise fullfilled');
		removeBtns();
		var selected = sessionStorage.getItem('CMXMonthRecs');
		if ( selected != null ) {
			switch( selected) {
				case 'Alltime' :
					showAlltime();
					$('#btn' + selected).attr('aria-pressed', true).addClass('ow-theme-sub4');
					break;
				case 'ThisYear':
					showThisyear();
					$('#btn' + selected).attr('aria-pressed', true).addClass('ow-theme-sub4');
					break;
				default:
					changeData( selected );
					$('#btnMon' + selected).attr('aria-pressed', true).addClass('ow-theme-sub4');
			}
		} else {
			selected = new Date();
			selected.setDate(selected.getDate() - 1);
			changeData( selected.getMonth() );
			$('#btnMon' + selected.getMonth()).attr('aria-pressed', true).addClass('ow-theme-sub4');
		}
	});
});

let removeBtns = function() {
	var beganDate = new Date(cmxData.recordsbegandate);
	var thisYear = new Date();
	var btn;
	if( beganDate.getFullYear() == thisYear.getFullYear()) {
		for ( btn = 0; btn < beganDate.getMonth(); btn++) {
			$('#btnMon' + btn).addClass('w3-hide');
		}
		for ( btn = 11; btn > thisYear.getMonth(); btn--) {
			$('#btnMon' + btn).addClass('w3-hide');
		}
	}
};

var monthnames = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");

function changeData(month) {
	$('.ow-btnBar').children().removeClass('ow-theme-sub4');
	$(this).addClass('ow-theme-add4');
	sessionStorage.setItem('CMXMonthRecs', month);

	$('#MonthName').html('the month of ' + monthnames[month]);
	$('[data-cmxdata="TempH"]').html( cmxData.monthlyrecs.hightemp[month]);
	$('[data-cmxdata="TempHT"]').html(cmxData.monthlyrecs.hightempT[month]);

	$('[data-cmxdata="TempL"]').html(cmxData.monthlyrecs.lowtemp[month]);
	$('[data-cmxdata="TempLT"]').html(cmxData.monthlyrecs.lowtempT[month]);
	$('[data-cmxdata="DewPointH"]').html(cmxData.monthlyrecs.highDP[month]);
	$('[data-cmxdata="DewPointHT"]').html(cmxData.monthlyrecs.highDPT[month]);

	$("[data-cmxdata='DewPointL']").html(cmxData.monthlyrecs.lowDP[month]);
	$("[data-cmxdata='DewPointLT']").html(cmxData.monthlyrecs.lowDPT[month]);
	$("[data-cmxdata='AppTempH']").html(cmxData.monthlyrecs.highapptemp[month]);
	$("[data-cmxdata='AppTempHT']").html(cmxData.monthlyrecs.highapptempT[month]);
	$("[data-cmxdata='AppTempL']").html(cmxData.monthlyrecs.lowapptemp[month]);
	$("[data-cmxdata='AppTempLT']").html(cmxData.monthlyrecs.lowapptempT[month]);
	$("[data-cmxdata='FeelsLikeH']").html(cmxData.monthlyrecs.highfeelslike[month]);
	$("[data-cmxdata='FeelsLikeHT']").html(cmxData.monthlyrecs.highfeelslikeT[month]);
	$("[data-cmxdata='FeelsLikeL']").html(cmxData.monthlyrecs.lowfeelslike[month]);
	$("[data-cmxdata='FeelsLikeLT']").html(cmxData.monthlyrecs.lowfeelslikeT[month]);
	$("[data-cmxdata='WChillL']").html(cmxData.monthlyrecs.lowchill[month]);

	$("[data-cmxdata='WChillLT']").html(cmxData.monthlyrecs.lowchillT[month]);
	$("[data-cmxdata='HeatIndexH']").html(cmxData.monthlyrecs.highheatindex[month]);
	$("[data-cmxdata='HeatIndexHT']").html(cmxData.monthlyrecs.highheatindexT[month]);

	$("[data-cmxdata='MinTempH']").html(cmxData.monthlyrecs.highmintemp[month]);
	$("[data-cmxdata='MinTempHT']").html(cmxData.monthlyrecs.highmintempT[month]);

	$("[data-cmxdata='MaxTempL']").html(cmxData.monthlyrecs.lowmaxtemp[month]);
	$("[data-cmxdata='MaxTempLT']").html(cmxData.monthlyrecs.lowmaxtempT[month]);

	$("[data-cmxdata='HumH']").html(cmxData.monthlyrecs.highhum[month]);
	$("[data-cmxdata='HumHT']").html(cmxData.monthlyrecs.highhumT[month]);
	$("[data-cmxdata='HumL']").html(cmxData.monthlyrecs.lowhum[month]);
	$("[data-cmxdata='HumLT']").html(cmxData.monthlyrecs.lowhumT[month]);

	$("[data-cmxdata='HighDailyTempRange']").html(cmxData.monthlyrecs.hightemprange[month]);
	$("[data-cmxdata='HighDailyTempRangeT']").html(cmxData.monthlyrecs.hightemprangeT[month]);
	$("[data-cmxdata='LowDailyTempRange']").html(cmxData.monthlyrecs.lowtemprange[month]);
	$("[data-cmxdata='LowDailyTempRangeT']").html(cmxData.monthlyrecs.lowtemprangeT[month]);

	$("[data-cmxdata='RainRateH']").html(cmxData.monthlyrecs.rainrate[month]);
	$("[data-cmxdata='RainRateHT']").html(cmxData.monthlyrecs.rainrateT[month]);
	$("[data-cmxdata='HourlyRainH']").html(cmxData.monthlyrecs.hourlyrain[month]);
	$("[data-cmxdata='HourlyRainHT']").html(cmxData.monthlyrecs.hourlyrainT[month]);
	$("[data-cmxdata='Rain24HourH']").html(cmxData.monthlyrecs.rain24h[month]);
	$("[data-cmxdata='Rain24HourHT']").html(cmxData.monthlyrecs.rain24hT[month]);
	$("[data-cmxdata='DailyRainH']").html(cmxData.monthlyrecs.dailyrain[month]);
	$("[data-cmxdata='DailyRainHT']").html(cmxData.monthlyrecs.dailyrainT[month]);
	$("[data-cmxdata='MonthlyRainH']").html(cmxData.monthlyrecs.monthlyrain[month]);
	$("[data-cmxdata='MonthlyRainHT']").html(cmxData.monthlyrecs.monthlyrainT[month]);
	$("[data-cmxdata='LongestDryPeriod']").html(cmxData.monthlyrecs.dryperiod[month]);
	$("[data-cmxdata='LongestDryPeriodT']").html(cmxData.monthlyrecs.dryperiodT[month]);
	$("[data-cmxdata='LongestWetPeriod']").html(cmxData.monthlyrecs.wetperiod[month]);
	$("[data-cmxdata='LongestWetPeriodT']").html(cmxData.monthlyrecs.wetperiodT[month]);
	$("[data-cmxdata='GustH']").html(cmxData.monthlyrecs.highgust[month]);
	$("[data-cmxdata='GustHT']").html(cmxData.monthlyrecs.highgustT[month]);
	$("[data-cmxdata='WindH']").html(cmxData.monthlyrecs.highwind[month]);
	$("[data-cmxdata='WindHT']").html(cmxData.monthlyrecs.highwindT[month]);
	$("[data-cmxdata='WindRunH']").html(cmxData.monthlyrecs.highwindrun[month]);
	$("[data-cmxdata='WindRunHT']").html(cmxData.monthlyrecs.highwindrunT[month]);
	$("[data-cmxdata='PressL']").html(cmxData.monthlyrecs.lowpress[month]);
	$("[data-cmxdata='PressLT']").html(cmxData.monthlyrecs.lowpressT[month]);
	$("[data-cmxdata='PressH']").html(cmxData.monthlyrecs.highpress[month]);
	$("[data-cmxdata='PressHT']").html(cmxData.monthlyrecs.highpressT[month]);
	$('#btnArray').children('button').attr("aria-pressed", false).removeClass('ow-theme-sub4');
	$('#btnMon' + month).attr('aria-pressed', true).addClass('ow-theme-sub4');
}

let showAlltime = function( ) {
	//	Handle Alltime
	$('.ow-btnBar').children().removeClass('ow-theme-sub4');
	$(this).addClass('ow-theme-add4');
	sessionStorage.setItem('CMXMonthRecs', 'Alltime');

	$('#MonthName').html('All-time');

	$('[data-cmxdata="TempH"]').html( cmxData.tempH);
	$('[data-cmxdata="TempHT"]').html(cmxData.TtempH);

	$('[data-cmxdata="TempL"]').html(cmxData.tempL);
	$('[data-cmxdata="TempLT"]').html(cmxData.TtempL);
	$('[data-cmxdata="DewPointH"]').html(cmxData.dewpointH);
	$('[data-cmxdata="DewPointHT"]').html(cmxData.TdewpointH);

	$("[data-cmxdata='DewPointL']").html(cmxData.dewpointL);
	$("[data-cmxdata='DewPointLT']").html(cmxData.TdewpointL);
	$("[data-cmxdata='AppTempH']").html(cmxData.apptempH);
	$("[data-cmxdata='AppTempHT']").html(cmxData.TapptempH);
	$("[data-cmxdata='AppTempL']").html(cmxData.apptempL);
	$("[data-cmxdata='AppTempLT']").html(cmxData.TapptempL);

	$("[data-cmxdata='FeelsLikeH']").html(cmxData.feelslikeH);
	$("[data-cmxdata='FeelsLikeHT']").html(cmxData.TfeelslikeH);
	$("[data-cmxdata='FeelsLikeL']").html(cmxData.feelslikeL);
	$("[data-cmxdata='FeelsLikeLT']").html(cmxData.TfeelslikeL);

	$("[data-cmxdata='WChillL']").html(cmxData.wchillH);
	$("[data-cmxdata='WChillLT']").html(cmxData.TwchillH);

	$("[data-cmxdata='HeatIndexH']").html(cmxData.heatindexH);
	$("[data-cmxdata='HeatIndexHT']").html(cmxData.TheatindexH);

	$("[data-cmxdata='MinTempH']").html(cmxData.mintempH);
	$("[data-cmxdata='MinTempHT']").html(cmxData.TmintempH);
	$("[data-cmxdata='MaxTempL']").html(cmxData.maxtempL);
	$("[data-cmxdata='MaxTempLT']").html(cmxData.TmaxtempL);

	$("[data-cmxdata='HumH']").html(cmxData.humH);
	$("[data-cmxdata='HumHT']").html(cmxData.ThumH);
	$("[data-cmxdata='HumL']").html(cmxData.humL);
	$("[data-cmxdata='HumLT']").html(cmxData.ThumL);

	$("[data-cmxdata='HighDailyTempRange']").html(cmxData.HighDailyTempRange);
	$("[data-cmxdata='HighDailyTempRangeT']").html(cmxData.THighDailyTempRange);
	$("[data-cmxdata='LowDailyTempRange']").html(cmxData.LowDailyTempRange);
	$("[data-cmxdata='LowDailyTempRangeT']").html(cmxData.TLowDailyTempRange);
	/*	Rainfall	*/
	$("[data-cmxdata='DailyRainH']").html(cmxData.rfallH);
	$("[data-cmxdata='DailyRainHT']").html(cmxData.TrfallH);
	$("[data-cmxdata='RainRateH']").html(cmxData.rrateM);
	$("[data-cmxdata='RainRateHT']").html(cmxData.TrrateM);

	$("[data-cmxdata='HourlyRainH']").html(cmxData.rfallhH);
	$("[data-cmxdata='HourlyRainHT']").html(cmxData.TrfallhH);

	$("[data-cmxdata='Rain24HourH']").html(cmxData.r24hourH);
	$("[data-cmxdata='Rain24HourHT']").html(cmxData.Tr24hourH);

	$("[data-cmxdata='MonthlyRainH']").html(cmxData.rfallmH);
	$("[data-cmxdata='MonthlyRainHT']").html(cmxData.TrfallmH);

	$("[data-cmxdata='LongestDryPeriod']").html(cmxData.LongestDryPeriod);
	$("[data-cmxdata='LongestDryPeriodT']").html(cmxData.TLongestDryPeriod);
	$("[data-cmxdata='LongestWetPeriod']").html(cmxData.LongestWetPeriod);
	$("[data-cmxdata='LongestWetPeriodT']").html(cmxData.TLongestWetPeriod);
	/*	Winds	*/
	$("[data-cmxdata='GustH']").html(cmxData.gustM);
	$("[data-cmxdata='GustHT']").html(cmxData.TgustM);
	$("[data-cmxdata='WindH']").html(cmxData.wspeedH);
	$("[data-cmxdata='WindHT']").html(cmxData.TwspeedH);

	$("[data-cmxdata='WindRunH']").html(cmxData.windrunH);
	$("[data-cmxdata='WindRunHT']").html(cmxData.TwindrunH);
	/*	Pressure	*/
	$("[data-cmxdata='PressH']").html(cmxData.pressH);
	$("[data-cmxdata='PressHT']").html(cmxData.TpressH);
	$("[data-cmxdata='PressL']").html(cmxData.pressL);
	$("[data-cmxdata='PressLT']").html(cmxData.TpressL);

	$('#btnArray').children('button').attr("aria-pressed", false).removeClass('ow-theme-sub4');
	$('#btnAlltime').attr('aria-pressed', true).addClass('ow-theme-sub4');

};

let showThisyear = function( ) {
	//	Handle This Year
	$('.ow-btnBar').children().removeClass('ow-theme-sub4');
	$(this).addClass('ow-theme-add4');
	sessionStorage.setItem('CMXMonthRecs', 'ThisYear');

	$('#MonthName').html('this year');

	$('[data-cmxdata="TempH"]').html( cmxData.YearTempH);
	$('[data-cmxdata="TempHT"]').html(cmxData.YearTempHT + ' on ' + cmxData.YearTempHD);

	$('[data-cmxdata="TempL"]').html(cmxData.YearTempL);
	$('[data-cmxdata="TempLT"]').html(cmxData.YearTempLT + ' on ' + cmxData.YearTempLD);
	$('[data-cmxdata="DewPointH"]').html(cmxData.YearDewPointH);
	$('[data-cmxdata="DewPointHT"]').html(cmxData.YearDewPointHT + ' on ' + cmxData.YearDewPointHD);

	$("[data-cmxdata='DewPointL']").html(cmxData.YearDewPointL);
	$("[data-cmxdata='DewPointLT']").html(cmxData.YearDewPointLT + ' on ' + cmxData.YearDewPointLD);

	$("[data-cmxdata='AppTempH']").html(cmxData.YearAppTempH);
	$("[data-cmxdata='AppTempHT']").html(cmxData.YearAappTempHT + ' on ' + cmxData.YearAppTempHD);
	$("[data-cmxdata='AppTempL']").html(cmxData.YearAppTempL);
	$("[data-cmxdata='AppTempLT']").html(cmxData.YearAppTempLT + ' on ' + cmxData.AppTempHD);

	$("[data-cmxdata='FeelsLikeH']").html(cmxData.YearFeelsLikeH);
	$("[data-cmxdata='FeelsLikeHT']").html(cmxData.YearFeelsLikeHT + ' on ' + cmxData.YearFeelsLikeHD);
	$("[data-cmxdata='FeelsLikeL']").html(cmxData.YearFeelsLikeL);
	$("[data-cmxdata='FeelsLikeLT']").html(cmxData.YearFeelsLikeLT + ' on ' + cmxData.YearFeelsLikeHD);

	$("[data-cmxdata='WChillL']").html(cmxData.YearWChillL);
	$("[data-cmxdata='WChillLT']").html(cmxData.YearWChillLT + ' on ' + cmxData.YearWChillLD);

	$("[data-cmxdata='HeatIndexH']").html(cmxData.YearHeatIndexH);
	$("[data-cmxdata='HeatIndexHT']").html(cmxData.YearHeatIndexHT + ' on ' + cmxData.YearHeatIndexHD);

	$("[data-cmxdata='MinTempH']").html(cmxData.YearMinTempH);
	$("[data-cmxdata='MinTempHT']").html('on ' + cmxData.YearMinTempHD);
	$("[data-cmxdata='MaxTempL']").html(cmxData.YearMaxTempL);
	$("[data-cmxdata='MaxTempLT']").html('on ' + cmxData.YearMaxTempLD);

	$("[data-cmxdata='HumH']").html(cmxData.YearHumH);
	$("[data-cmxdata='HumHT']").html(cmxData.YearHumHT + ' on ' + cmxData.YearHumHD);
	$("[data-cmxdata='HumL']").html(cmxData.YearHumL);
	$("[data-cmxdata='HumLT']").html(cmxData.YearHumLT  + ' on ' + cmxData.YearHumLD);

	$("[data-cmxdata='HighDailyTempRange']").html(cmxData.YearHighDailyTempRange);
	$("[data-cmxdata='HighDailyTempRangeT']").html('on ' + cmxData.YearHighDailyTempRangeD);
	$("[data-cmxdata='LowDailyTempRange']").html(cmxData.YearLowDailyTempRange);
	$("[data-cmxdata='LowDailyTempRangeT']").html('on ' + cmxData.YearLowDailyTempRangeD);
	/*	Rainfall	*/
	$("[data-cmxdata='DailyRainH']").html(cmxData.YearDailyRainH);
	$("[data-cmxdata='DailyRainHT']").html(cmxData.YearDailyRainHD);
	$("[data-cmxdata='RainRateH']").html(cmxData.YearRainRateH);
	$("[data-cmxdata='RainRateHT']").html(cmxData.YearRainRateHT + ' on ' + cmxData.YearRainRateHD);

	$("[data-cmxdata='HourlyRainH']").html(cmxData.YearHourlyRainH);
	$("[data-cmxdata='HourlyRainHT']").html(cmxData.YearHourlyRainHT + ' on ' + cmxData.YearHourlyRainHD);

	$("[data-cmxdata='Rain24HourH']").html(cmxData.YearRain24HourH);
	$("[data-cmxdata='Rain24HourHT']").html(cmxData.YearRain24HourHT + ' on ' + cmxData.YearRain24HourHD);

	$("[data-cmxdata='MonthlyRainH']").html(cmxData.YearMonthlyRainH);
	$("[data-cmxdata='MonthlyRainHT']").html(cmxData.YearMonthlyRainHD);

	$("[data-cmxdata='LongestDryPeriod']").html(cmxData.YearLongestDryPeriod);
	$("[data-cmxdata='LongestDryPeriodT']").html(cmxData.YearLongestDryPeriodD);
	$("[data-cmxdata='LongestWetPeriod']").html(cmxData.YearLongestWetPeriod);
	$("[data-cmxdata='LongestWetPeriodT']").html(cmxData.YearLongestWetPeriodD);
	/*	Winds	*/
	$("[data-cmxdata='GustH']").html(cmxData.YearGustH);
	$("[data-cmxdata='GustHT']").html(cmxData.YearGustHT + ' on ' + cmxData.YearGustHD);
	$("[data-cmxdata='WindH']").html(cmxData.YearWindH);
	$("[data-cmxdata='WindHT']").html(cmxData.YearWindHT + ' on ' + cmxData.YearGustHD);

	$("[data-cmxdata='WindRunH']").html(cmxData.YearWindRunH);
	$("[data-cmxdata='WindRunHT']").html('on ' + cmxData.YearWindRunHD);
	/*	Pressure	*/
	$("[data-cmxdata='PressH']").html(cmxData.YearPressH);
	$("[data-cmxdata='PressHT']").html(cmxData.YearPressHT + ' on ' + cmxData.YearPressHD);
	$("[data-cmxdata='PressL']").html(cmxData.YearPressL);
	$("[data-cmxdata='PressLT']").html(cmxData.YearPressLT + ' on ' + cmxData.YearPressLD);

	$('#btnArray').children('button').attr("aria-pressed", false).removeClass('ow-theme-sub4');
	$('#btnThisYear').attr('aria-pressed', true).addClass('ow-theme-sub4');
};

let showThisMonth = function() {
	var current = new Date();
	current.setDate( current.getDate() - 1);
	changeData( current.getMonth() );
};
