/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Script: page-manager.js         v:3.0.0
    Author: Neil Thomas            Nov 2024
    Edited: 29/11/2024
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Role:   Provide all utility scripts
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

let CMXConfig = {};
let menu = '';
let mobileMenu ='';

//  Development only - uncomment to review changes.  REMEMBER to comment afterwards
//sessionStorage.clear()

//  Configure name for storage object
let axStore = document.baseURI.split('/');
if( axStore.length < 5 ){
    axStore = 'root-cmxAI';
} else {
    axStore = axStore[ axStore.length - 2] + '-cmxWeb';
}

let getConfig = function( store ) {
    //  Select storage type
    var storedCFG  = JSON.parse(sessionStorage.getItem( store ));
    if( storedCFG == null) {
        //  Nothing stored
        CMXConfig = {
            'Data': '',
            'Menu': 'js/aw-menu.js',
            'NOAAReportPath': 'Reports/',
            'Theme': '',
            'StaticHead': true,
            'StaticFoot': true,
            'paddingTop': 2,
            'paddingBottom': 1,
            'paddingUnits': 'em',
            'Seagull': {
                'Animation': '',
                'Speed': 3,
                'OnTop': false
            },
            'Charts':{
                'Trends': '',
                'Historic':''
            },
            'Records':{
                'All':'',
                'Monthly':''
            }
        }
        //  Store configuration
        sessionStorage.setItem(store, JSON.stringify( CMXConfig ));
    } else {
        //  Use stored configuration
        CMXConfig = storedCFG;
    }
}

let checkTheme = function() {
    //  Check if theme change required
    if( CMXConfig.Theme != '' ){
        console.log('Setting theme to ' + CMXConfig.Theme);
        $('#theme').attr('href', 'css/themes/' + CMXConfig.Theme + '.css' );
    } else {
        console.log('Theme change NOT required');
    }
}

getConfig( axStore  );

checkTheme();

$('window').on('resize', function() {
    configPage();
});

//  This starts it all off!
let dataLoadedPromise = new Promise((myResolve, myReject) => {
    
    $( function() {
        getConfig( axStore );
        getPageData(myResolve, myReject);   //  Collects the published website data from 'websitedata.json'
        configPage( axStore );
        $('[data-OWdata=Version]').html( '3.0' ); 
    });
});

let configPage = function() {
    //  Get the height of the header & footer
    var headHeight = $('#PageHead').outerHeight( true ) ;
    var footHeight = $('#PageFoot').outerHeight( true );
    var contentHeight = $(window).height() - (headHeight + footHeight);
    $('#content').css('min-height', contentHeight  + 'px');
    if( CMXConfig.StaticHead ) {
        //  Header is fixed - need to add margin to content
        $('#PageHead').addClass('ax-top');
        $('#content').css('margin-top', headHeight + 'px');
    } else {
        //  Header scrolls
        $('#PageHead').removeClass('ax-top').css('position','relative');
        $('#content').css('margin-top','0px');
    }
    if( CMXConfig.StaticFoot ) {
        if( $(window).height() > 920 ) {
            //  Tall screen orientation
            $('#PageFoot').addClass('ax-bottom');
            $('#content').css('margin-bottom', footHeight + 'px');
            $('#ax-gull').css('bottom', footHeight + 'px'); // Gull sits ON footer
        } else {
            $('#ax-gull').css('position','absolute'); // Gull on bottom of page
            $('#PageFoot').removeClass('ax-bottom');
        }
    } else {
        $('#ax-gull').css('position', 'absolute');  // Gull on bottom of page
    }
    //  Top Padding
    $('#content').css('padding-top', CMXConfig.PaddingTop + CMXConfig.PaddingUnits);
    //  Bottom padding
    $('#content').css('padding-bottom', CMXConfig.PaddingBottom + CMXConfig.PaddingUnits);
    //  Seagull
    if( CMXConfig.Seagull.OnTop) {
        $('#ax-gull').css( 'z-index','200');
    } else {
        $('#ax-gull').css( 'z-index','-200');
    }
    //  Animation
    if( CMXConfig.Seagull.Animation =='') {
        $('#ax-gull').css('aniation', 'fadeIn ' + CMXConfig.Seagull.Speed + 's' );  // Default animation
    } else {
        switch( CMXConfig.Seagull.Animation){
            case 'fadeDown':;
            case 'fadeAcrossDown': $('#ax-gull').css('transform-origin', 'top left');break;
            default: $('#ax-gull').css('transform-origin', 'bottom center');
        }
        $('#ax-gull').css('animation', CMXConfig.Seagull.Animation + ' ' + CMXConfig.Seagull.Speed + 's');
    }
}

let toggleMenus = function() {
    //  Switches between standard and mobile menu
    if($('#Main_Menu_Mobile').hasClass('ax-hide')) {
        $('#Main_Menu_Mobile').removeClass('ax-hide');
    } else {
        $('#Main_Menu_Mobile').addClass('ax-hide');
    }
}

let toggleDropDown = function( dropdown ){
    //  Displayes / Hides dropdowns in menus
    console.log("Function called with id " + dropdown.id );
    $('#DD' + dropdown.id.replace(/ /g,'_').toggleClass( 'ax-show' );
}

//  Website menus - called by getPageData()
let createMainMenu = function(src, submenu, IDSuffix) {
    var infill, Icon;
    let classMain = 'ax-bar-item ax-btn ax-hide-small ax-hide-medium';
    let classMainSub = 'ax-bar-item ax-btn';

    src.forEach(function(itm) {
        if (itm.menu !== 'n') { // wanted in main menu
            if (itm.submenu) { // drop down
                menu += '<div class="ax-dropdown-hover ax-hide-medium ax-hide-small">\n';   // The Drop down hover panel
                menu += '\t<button id="' +  itm.title.replace(/ /g,"_") + IDSuffix + '" type="button" ';
                menu += 'class="ax-btn ax-theme5" onclick="toggleDropDown(this)" aria-expanded="false" >';
                menu +=  itm.title + '&nbsp;<i class="fa-solid fa-caret-down fa-sm"></i></button>\n';     // The button
                menu += '\t<div id="DD' +  itm.title.replace(/ /g,"_") + 'Ma" class="ax-dropdown-content ax-bar-block ax-card ax-theme5 ax-animate-menu">\n';
                // add the sub-menu items
                createMainMenu(itm.items, true, IDSuffix);
                menu += '\n\t</div>\n</div>\n';
            } else {
                //  Item is a menu entry
                infill = (itm.new_window ? ' target="_blank"' : '');
                Icon = (itm.icon ? '<i class="' + itm.icon + '"></i>' : '');
                
                if( itm.url == "#") {// Its special
                    if( itm.forum && cmxData.forumurl != ''){
                        menu += '<a href="' + cmxData.forumurl + '"' + infill + ' class="' + (submenu ? classMainSub : classMain) + '">' + itm.title + '</a>\n';
                    }
                    if( itm.webcam && cmxData.webcamurl !=''){
                        menu += '<a href="' + cmxData.webcamurl + '"' + infill + ' class="' + (submenu ? classMainSub : classMain) + '">' + itm.title + '</a>\n';
                    }
                } else {
                    if( itm.url == '_') {
                        //  Display dividing bar rather than menu item
                        menu += '<div class="ax-menu-line"></div>';
                    } else if( itm.title == 'Dashboard'){
                        //  Build the 'Dashboard' menu item - this is constant and not part of the mobile menu
                        menu += '<a href="' + itm.url +'"' + infill + ' class="ax-bar-item ax-btn" ' + '">' + itm.title + '</a>\n';
                    } else {
                        //  This builds a standard menu entry
                        menu += '<a href="' + itm.url + '"' + infill + ' class="' + (itm.submenu ? classMainSub : classMain) + '">' + itm.title + Icon + '</a>\n';
                    }
                }
            }
        }
    });
    // if we are processing a sub menu, return to the main loop
    if (submenu)
        return;
    //  Finally add the hamburger menu item
    menu += '<a href="javascript:void(0)" class="ax-bar-item ax-btn ax-hide-large ax-right" onClick="toggleMenus()">Menu <i class="fa-solid fa-bars fa-lg"></i></a>';
    // stick the menus into the page
    $('#Main_Menu').html(menu);
};

let createMobileMenu = function(src, submenu, IDSuffix) {
    let classMobile = 'ax-bar-item ax-btn';
    let classMobileSub = 'ax-bar-item ax-btn ax-subMenu';
    var infill, Icon;
    src.forEach(function(itm) {
        if (itm.menu !== 'w') { // wanted in narrow menu
        // mobile menu
            if (itm.submenu) {
                mobileMenu += '<div class="ax-dropdown-click">';    //  Drop down panel
                mobileMenu += '\t<button id="' + itm.title + IDSuffix + '" class="ax-btn ax-theme5" onClick="toggleDropDown(this);">';
                mobileMenu += itm.title + '&nbsp;<i class="fa-solid fa-caret-down fa-sm"></i></button>\n';  //  Button
                mobileMenu += '<div id="DD'+itm.title.replace(/ /g,"_") + IDSuffix + '" class="ax-dropdown-content ax-bar-block ax-theme5">';
                //  Recall to fill panel
                createMobileMenu(itm.items, true, IDSuffix);
                mobileMenu += '\t\n</div>\n</div>\n';
            } else {
                //  Item is a menu entry
                infill = (itm.new_window ? " target='_blank' " : "");
                Icon = (itm.icon ? '<i class="' + itm.icon + '"></i>' : '');
                if( itm.url == '#' ) {
                    //  Its a special case
                    if( itm.forum && cmxData.forumurl != '' ) {
                        mobileMenu += '<a href="' +  cmxData.forumurl + '"' + infill + ' class="' + classMobile + '">' + itm.title + Icon + '</a>\n';
                    }
                    if( itm.webcam && cmxData.webcamurl != '' ){
                        mobileMenu += '<a href="' +  cmxData.webcamurl + '"' + infill + ' class="' + classMobile + '">' + itm.title + Icon +'</a>\n';
                    }
                } else {
                    if( itm.url == '_' ){
                        //  Display dividing bar rather than menu item
                        menu += '<div class="ax-menu-line"></div>';
                    } else if (itm.title != "Dashboard") {
                        mobileMenu += '<a href="' +  itm.url + '" ' + infill + ' class="' + (itm.submenu ? classMobileSub : classMobile ) + '">' + itm.title + Icon + '</a>\n';
                    }
                }
            }
        }
    });
    // if we are processing a sub menu, return to the main loop
    if (submenu)
        return;
    // stick the menus into the page
    $('#Main_Menu_Mobile').html(mobileMenu);
};

let showModal = function(PopUp){
    if( $('#' + PopUp ).css('display') == 'none') {
        $('#' + PopUp ).css('display','block');
    } else {
        $('#' + PopUp ).css('display', 'none');
    }
    //  Move popup to verical position
    $('#' + PopUp + ' div').first().css('transform', 'translateY(30vh)')
}

function addLeadingZeros(n) {
    return n <= 9 ? '0' + n : n;
}
