/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Script: data-manager.js         v:3.0.0
    Author: Neil Thomas            Dec 2024
    Edited: 02/12/2024
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Role:   Provide all scripts that manage
        data
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

let cmxdata;
//let dataPath = '../data';
let dataPath = CMXConfig.Data;
let initialLoad = true;
let activePages = ['index', 'today', 'todayVyest', 'template'];
//  ~~~~    You can change these to suite your language.
let monthName = ["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];
let dayName = ["Sun","Mon","Tue","Wed","Thu","Fri","Sat"];
//  Check path ending
if( dataPath.length > 0 && dataPath.slice(-1) != '/') { dataPath += '/'; }


let getPageData = function( resolve, reject) {
    $.getJSON( dataPath + 'websitedata.json?_=' + Date.now(), function(  json ){
        let pageName = window.location.href.split('/').pop().split('.')[0];
        if( activePages.indexOf( pageName ) >= 0 || pageName == '') {
            setTimeout( function() {
                getPageData( null, null );
            }, 60 * 1000);
        }

        cmxData = json ;

        //  Adjust header values
        $(document).prop('title', cmxData.location + ' weather');
        $('meta[name=description]').attr('content', cmxData.location + ' weather data');
        $('meta[name=keywords]').attr('content', $('meta[name=keywords]').attr('content') + ', ' + cmxData.location);

        if( initialLoad ) {
            $.getScript( CMXConfig.Menu, function() {
                createMainMenu( menuSrc, false, 'Ma' );
                createMobileMenu( menuSrc, false, 'Mo' );
            });
            initialLoad = false;
        }

        //  Show ~ Hide 'Apparent / FeelsLike' elements
        if( cmxData.options.useApparent === '1' ) {
            $('[data-cmx-Apparent]').removeClass('ax-hide');
            $('[data-cmx-FeelsLike]').addClass('ax-hide');
        }

        //  Show / hide ALL solar data
        if( cmxData.options.showSolar === '0' && cmxData.options.showUV === '0'){
            $('[data-cmx-NoSolar]').addClass('ax-hide');
        }
        // Show ~ Hide 'Solar' elements
        if( cmxData.options.showSolar === '1' ) {
            $('[data-cmx-Solar]').removeClass('ax-hide');
        } else {
            $('[data-cmx-SolarGauge]').addClass( 'ax-hide' );
        }

        // Show ~ Hide 'UV' elements
        if( cmxData.options.showUV === '1' ){
            $('[data-cmx-UV]').removeClass('ax-hide');
        } else {
            $('[data-cmx-UVGauge]').addClass('ax-hide');
        }

        //  Show ~ Hide 'current conditions' element
        if( cmxData.currcond != '' ) {
            $('[data-cmxCurrCond]').removeClass('ax-hide');
        } else {
            $('[data-cmxCurrCond]').addClass('ax-hide');
        }
        
        //	Add formatted LastRainTime tag
        var rd = new Date( cmxData.LastRainTipISO );
        var LastRainTime = "" + dayName[rd.getDay()] + ' ' + rd.getDate() + ' ' + monthName[rd.getMonth()] + ' ' +rd.getFullYear() + 
            ' @ ' + addLeadingZeros(rd.getHours()) + ':' + addLeadingZeros(rd.getMinutes());
        LastRainTime = addLeadingZeros(rd.getHours()) + ':' + addLeadingZeros(rd.getMinutes()) + ' on ' +
            dayName[rd.getDay()] + ' ' + rd.getDate() + ' ' + monthName[rd.getMonth()] + ' ' + rd.getFullYear();
        cmxData.LastRainTime = LastRainTime;

        // Update all spans with data-cmxData tags
        $('[data-cmxData]').each( function() {
            this.innerHTML = cmxData[this.dataset.cmxdata];
        });

        //  Show / Hide Lightning strikes if NONE today
        if( typeof(cmxData.LightningTime)=="undefined" || cmxData.LightningTime == "---") {
            $('[data-cmxData-Lightning]').addClass('ax-hide');
        } else {
            if( cmxData.LightningStrikesToday == "0") {
                $('[data-cmxData-Strikes]').addClass('ax-hide');
            } else {
                $('[data-cmxData-Strikes]').removeClass('ax-hide');
            }
        }

        //  Show / Hide Wet Bulb
        if( typeof( cmxData.wetbulb) =='undefined') {
            $('[data-cmxData-wetbulb]').addClass('ax-hide');
        }

        //  Add the time of the last rainfall
        $('[data-cmxData="LastRainTime"]').text( cmxData.LastRainTime);

        if (null !== resolve) {
            resolve();
        }
    })

    .fail( function( jqxhr, textStatus, error) {
        let err = textStatus + ', ' + error;
        console.log('Data request failed: ' + err );

        if( null !== reject) {
            reject;
        }

        setTimeout( function() {
            getPageData( resolve, reject );
        }, 5000 );
    })
}
    