var chart, config, freezing, compassP;

$(document).ready(function () {

	$.ajax({url: "api/settings/version.json", dataType: "json", success: function (result) {
			$('#Version').text(result.Version);
			$('#Build').text(result.Build);
		}});

	$.ajax({url: "api/graphdata/graphconfig.json", success: function (result) {
			config = result;
			freezing = config.temp.units === 'C' ? 0 : 32 ;
			compassP = function (deg) {
				var a = ['N', 'NE', 'E', 'SE', 'S', 'SW', 'W', 'NW'];
				return a[Math.floor((deg + 22.5) / 45) % 8];
			};
			doTemp();
			$("#Temp").addClass("w3-camo-sandstone");
		}});
});

function getChart(chart) {
	$(".chartBtn").removeClass("w3-camo-sandstone");
	$("#"+chart).addClass("w3-camo-sandstone");
	switch (chart) {
		case 'Temp':		doTemp();		break;
		case 'Pressure' :	doPressure();	break;
		case 'Wind' :		doWind();		break;
		case 'WindDir' :	doWindDir();	break;
		case 'Humidity' :	doHumidity();	break;
		case 'Rainfall': 	doRainfall();	break;
		case 'Solar': 		doSolar();		break;
		case 'Sunshine': 	doSunshine();	break;
		case 'TempDaily':	doTempDaily();	break;
		case 'RainDaily':	doRainDaily();	break;
	}
};

var doTemp = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'line',
			alignTicks: false,
			zoomType: 'x'
		},
		title: {text: 'Temperature'},
		credits: {enabled: false},
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: {	day: '%b %e'	},
			plotBands: [ {	// Use to add a virtical band to indicate any event needed.
				from: Date.UTC(2016,11,10, 18,20),
				to: Date.UTC(2016, 11, 11, 11, 10),
				color: 'rgba(128, 128, 128, 0.2)',
				zIndex: 2,
				//label: { text: 'Wind sensor failure', verticalAlign: 'bottom', y: -10}	// Comment out label when event has passed rether than delete
			}],
		},
		yAxis: [{
			// Primary Virtical Axis
			title: {text: 'Temperature (°' + config.temp.units + ')'},
			opposite: false,
			showLastLabel: true,
			labels: {
				align: 'right',
				x: -8,
				y: 5,
				formatter: function () {
					if (this.value == freezing ) {
						return '<span style="color: #604040;">' + this.value + '°</span>';
					} else {
						return '<span style="fill: ' + (this.value <= 0 ? 'blue' : 'red') + ';">' + this.value + '°</span>';
					}
				}
			},
			plotLines: [{	// freezing line
				value: freezing,
				color: 'rgba(0, 0, 180, 0.4)',
				width: 1,
				zIndex: 2,
				label: {
					text: 'Freezing',
					textAlign: 'left',
					x: 10
				}
			}],
			plotBands: [{	// Shade blow freezing pale blue
				from: -30,
				to: 0,
				color: 'rgba(128, 128, 255, 0.1)'
			}]
		}, {	// right
			linkedTo: 0,
			gridLineWidth: 0,
			showLastLabel: true,
			opposite: true,
			title: {text: null},
			labels: {
				align: 'left',
				x: 8,
				y: 6,
				formatter: function () {
					if (this.value == freezing ) {
						return '<span style="color: #604040;">' + this.value + '°</span>';
					} else {
					   return '<span style="fill: ' + (this.value <= 0 ? 'blue' : 'red') + ';">' + this.value + '°</span>';
					}
				}
			}
		}],
		legend: {enabled: true},
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: { opacity: 0.25 }
					}
				},
				cursor: 'pointer',
				marker: {
					states: {
						hover: { radius: 1 }
					}
				}
			},
			line: { lineWidth: 1 }
		},
		tooltip: {
			shared: true,
			crosshairs: true,
			valueSuffix: '°' + config.temp.units,
			valueDecimals: config.temp.decimals,
			xDateFormat: "%A, %b %e, %H:%M",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Temperature',
			zIndex: 99,
			lineWidth: 2
		}, {
			name: 'Dew Point'
		}, {
			name: 'Apparent'
		}, {
			name: 'Wind Chill'
		}, {
			name: 'Heat Index'
		}, {
			name: 'Inside',
			visible: false
		}],
		rangeSelector: {
			buttons: [{
				type: 'hour',
				count: 6,
				text: '6h'
			}, {
				type: 'hour',
				count: 12,
				text: '12h'
			}, {
				type: 'hour',
				count: 24,
				text: '24hr'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/tempdata.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.temp);
			chart.series[1].setData(resp.dew);
			chart.series[2].setData(resp.apptemp);
			chart.series[3].setData(resp.wchill);
			chart.series[4].setData(resp.heatindex);
			chart.series[5].setData(resp.intemp);
		}
	});
};

var doPressure = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'line',
			alignTicks: false,
			zoomType: 'x'
		},
		title: {text: 'Barometric Pressure <span style="font-size: 12px;">(Units: ' + config.press.units + ')'},
		credits: { enabled: false }, 	// Set to TRUE for published charts
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%b %e' }
		},
		yAxis: [{	// Primary Axis
			title: {text: 'Pressure (' + config.press.units + ')'},
			opposite: false,
			showLastLabel: true,
			minRange: 30,
			labels: {
				align: 'right',
				x: -8,
				y: 5
			}
		}, {	// Secondary Axis
			linkedTo: 0,
			gridLineWidth: 0,
			showLastLabel: true,
			opposite: true,
			title: {text: null},
			labels: {
				align: 'left',
				x: 8,
				y: 5
			}
		}],
		legend: { enabled: true },
		plotOptions: {
			series: {
				dataGrouping: {
					enabled: false
				},
				states: {
					hover: {
						halo: { opacity: 0.25 }
					}
				},
				cursor: 'pointer',
				marker: {
					enabled: false,
					states: {
						hover: {
							enabled: true,
							radius: 0.1
						}
					}
				}
			},
			line: { lineWidth: 2 }
		},
		tooltip: {
			shared: true,
			//crosshairs: true,
			valueSuffix: config.press.units,
			valueDecimals: config.press.decimals,
			xDateFormat: "%A, %b %e, %H:%M",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Pressure'
		}],
		rangeSelector: {
			buttons: [{
				type: 'hour',
				count: 6,
				text: '6h'
			}, {
				type: 'hour',
				count: 12,
				text: '12h'
			}, {
				type: 'hour',
				count: 24,
				text: '24h'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/pressdata.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.press);
		}
	});
};

var doWind = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'line',
			alignTicks: false,
			zoomType: 'x'
		},
		title: {text: 'Wind Speed <span style="font-size: 12px;">(Units ' + config.wind.units + ')</span>'},
		credits: { enabled: false },
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%b %e' },
			plotBands: [ {
				from: Date.UTC(2016,11,10, 18, 20),
				to: Date.UTC(2016, 11, 11, 11, 15),
				color: 'rgba(128, 128, 128, 0.2)',
				zIndex: 2,
			//	label: { text: 'Wind sensor failure', verticalAlign: 'bottom', y: -10}
			}],
		},
		yAxis: [{		// Primary Axis
			title: {text: 'Wind Speed (' + config.wind.units + ')'},
			opposite: false,
			showLastLabel: true,
			min: 0,
			labels: {
				align: 'right',
				x: -8,
				y: 5,
				style: { color: '#604080' }
			}
		}, {		// Secondary Axis
			linkedTo: 0,
			gridLineWidth: 0,
			showLastLabel: true,
			opposite: true,
			min: 0,
			title: { text: null },
			labels: {
				align: 'left',
				x: 8,
				y: 5
			}
		}],
		legend: { enabled: true },
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: { opacity: 0.25 }
					}
				},
				cursor: 'pointer',
				marker: {
					enabled: false,
					states: {
						hover: {
							enabled: true,
							radius: 0.1
						}
					}
				}
			},
			line: { lineWidth: 1 }
		},
		tooltip: {
			shared: true,
			valueSuffix: config.wind.units,
			valueDecimals: config.wind.decimals,
			xDateFormat: "%A, %b %e, %H:%M",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Wind Speed',
			lineWidth: 2
		}, {
			name: 'Wind Gust'
		}],
		rangeSelector: {
			buttons: [{
				type: 'hour',
				count: 6,
				text: '6h'
			}, {
				type: 'hour',
				count: 12,
				text: '12h'
			}, {
				type: 'hour',
				count: 24,
				text: '24hr'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/winddata.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.wspeed);
			chart.series[1].setData(resp.wgust);
		}
	});
};

var doWindDir = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'scatter',
			alignTicks: false,
			zoomType: 'x'
		},
		title: {text: 'Wind Direction'},
		credits: {enabled: false},
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%b %e' },
			plotBands: [ {
				from: Date.UTC(2016,11,10, 18,20),
				to: Date.UTC(2016, 11, 11, 11, 15),
				color: 'rgba(128, 128, 128, 0.2)',
				zIndex: 2,
			//	label: { text: 'Wind sensor failure', verticalAlign: 'bottom', y: -10}
			}],
		},
		yAxis: [{		// Primary Axis
			title: {text: 'Bearing'},
			opposite: false,
			showLastLabel: true,
			min: 0,
			max: 360,
			tickInterval: 45,
			labels: {
				align: 'right',
				x: -8,
				y: 6,
				format: '{value}°'
			}
		}, {		// Secondary Axis
			linkedTo: 0,
			gridLineWidth: 0,
			showLastLabel: true,
			opposite: true,
			title: {text: null},
			min: 0,
			max: 360,
			tickInterval: 45,
			labels: {
				align: 'left',
				x: 8,
				y: 6,
				formatter: function () { return compassP(this.value); }
			}
		}],
		legend: { enabled: true },
		plotOptions: {
			scatter: {
				cursor: 'pointer',
				enableMouseTracking: true,
				marker: {
					states: {
						hover: { enabled: true },
						select: { enabled: false }
					}
				},
				shadow: false
			}
		},
		tooltip: {
			enabled: true,
			shared: false,
			headerFormat: '<span style="font-weight:700;font-size:120%;">{point.key}</span><br/>',
			xDateFormat: '%a, %b %e, %H:%M'
		},
		series: [{
			name: 'Bearing',
			marker: {
				symbol: 'diamond',
				radius: 2,
				keys: ['x', 'y'],
				tooltip: {
					pointFormatter: function() {
						return 'Bearing: <strong>{this.y}</strong>';
					}
				}
			}
		}, {
			name: 'Average Bearing',
			//color: 'red',
			marker: {
				symbol: 'circle',
				radius: 3
			}
		}],
		rangeSelector: {
			buttons: [{
				count: 6,
				type: 'hour',
				text: '6h'
			}, {
				count: 12,
				type: 'hour',
				text: '12h'
			}, {
				type: 'hour',
				count: 24,
				text: '24hr'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/wdirdata.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.bearing);
			chart.series[1].setData(resp.avgbearing);
		}
	});
};

var doHumidity = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'spline',
			alignTicks: false,
			zoomType: 'x'
		},
		title: {text: 'Relative Humidity'},
		credits: { enabled: false },
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%e %b' }
		},
		yAxis: [{		// Primary Axis
			title: {text: 'Humidity (%)'},
			opposite: false,
			min: 0,
			max: 100,
			showLastLabel: true,
			labels: {
				align: 'right',
				x: -8,
				y: 5,
				format: '{value}%',
				style: { color: '#000088' }
			},
			plotBands: [{
				from: 0,
				to: 30,
				color: 'rgba(255,255,128,0.2)',
				label: {
					align: 'left',
					x: 5,
					y: -5,
					verticalAlign: 'bottom',
					text: 'Very dry',
					style: { color: '#888844' }
				}
			}, {
				from: 30,
				to: 80,
				color: 'rgba(128, 255, 128, 0.2)',
				zIndex: 2,
				label: {
					align: 'left',
					x: 5,
					verticalAlign: 'bottom',
					y: -5,
					text: 'Comfort zone',
					style: { color: '#008800' }
				}
			}, {
				from: 80,
				to: 90,
				color: 'rgba(255,255,128,0.2)',
				zIndex: 2,
				label: {
					align: 'left',
					x: 5,
					verticalAlign: 'bottom',
					y: -5,
					text: 'Feeling Humid',
					style: { color: '#ff8800' }
				}
			}, {
				from: 90,
				to: 100,
				color: 'rgba(255,128,0, 0.2)',
				zIndex: 2,
				label: {
					align: 'left',
					x: 5,
					verticalAlign: 'bottom',
					y: -5,
					text: 'Rain / Muggy / Damp',
					style: { color: '#884400'}
				}
			}]
		}, {		// Seconday Axis
			linkedTo: 0,
			gridLineWidth: 0,
			opposite: true,
			showLastLabel: true,
			min: 0,
			max: 100,
			title: { text: null },
			labels: {
				align: 'left',
				x: 8,
				y: 5,
				format: '{value}%',
				style: { color: '#000088' }
			}
		}],
		legend: { enabled: true },
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: { opacity: 0.25 }
					}
				},
				cursor: 'pointer',
				marker: {
					enabled: false,
					states: {
						hover: {
							enabled: true,
							radius: 1
						}
					}
				}
			},
			spline: { lineWidth: 2 }
		},
		tooltip: {
			shared: true,
			valueSuffix: '%',
			valueDecimals: config.hum.decimals,
			xDateFormat: "%A, %b %e, %H:%M",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Outdoor Humidity',
			zIndex: 20
		}, {
			name: 'Indoor Humidity',
			visible: false
		}],
		rangeSelector: {
			buttons: [{
				type: 'hour',
				count: 6,
				text: '6h'
			}, {
				type: 'hour',
				count: 12,
				text: '12h'
			}, {
				type: 'hour',
				count: 24,
				text: '24hr'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/humdata.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.hum);
			chart.series[1].setData(resp.inhum);
		}
	});
};

var doRainfall = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'line',
			alignTicks: true
		},
		title: {text: 'Rainfall <span style="font-size: 12px;">(Units ' + config.rain.units + ')</span>' },
		credits: {enabled: false},
		xAxis: {
			type: 'datetime',
			ordinal: false ,
			dateTimeLabelFormats: { day: '%b %e' }
		},
		yAxis: [{		// Primary Axis
			title: {text: 'Rainfall rate (' + config.rain.units + '/hr)'},
			min: 0,
			opposite: false,
			showLastLabel: true,
			labels: {
				align: 'right',
				x: -8,
				y: 5,
				style: { color: 'rgb(32, 64, 255)' }
			}
		}, {		// Secondary Axis
			opposite: true,
			title: {text: 'Rainfall (' + config.rain.units + ')'},
			min: 0,
			showLastLabel: true,
			labels: {
				align: 'left',
				x: 8,
				y: 5,
				style: { color: 'rgb(32, 64, 255)'}
			}
		}],
		legend: { enabled: true },
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: {
							size: 5,
							opacity: 0.25
						}
					}
				},
				//cursor: 'pointer',
				marker: {
					enabled: false,
					states: {
						hover: {
							enabled: true,
							radius: 0.1
						}
					}
				}
			},
			area: {
				fillColor: {
					linearGradient: {x1:0, y1: 0, x2: 0, y2: 1},
					stops: [
						[0, 'rgba(10, 80, 255, 0.6)'],
						[1, 'rgba(10, 90, 80, 0.1)']
					]
				},
				states: {
					hover: { 
						enabled: true,
						halo: { size: 1 }
					}
				},
				color: 'rgb(10,80,288)',
				lineWidth: 1
			},
			line: { lineWidth: 2 }
		},
		tooltip: {
			shared: true,
			valueDecimals: config.rain.decimals,
			xDateFormat: "%A, %b %e, %H:%M",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Rain rate',
			//type: 'line',
			color: 'rgb(255, 64, 32)',
			yAxis: 0,
			tooltip: { valueSuffix: ' '+config.rain.units + '/hr'}
		}, {
			name: 'Daily rain',
			type: 'area',
			yAxis: 1,
			tooltip: { valueSuffix: ' '+config.rain.units }
		}],
		rangeSelector: {
			buttons: [{
				count: 6,
				type: 'hour',
				text: '6h'
			}, {
				count: 12,
				type: 'hour',
				text: '12h'
			}, {
				type: 'hour',
				count: 24,
				text: '24hr'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/raindata.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.rrate);
			chart.series[1].setData(resp.rfall);
		}
	});
};

var doSolar = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'line',
			alignTicks: true
		},
		title: { text: 'Solar' },
		credits: {enabled: false},
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%b %e' }
		},
		yAxis: [{		// Primary Axis
			title: {text: 'Solar Radiation (W/m\u00B2)'},
			min: 0,
			opposite: false,
			showLastLabel: true,
			labels: {
				align: 'right',
				x: -8,
				y: 5,
				style: { color: '#000088' }
			}
		}, {		// Secondary Axis
			opposite: true,
			title: {text: 'UV Index'},
			showLastLabel: true,
			min: 0,
			minRange: 4,
			labels: {
				align: 'left',
				x: 8,
				y: 5,
				style: { color: '#008800' }
			},
			plotBands: [{
				from: 0,
				to: 3,
				color: 'rgba(128, 255, 128, 0.2)',
				zIndex: 2,
				label: {
					align: 'left',
					x: 5,
					verticalAlign: 'top',
					y: 12,
					text: 'Safe Zone',
					style: { color: '#008800', fontStyle: 'italic'}
				}
			}, {
				from: 3,
				to: 5,
				color: 'rgba(255, 255, 0, 0.2)',
				zIndex: 2,
				label: {
					align: 'left',
					x: 5,
					verticalAlign: 'top',
					y: 12,
					text: 'Caution required',
					style: {color: '#ff8800', fontStyle: 'italic' }
				}
			}, {
				from: 5,
				to: 8,
				color: 'rgba(255,128,128,0.2)',
				zIndex: 2,
				label: {
					align: 'left',
					x: 5,
					y: 12,
					verticalAlign: 'top',
					text: 'Protection required',
					style: { color: '#884444', fontStyle: 'italic' }
				}
			} ]
		}],
		legend: {enabled: true},
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: { opacity: 0.25 }
					}
				},
				marker: {
					enabled: false,
					states: {
						hover: {
							enabled: true,
							radius: 0.1
						}
					}
				}
			},
			line: { lineWidth: 2 }
		},
		tooltip: {
			shared: true,
			xDateFormat: "%A, %b %e, %H:%M",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Solar Radiation',
			type: 'area',
			yAxis: 0,
			valueDecimals: 0,
			tooltip: {valueSuffix: 'W/m\u00B2'}
		}, {
			name: 'Theoretical Max',
			type: 'area',
			yAxis: 0,
			valueDecimals: 0,
			tooltip: {valueSuffix: 'W/m\u00B2'}
		}, {
			name: 'UV Index',
			type: 'line',
			yAxis: 1,
			valueDecimals: config.uv.decimals,
			tooltip: {valueSuffix: ''}
		}],
		rangeSelector: {
			buttons: [{
				type: 'hour',
				count: 6,
				text: '6h'
			}, {
				type: 'hour',
				count: 12,
				text: '12h'
			}, {
				type: 'hour',
				count: 24,
				text: '24hr'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/solardata.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.SolarRad);
			chart.series[1].setData(resp.CurrentSolarMax);
			chart.series[2].setData(resp.UV);
		}
	});
};

var doSunshine = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'column',
			alignTicks: false
		},
		title: {text: 'Sunshine Hours'},
		credits: {enabled: false},
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%b %e' }
		},
		yAxis: [{		// Primary Axis
			title: { text: 'Sunshine Hours' },
			min: 0,
			minValue: 6,
			opposite: false,
			labels: {
				align: 'right',
				x: -12,
				formatter: function () {
					return '<span style="fill: ' + (this.value <= 0 ? 'blue' : 'red') + ';">' + this.value + '</span>';
				}
			}
		}, {		// Secondary Axis
			linkedTo: 0,
			gridLineWidth: 0,
			opposite: true,
			min: 0,
			minValue: 6,
			title: {text: null},
			labels: {
				align: 'left',
				x: 12,
				formatter: function () {
					return '<span style="fill: ' + (this.value <= 0 ? 'blue' : 'red') + ';">' + this.value + '</span>';
				}
			}
		}],
		legend: {enabled: true},
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: { opacity: 0.25 }
					}
				},
				marker: {
					enabled: false,
					states: {
						hover: {
							enabled: true,
							radius: 0.1
						}
					}
				}
			}
		},
		tooltip: {
			shared: true,
			xDateFormat: "%A, %b %e",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Sunshine Hours',
			//type: 'column',
			color: 'gold',
			yAxis: 0,
			valueDecimals: 2,
			tooltip: {valueSuffix: ' Hrs'}
		}],
		rangeSelector:  {
			buttons: [{
				type: 'day',
				count: 7,
				text: '7d'
			}, {
				type: 'day',
				count: 14,
				text: '14d'
			}, {
				type: 'day',
				count: 28,
				text: '28d'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/sunhours.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.sunhours);
		}
	});
};

var doTempDaily = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'spline',
			alignTicks: false,
			ignoreHiddenSeries: false,
			zoomType: 'x'
		},
		title: {text: 'Daily Temperature'},
		credits: {enabled: false},
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%b %e', week: '%e %b %y' }
		},
		yAxis: [{		// Primary Axis
			title: {text: 'Temperature (°' + config.temp.units + ')'},
			opposite: false,
			showLastLabel: true,
			labels: {
				align: 'right',
				x: -8,
				y:  5,
				formatter: function () {
					if (this.value == freezing ) {
						return '<span style="color: #402020;">' + this.value + '°</span>' ;
					} else {
						return '<span style="fill: ' + (this.value < 0 ? 'blue' : 'red') + ';">' + this.value + '°</span>';
					}
				}
			},
			plotLines: [{		// freezing line
				value: freezing ,
				color: 'rgba(128, 0, 128, 0.4)',
				width: 1,
				zIndex: 2,
				label: {
					text: 'Freezing',
					x: 5,
					style: { color: '#880088', fontStyle: 'italic' }
				}
			}]
		}, {		// Secondary Axis
			linkedTo: 0,
			gridLineWidth: 0,
			showLastLabel: true,
			opposite: true,
			title: {text: null},
			labels: {
				align: 'left',
				x: 8,
				y: 5,
				formatter: function () {
					if (this.value == freezing ) {
						return '<span style="color: #402020;font-weight: bold;">' + this.value + '°</span>' ;
					} else {
					   	return '<span style="color: ' + (this.value < 0 ? 'blue' : 'red') + ';">' + this.value + '°</span>';
					}
				}
			}
		}],
		legend: { enabled: true },
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: { opacity: 0.25 }
					}, 
					marker: {
				//		enabled: false,
						states: {
							hover: { radius: 1 }
						}
					}
				} 
			},
			spline: {
				lineWidth: 1
			}
		},
		tooltip: {
			shared: true,
			valueSuffix: ' °' + config.temp.units,
			valueDecimals: config.temp.decimals,
			xDateFormat: "%A, %b %e",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		rangeSelector:  {
		//	selected: 2,
			buttons: [{
				type: 'day',
				count: 7,
				text: '7d'
			}, {
				type: 'day',
				count: 14,
				text: '14d'
			}, {
				type: 'day',
				count: 28,
				text: '28d'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		},
		series: [{
			name: 'Average Temp',
			color: 'green',
			lineWidth: 2
		}, {
			name: 'Minimum Temp',
			color: 'blue'
		}, {
			name: 'Maximum Temp',
			color: 'red'
		}]
	};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/dailytemp.json',
		dataType: 'json',
		cache: false,
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.avgtemp);
			chart.series[1].setData(resp.mintemp);
			chart.series[2].setData(resp.maxtemp);
		}
	});
};

var doRainDaily = function () {
	var options = {
		chart: {
			renderTo: 'chartcontainer',
			type: 'column',
			alignTicks: false
		},
		title: {text: 'Daily Rainfall <span style="font-size: 12px;">(Units: ' + config.rain.units + ')</span>'},
		credits: {enabled: false},
		xAxis: {
			type: 'datetime',
			ordinal: false,
			dateTimeLabelFormats: { day: '%b %e', week: '%e %b %y' }
		},
		yAxis: [{		// Primary Axis
			title: {text: 'Daily Rainfall'},
			min: 0,
			opposite: false,
			showLastLabel: true,
			labels: {
				align: 'right',
				x: -8,
				y: 5,
				style: { color: '#000088' }
			}
		}, {		// Secondary Axis
			linkedTo: 0,
			gridLineWidth: 0,
			showLastLabel: true,
			opposite: true,	// Place on right
			title: {text: null},
			labels: {
				align: 'left',
				x: 8,
				y: 5,
				style: { color: '#000088' }
			}
		}],
		legend: {enabled: true},
		plotOptions: {
			series: {
				dataGrouping: { enabled: false },
				states: {
					hover: {
						halo: {
							size: 1,
							opacity: 0.25
						}
					}
				},
				marker: {
					enabled: false,
					states: {
						hover: {
							enabled: true,
							radius: 0.1
						}
					}
				}
			},
			column: {
				color: {
					linearGradient: {x1:0, y1: 0, x2: 0, y2: 1},
					stops: [
						[0, 'rgba(10, 80, 255, 0.6)'],
						[1, 'rgba(10, 90, 80, 0.1)']
					]
				},
				borderColor: 'rgb(10,80,255)',
				shadow: true,
				lineWidth: 1
			}
		},
		tooltip: {
			shared: true,
			xDateFormat: "%A, %b %e",
			useHTML: true,
			headerFormat: '<span style="font-size: 14px; font-weight:bold;">{point.key}</span><table width="100%">',
			pointFormat:  '<tr><td><span style="color:{series.color}">●</span> {series.name}</td><td style="text-align:right;"><strong>{point.y}</strong></td></tr>',
			footerFormat: '</table>'
		},
		series: [{
			name: 'Daily Rainfall',
			yAxis: 0,
			valueDecimals: config.rain.decimals,
			tooltip: { valueSuffix: ' ' + config.rain.units}
		}],
		rangeSelector:  {
			buttons: [{
				type: 'day',
				count: 7,
				text: '7d'
			}, {
				type: 'day',
				count: 14,
				text: '14d'
			}, {
				type: 'day',
				count: 28,
				text: '28d'
			}, {
				type: 'all',
				text: 'All'
			}],
			inputEnabled: false
		}
};

	chart = new Highcharts.StockChart(options);
	chart.showLoading();

	$.ajax({
		url: 'api/graphdata/dailyrain.json',
		dataType: 'json',
		success: function (resp) {
			chart.hideLoading();
			chart.series[0].setData(resp.dailyrain);
		}
	});
};
