/*	--------------------------------------------------
 *	Script:	dayfileeditor.js
 *	Author:	Mark Crossley (modified by Neil Thomas)
 *	Last Edit:	11th Jan 2022
 * -------------------------------------------------
 * Changelog (NT)
 * 	Removed api call for version data - now in Page-Manager.js
 * 	Altered all API calls to use host root
 * 	Added 'className's to table data to display units.
 * ----------------------------------------------------------------------------*/

$(document).ready(function() {

    var columnDefs = [
    {
        title: "Line No.",
        readonly: true
    },
    {
        title: "Date (dd/mm/yy)",
        readonly: true
    },
    {title: "Max gust", className:"windUnits"},
    {title: "Max gust bearing", className:"degrees"},
    {title: "Max gust time"},
    {title: "Min temp", className:"tempUnits"},
    {title: "Min temp time"},
    {title: "Max temp", className:"tempUnits"},
    {title: "Max temp time"},
    {title: "Min pressure", className:"pressUnits"},
    {title: "Min pressure time"},
    {title: "Max pressure", className:"pressUnits"},
    {title: "Max pressure time"},
    {title: "Max rainfall rate", className:"rainRateUnits"},
    {title: "Max rainfall rate time"},
    {title: "Total rainfall", className:"rainUnits"},
    {title: "Avg temp", className:"tempUnits"},
    {title: "Total wind run", className:"windRunUnits"},
    {title: "High avg wind speed", className:"windUnits"},
    {title: "High avg wind speed time"},
    {title: "Low humidity", className:"percent"},
    {title: "Low humidity time"},
    {title: "High humidity", className:"percent"},
    {title: "High humidity time"},
    {title: "Total ET"},
    {title: "Total hours of sunshine", className:"hours"},
    {title: "High heat index", className:"tempUnits"},
    {title: "High heat index time"},
    {title: "High apparent temp", className:"tempUnits"},
    {title: "High apparent temp time"},
    {title: "Low apparent temp", className:"tempUnits"},
    {title: "Low apparent temp time"},
    {title: "High hourly rain", className:"rainRateUnits"},
    {title: "High hourly rain time"},
    {title: "Low wind chill", className:"tempUnits"},
    {title: "Low wind chill time"},
    {title: "High dew point", className:"tempUnits"},
    {title: "High dew point time"},
    {title: "Low dew point", className:"tempUnits"},
    {title: "Low dew point time"},
    {title: "Dominant wind bearing", className:"degrees"},
    {title: "Heating degree days"},
    {title: "Cooling degree days"},
    {title: "High solar rad", className:"solarUnits"},
    {title: "High solar rad time"},
    {title: "High UV-I"},
    {title: "High UV-I time"},
    {title: "High feels like", className:"tempUnits"},
    {title: "High feels like time"},
    {title: "Low feels like", className:"tempUnits"},
    {title: "Low feels like time"},
    {title: "High humidex", className:"tempUnits"},
    {title: "High humidex time"},
    {title: "Chill hours", className:"hours"}
    ];

    var myTable = $('#dayfile').DataTable({
        pagingType: "input",
        processing: true,
        serverSide: true,
        searching: false,
        ordering: false,
        pageLength: 10,
        lengthMenu: [10,20,50,100],
        ajax: {
            url: "/api/data/dayfile",
            data: function (data) {
                delete data.columns;
            }
        },
        columns: columnDefs,
        dom: '<"top"Bfrtip<"clear">>rt<"bottom"frtip<"clear">>',
        select: 'single',
        responsive: false,
        altEditor: true,     // Enable altEditor
        buttons: [
            {
                extend: 'selected', // Bind to Selected row
                text: 'Edit',
                name: 'edit'        // do not change name
            },
            {
                extend: 'selected', // Bind to Selected row
                text: 'Delete',
                name: 'delete'      // do not change name
            },
            {
                text: 'Refresh',
                name: 'refresh'      // do not change name
            },
            'pageLength'
        ],
        language: {
            altEditor: {
                modalClose: 'Close',
                edit: {
                    title: 'Edit record',
                    button: 'Save'
                }
            }
        },
        onEditRow: function(datatable, rowdata, success, error) {
            $.ajax({
                url: "/api/edit/dayfile",
                type: 'POST',
                data: formatResponse("Edit", rowdata),
                success: success,
                error: error
            });
        },
        onDeleteRow: function(datatable, rowdata, success, error) {
            $.ajax({
                url: "/api/edit/dayfile",
                type: 'POST',
                data: formatResponse("Delete", rowdata),
                success: success,
                error: error
            });
        }

    });

    function formatResponse(action, rowdata) {
        response = '{"action":"' + action + '","line":' + rowdata[0] + ',"data": [';
        for (var key in rowdata) {
            if (!isNaN(key) && key > 0) {
                response += '"' + rowdata[key] + '",';
            }
        }
        // remove trailing comma
        response = response.slice(0, -1);
        response += ']}';
        return response;
    }
});

$(document).ready( function() {
	$(".dt-buttons").children().addClass("ai-thin w3-btn w3-theme-l3 w3-theme-hvr");
    $(".dt-buttons").children().removeClass("dt-button");

});
