<?php
error_reporting(0); 
// Speed
function ktsTokmh(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(1.852*$weather[$field],1);
}

function ktsTomph(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(1.150779*$weather[$field],1);
}

function ktsToms(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(0.514444*$weather[$field],2);
}

function mphTokmh(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(1.609344*$weather[$field],1);
}

function mphTokts(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(0.868976*$weather[$field],1);
}

function mphToms(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(0.44704*$weather[$field],1);
}

function kmhTokts(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(0.5399568*$weather[$field],1);
}

function kmhTomph(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(0.621371*$weather[$field],1);
}

function kmhToms(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(0.2777778*$weather[$field],1);
}

function msTokmh(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(3.6*$weather[$field],1);
}

function msTokts(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = round((float)(1.943844*$weather[$field]), 1);
}

function msTomph(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(2.236936*$weather[$field], 1);
}

// Temperature
function cToF(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = cToFDirect($weather[$field]);
}

function fToC(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = fToCDirect($weather[$field]);
}

function cToFrel(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = round((float)(1.8*$weather[$field]), 1);
}

function fToCrel(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = round((float)(0.55555556*($weather[$field])), 1);
}

function fToCDirect($field){
	return round((float)(0.55555556*($field - 32)), 1);
}

function cToFDirect($field){
	return  number_format((float)$field*1.8 +32,1);
}

// Pressure
function mbToin(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = round((float)(0.02952999*$weather[$field]), 2);
}

function inTomb(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = round((float)(33.86388158*$weather[$field]), 2);
}

// Depth
function mmToin(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] = number_format(0.03937008*$weather[$field], 2);
}

function inTomm(&$weather, $field){
	if(!isset($weather[$field])) return;
	$weather[$field] =number_format(25.4*$weather[$field], 1);
}

// Calculates "real feel" heat index valid only at lower temperatures (up to 79 F)
function heatIndexLow($t, $rh) {
	// Assumes Fahrenheit
	return 0.5 * ($t + 61.0 + (($t - 68.0) * 1.2) + ($rh * 0.094));
}

// Calculates "real feel" heat index valid only at higher temperatures (beginning around 79-80 F), the traditional heat index formula
function heatIndexHigh($t, $rh) {
	// Assumes Fahrenheit
	$heatIndex = -42.379 + 2.04901523 * $t + 10.1433127*$rh - .22475441*$t*$rh - .00683783 *$t * $t - .05481717 * $rh * $rh + .00122874*$t*$t*$rh + .00085282 *$t * $rh *$rh - .00000199 *$t *$t *$rh * $rh;

	// Adjustment formula, adding or subtracting as much as a couple degrees at extreme ends of temperature/humidity ranges
	$a = 0;
	if ($rh < 13 && ($t >= 80 && $t <= 112)) {
		$a=((13 - $rh ) / 4) * sqrt((17-abs($t - 95))/17);
		$a = -$a;
	};
	if ($rh > 85 && ($t >= 80 && $t <= 87)) {
		$a=(($rh - 85)/10) * ((87 - $t) / 5);
	};

	$heatIndex += $a;
	return $heatIndex;
}

// Ruthfusz heat index formula
// http://www.wpc.ncep.noaa.gov/html/heatindex_equation.shtml
function heatIndex($temp, $rh) {
	global $weather;
	$t = anyToF($temp);

	// First try simple formula, valid when calculated heat index <= 79 degrees F
	$heatIndex = heatIndexLow($t, $rh);

	// If too warm, do the complicated formula instead
	if ($heatIndex >= 79)
	{
		$heatIndex = heatIndexHigh($t, $rh);
	}

	if ($weather["temp_units"] == 'C'){
		$heatIndex = fToCDirect($heatIndex);
	}

	return round($heatIndex, 1);
}

function getUpdatedString($datetime) {
	global $showDate, $dateFormat, $timeFormat;
	
	if ($showDate) {
		return '<div class="updatedtime"><span>' . date($dateFormat) . '</span><br />' . date($timeFormat) . '</div>';
	}
	else {
		return '<div class="updatedtime"><span>Updated</span><br />' . date($timeFormat) . '</div>';
	}
}

function anyToC($field){
	global $weather;
	if ($weather["temp_units"] == 'C'){
		return $field;
	} else {
		return fToCDirect($field);
	}
}

function anyToF($field){
	global $weather;
	if ($weather["temp_units"] == 'F'){
		return $field;
	} else {
		return cToFDirect ($field);
	}
}

function distance($lat, $lon, $lati, $longi) {
	$lat1 = deg2rad($lati);
	$lat2 = deg2rad($lat);
	$long1 = deg2rad($longi);
	$long2 = deg2rad($lon);

	// Great circle calculation uses the radius of earth, 6371 km
	return 6371 * acos(sin($lat1)*sin($lat2) + cos($lat1)*cos($lat2)*cos($long2-$long1));
}

?>
<?php 
$arrow34iconmenu ='<svg x="0px" y="0px" width=24 height=24 fill=#ccc stroke=#ccc viewBox="0 0 1000 1000" enable-background="new 0 0 1000 1000" >
<g><path d="M500,10C229.4,10,10,229.4,10,500c0,270.6,219.4,490,490,490c270.6,0,490-219.4,490-490C990,229.4,770.6,10,500,10z M500,967.9C241.6,967.9,32.1,758.4,32.1,500C32.1,241.6,241.6,32.1,500,32.1c258.4,0,467.9,209.5,467.9,467.9C967.9,758.4,758.4,967.9,500,967.9z M634.6,501.4l-247,248.3L371,733l230.3-231.6L371,269.8l16.6-16.7L634.6,501.4L634.6,501.4z"/></g></svg>'; 
$meteorsvg="<svg id ='meteor34' width='25px' height='25px' viewBox='0 0 16 16'><path fill='currentcolor' d='M0 0l14.527 13.615s.274.382-.081.764c-.355.382-.82.055-.82.055L0 0zm4.315 1.364l11.277 10.368s.274.382-.081.764c-.355.382-.82.055-.82.055L4.315 1.364zm-3.032 2.92l11.278 10.368s.273.382-.082.764c-.355.382-.819.054-.819.054L1.283 4.284zm6.679-1.747l7.88 7.244s.19.267-.058.534-.572.038-.572.038l-7.25-7.816zm-5.68 5.13l7.88 7.244s.19.266-.058.533-.572.038-.572.038l-7.25-7.815zm9.406-3.438l3.597 3.285s.094.125-.029.25c-.122.125-.283.018-.283.018L11.688 4.23zm-7.592 7.04l3.597 3.285s.095.125-.028.25-.283.018-.283.018l-3.286-3.553z'/></svg>";$solareclipsesvg="<svg id ='solareclipse34' width='25px' height='25px' viewBox='0 0 82 78' ><g id='#eclipse'>
<path fill='currentcolor' opacity='1.00' d=' M 29.26 10.19 C 37.83 5.85 48.47 6.32 56.69 11.26 C 58.93 12.97 61.81 11.64 64.28 12.58 C 67.57 14.39 69.31 18.62 67.47 22.06 C 70.04 28.07 71.79 34.76 70.27 41.29 C 68.27 52.98 58.27 62.69 46.54 64.42 C 32.33 67.07 17.30 57.08 14.11 43.01 C 10.56 30.28 17.40 15.85 29.26 10.19 M 36.49 10.35 C 27.61 12.14 20.18 18.95 17.14 27.43 L 16.87 27.40 C 15.43 33.06 15.48 38.89 16.86 44.56 L 17.15 44.60 C 19.85 52.10 25.92 58.17 33.42 60.86 L 33.42 61.08 C 35.21 61.37 36.98 61.73 38.71 62.23 C 42.73 62.58 46.67 61.83 50.60 61.14 L 50.58 60.86 C 57.47 58.34 63.32 53.03 66.17 46.24 C 68.90 40.29 68.61 33.65 67.14 27.42 L 66.88 27.50 C 66.57 23.46 62.05 25.72 59.45 25.31 C 57.88 23.74 56.31 22.18 54.75 20.61 C 54.74 19.26 54.73 17.91 54.73 16.56 C 55.16 16.05 56.01 15.04 56.43 14.53 C 54.73 13.01 52.70 11.94 50.58 11.14 L 50.57 10.86 C 45.94 10.09 41.13 8.93 36.49 10.35 Z' /></g></svg> ";
$weatherunitcmenu='<svg id ="weather34 menu celsius" width="24" height="24" fill="#ff8841" viewBox="0 0 24 24"><path d="M7 8c0 .551-.449 1-1 1-.551 0-1-.449-1-1s.449-1 1-1c.551 0 1 .449 1 1zm17 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-16-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm2.901 4.393v-.882c.011-1.208.215-2.1.614-2.675.398-.575.999-.862 1.801-.862.738 0 1.288.17 1.648.509.361.34.571.886.63 1.64h2.406c-.128-1.305-.604-2.318-1.428-3.04s-1.909-1.083-3.257-1.083c-.973 0-1.828.229-2.563.686s-1.3 1.114-1.696 1.969c-.396.856-.593 1.845-.593 2.968v.714c0 1.76.429 3.143 1.287 4.151.858 1.008 2.036 1.512 3.533 1.512 1.369 0 2.472-.361 3.309-1.083.837-.722 1.301-1.711 1.392-2.968h-2.406c-.054.711-.263 1.237-.63 1.576s-.921.509-1.665.509c-.823 0-1.427-.292-1.809-.874-.382-.582-.573-1.505-.573-2.767z"/></svg>';
$weatherunitc='<svg id ="weather34 celsius" width="12" height="12" fill="currentcolor" viewBox="0 0 24 24"><path d="M7 8c0 .551-.449 1-1 1-.551 0-1-.449-1-1s.449-1 1-1c.551 0 1 .449 1 1zm17 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-16-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm2.901 4.393v-.882c.011-1.208.215-2.1.614-2.675.398-.575.999-.862 1.801-.862.738 0 1.288.17 1.648.509.361.34.571.886.63 1.64h2.406c-.128-1.305-.604-2.318-1.428-3.04s-1.909-1.083-3.257-1.083c-.973 0-1.828.229-2.563.686s-1.3 1.114-1.696 1.969c-.396.856-.593 1.845-.593 2.968v.714c0 1.76.429 3.143 1.287 4.151.858 1.008 2.036 1.512 3.533 1.512 1.369 0 2.472-.361 3.309-1.083.837-.722 1.301-1.711 1.392-2.968h-2.406c-.054.711-.263 1.237-.63 1.576s-.921.509-1.665.509c-.823 0-1.427-.292-1.809-.874-.382-.582-.573-1.505-.573-2.767z"/></svg>';
$weatherunitcm='<svg id ="weather34 celsius menu" width="14" height="14" fill="#9aba2f" viewBox="0 0 24 24"><path d="M7 8c0 .551-.449 1-1 1-.551 0-1-.449-1-1s.449-1 1-1c.551 0 1 .449 1 1zm17 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-16-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm2.901 4.393v-.882c.011-1.208.215-2.1.614-2.675.398-.575.999-.862 1.801-.862.738 0 1.288.17 1.648.509.361.34.571.886.63 1.64h2.406c-.128-1.305-.604-2.318-1.428-3.04s-1.909-1.083-3.257-1.083c-.973 0-1.828.229-2.563.686s-1.3 1.114-1.696 1.969c-.396.856-.593 1.845-.593 2.968v.714c0 1.76.429 3.143 1.287 4.151.858 1.008 2.036 1.512 3.533 1.512 1.369 0 2.472-.361 3.309-1.083.837-.722 1.301-1.711 1.392-2.968h-2.406c-.054.711-.263 1.237-.63 1.576s-.921.509-1.665.509c-.823 0-1.427-.292-1.809-.874-.382-.582-.573-1.505-.573-2.767z"/></svg>';
$weatherunitfm='<svg id ="weather34 fahrenheit menu" width="14" height="14" fill="#ff8841" viewBox="0 0 24 24"><path d="M8 8c0 .551-.449 1-1 1s-1-.449-1-1 .449-1 1-1 1 .449 1 1zm16 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-15-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm8.352-2h-7.352v12h2.472v-4.904h4.385v-1.995h-4.385v-3.098h4.879v-2.003z"/></svg>';
$weatherunitcsmall=$weatherunitc;
$weatherunitfmenu='<svg id ="weather34 menu fahrenheit" width="24" height="24" fill="#ff8841" viewBox="0 0 24 24"><path d="M8 8c0 .551-.449 1-1 1s-1-.449-1-1 .449-1 1-1 1 .449 1 1zm16 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-15-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm8.352-2h-7.352v12h2.472v-4.904h4.385v-1.995h-4.385v-3.098h4.879v-2.003z"/></svg>';
$weatherunitf='<svg id ="weather34 fahrenheit" width="12" height="12" fill="currentcolor" viewBox="0 0 24 24"><path d="M8 8c0 .551-.449 1-1 1s-1-.449-1-1 .449-1 1-1 1 .449 1 1zm16 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-15-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm8.352-2h-7.352v12h2.472v-4.904h4.385v-1.995h-4.385v-3.098h4.879v-2.003z"/></svg>';
$weatherunitft='<svg id ="weather34 fahrenheit temperature" width="9" height="9" fill="#fff" viewBox="0 0 24 24"><path d="M8 8c0 .551-.449 1-1 1s-1-.449-1-1 .449-1 1-1 1 .449 1 1zm16 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-15-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm8.352-2h-7.352v12h2.472v-4.904h4.385v-1.995h-4.385v-3.098h4.879v-2.003z"/></svg>';
$weatherunitct='<svg id ="weather34 celsius temperature" width="9" height="9" fill="#fff" viewBox="0 0 24 24"><path d="M7 8c0 .551-.449 1-1 1-.551 0-1-.449-1-1s.449-1 1-1c.551 0 1 .449 1 1zm17 4c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-16-4c0-1.105-.895-2-2-2s-2 .895-2 2 .895 2 2 2 2-.895 2-2zm2.901 4.393v-.882c.011-1.208.215-2.1.614-2.675.398-.575.999-.862 1.801-.862.738 0 1.288.17 1.648.509.361.34.571.886.63 1.64h2.406c-.128-1.305-.604-2.318-1.428-3.04s-1.909-1.083-3.257-1.083c-.973 0-1.828.229-2.563.686s-1.3 1.114-1.696 1.969c-.396.856-.593 1.845-.593 2.968v.714c0 1.76.429 3.143 1.287 4.151.858 1.008 2.036 1.512 3.533 1.512 1.369 0 2.472-.361 3.309-1.083.837-.722 1.301-1.711 1.392-2.968h-2.406c-.054.711-.263 1.237-.63 1.576s-.921.509-1.665.509c-.823 0-1.427-.292-1.809-.874-.382-.582-.573-1.505-.573-2.767z"/></svg>';
$weatherunitfsmall=$weatherunitf;
$alert="<svg id='firealert' viewBox='0 0 32 32' width='11px' height='11px' fill='none' stroke='currentcolor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2'>
<path d='M16 3 L30 29 2 29 Z M16 11 L16 19 M16 23 L16 25' /></svg>";$lightningalert="<svg width='12' height='12' viewBox='0 0 32 32' fill=currentcolor stroke=currentcolor stroke-linecap=round stroke-linejoin=round stroke-width=1%>
<g id='#lightningalerttoday '>
<path d=' M 14.12 0.00 L 17.87 0.00 C 25.12 0.88 31.14 6.91 32.00 14.16 L 32.00 17.89 C 31.10 25.12 25.11 31.11 17.88 32.00 L 14.11 32.00 C 6.88 31.11 0.88 25.12 0.00 17.88 L 0.00 14.13 C 0.88 6.89 6.88 0.88 14.12 0.00 M 5.70 6.74 C 0.11 12.45 1.28 22.70 7.82 27.20 C 14.53 32.55 25.44 29.50 28.68 21.64 C 32.41 14.12 27.44 4.47 19.44 2.49 C 18.28 5.69 17.08 8.88 15.97 12.09 C 18.99 12.02 22.02 12.13 25.05 12.17 C 20.55 17.85 16.00 23.50 11.22 28.95 C 12.41 25.25 13.78 21.62 15.05 17.96 C 12.03 18.02 9.02 17.92 6.00 17.89 C 10.07 12.51 14.57 7.49 18.70 2.15 C 13.96 1.61 8.86 3.02 5.70 6.74 M 9.91 15.91 C 12.48 15.89 15.06 15.91 17.64 15.91 C 17.05 17.54 16.49 19.17 15.92 20.81 C 17.68 18.62 19.41 16.40 21.07 14.13 C 18.46 14.15 15.86 14.14 13.26 14.14 C 13.91 12.52 14.56 10.90 15.20 9.28 C 13.36 11.43 11.58 13.63 9.91 15.91 Z' />
</g></svg></svglightning>";
$lightningalert3="<svg x='0px' y='0px' width='32' height='32' viewBox='0 0 1000 1000' enable-background='new 0 0 1000 1000' fill=currentcolor >
<g><path d='M500,10C229.4,10,10,229.4,10,500s219.4,490,490,490c270.6,0,490-219.4,490-490S770.6,10,500,10z M500,984.7c-267.7,0-484.7-217-484.7-484.7S232.3,15.3,500,15.3s484.7,217,484.7,484.7C984.7,767.7,767.7,984.7,500,984.7z'/><path d='M671.6,441.5c-22.8,31.9-45.9,63.6-68.5,95.6c-73.3,103.8-146.6,207.7-219.8,311.5c-1,1.4-2.1,2.7-4.4,3.3c13.5-35.1,27-70.3,40.5-105.4c23.4-60.6,46.8-121.2,70.1-181.9c5.7-14.8,3.3-18.3-12.7-18.3c-45-0.2-90-0.2-135.1-0.4c-4,0-8-0.7-15.3-1.5C440.9,411,553.2,279.9,665.6,148.8c0.6,0.3,1.1,0.6,1.7,0.8c-1.5,3.2-2.8,6.5-4.4,9.7c-40.7,84.3-81.3,168.7-122,253c-1.2,2.5-2.6,5.1-3.7,7.6c-5.1,11.4-2.9,15,9.4,15.1c24.5,0.1,48.9,0,73.4,0c13.1,0,26.2-0.2,39.4,0.1c4.1,0.1,8.2,1.3,12.3,2C671.6,438.7,671.6,440.1,671.6,441.5z'/></g></svg>";
$rainfallalert="<svg width='25px' height='25px' viewBox='0 0 284 266' >
<g id='#d65b4aff'>
<path fill='#d97365' opacity='1.00' d=' M 136.60 6.74 C 140.30 5.37 144.57 5.99 147.88 8.09 C 151.41 10.25 153.65 13.85 155.61 17.39 C 194.56 89.39 233.54 161.39 272.48 233.41 C 275.48 238.80 277.75 245.76 274.48 251.55 C 271.20 257.23 264.10 258.71 258.03 258.67 C 179.99 258.70 101.96 258.69 23.92 258.68 C 17.79 258.73 10.60 257.33 7.25 251.60 C 3.89 245.77 6.23 238.76 9.26 233.32 C 48.22 161.28 87.19 89.25 126.17 17.22 C 128.52 12.84 131.75 8.51 136.60 6.74 M 139.55 26.60 C 137.69 27.84 136.99 30.11 135.88 31.95 C 98.83 100.51 61.73 169.04 24.66 237.59 C 24.22 238.86 22.77 240.59 24.05 241.81 C 25.95 243.47 28.73 242.81 31.04 243.02 C 104.71 242.98 178.38 243.02 252.05 243.01 C 253.91 242.88 256.19 243.14 257.54 241.55 C 258.20 240.12 257.06 238.66 256.54 237.37 C 219.06 167.90 181.63 98.39 144.14 28.92 C 143.44 27.23 141.34 25.55 139.55 26.60 Z' /></g>
<g id='#01a4b4ff'>
<path fill='#01a4b4' opacity='1.00' d=' M 54.80 201.13 C 57.12 196.75 59.52 192.41 61.85 188.03 C 66.53 193.43 72.61 198.90 80.13 199.17 C 88.53 199.31 94.69 192.11 102.82 191.29 C 106.47 192.01 109.04 195.05 112.39 196.51 C 119.17 200.46 128.11 199.96 134.55 195.55 C 137.50 193.85 140.17 190.94 143.84 191.17 C 148.10 191.22 150.97 194.80 154.61 196.45 C 161.32 200.47 170.24 199.97 176.69 195.67 C 180.09 193.63 183.48 190.12 187.85 191.38 C 193.26 192.98 197.16 197.91 202.91 198.76 C 209.85 200.38 217.20 197.61 221.88 192.36 C 223.66 195.67 225.45 198.98 227.22 202.29 C 222.46 206.34 217.36 210.69 211.12 212.10 C 204.89 212.82 200.83 207.19 195.44 205.24 C 187.97 201.68 178.95 203.52 172.61 208.56 C 168.56 212.00 162.32 213.73 157.65 210.45 C 152.44 206.88 146.75 202.97 140.11 203.39 C 134.28 203.26 129.10 206.25 124.56 209.58 C 120.91 212.41 115.49 213.23 111.49 210.65 C 106.55 207.81 101.95 203.61 95.92 203.55 C 86.44 202.96 79.16 210.12 70.41 212.33 C 64.51 209.72 59.44 205.54 54.80 201.13 Z' />
<path fill='#01a4b4' opacity='1.00' d=' M 49.31 211.15 C 55.32 215.82 61.19 221.63 68.94 223.09 C 78.64 224.13 85.73 215.51 95.01 214.56 C 99.53 214.89 102.55 218.77 106.55 220.47 C 114.24 224.98 124.32 223.68 131.25 218.32 C 134.94 215.36 140.00 213.00 144.65 215.24 C 148.93 217.55 152.66 220.90 157.39 222.34 C 163.48 224.12 170.35 223.16 175.68 219.68 C 179.25 217.62 182.48 214.23 186.92 214.41 C 194.21 214.78 198.81 221.95 206.00 222.83 C 216.13 224.77 225.21 218.26 232.65 212.24 C 236.42 219.49 240.40 226.63 244.24 233.85 C 175.18 233.85 106.13 233.86 37.08 233.85 C 41.15 226.27 45.31 218.75 49.31 211.15 Z' />
</g></svg>";$windalert=" <svg width='25px' height='25px' viewBox='0 0 878 488' >
<g id='windalert'></g>
<g id='windalert'>
<path fill='currentcolor' opacity='1.00' d=' M 800.35 34.16 C 820.26 54.11 840.39 73.84 859.75 94.33 C 863.20 98.20 866.80 102.02 869.45 106.51 C 871.72 110.59 871.46 115.93 868.83 119.78 C 864.90 125.70 859.81 130.72 854.96 135.87 C 836.85 154.20 818.56 172.37 800.36 190.61 C 791.98 182.25 783.62 173.87 775.38 165.38 C 783.55 157.23 791.98 149.34 799.79 140.85 C 802.08 138.07 804.83 135.39 805.77 131.79 C 793.19 130.88 780.55 131.16 767.95 130.91 C 656.65 129.87 545.34 130.34 434.03 130.07 C 402.24 130.01 370.45 130.16 338.67 129.79 C 338.62 118.19 338.66 106.60 338.65 95.00 C 495.45 94.99 652.26 95.01 809.06 94.99 C 797.48 83.41 785.89 71.82 774.31 60.24 C 782.98 51.53 791.70 42.88 800.35 34.16 Z' />
<path fill='currentcolor' opacity='1.00' d=' M 626.76 208.00 C 634.96 199.91 642.57 191.08 651.72 184.04 C 665.09 196.41 677.93 209.34 690.75 222.28 C 699.70 231.57 709.06 240.51 717.36 250.41 C 719.81 253.58 722.75 256.84 723.24 260.98 C 722.99 265.67 719.45 269.26 716.74 272.79 C 706.43 284.73 695.02 295.65 684.04 306.97 C 673.63 317.43 663.22 327.89 652.84 338.38 C 644.44 330.13 636.04 321.87 627.65 313.61 C 638.78 302.19 650.06 290.93 661.34 279.66 C 503.79 279.67 346.25 279.67 188.70 279.66 C 188.70 267.35 188.69 255.05 188.70 242.74 C 346.22 242.73 503.75 242.74 661.27 242.73 C 649.73 231.20 638.19 219.65 626.76 208.00 Z' />
<path fill='currentcolor' opacity='1.00' d=' M 485.31 331.84 C 505.36 352.07 525.77 371.94 545.41 392.56 C 549.29 397.26 554.42 401.64 555.76 407.84 C 557.00 414.63 551.80 419.99 547.77 424.73 C 537.19 436.46 525.74 447.37 514.76 458.70 C 505.28 468.16 496.07 477.88 486.44 487.17 C 477.85 478.44 468.97 469.99 460.31 461.33 C 471.49 450.00 482.68 438.68 493.98 427.46 C 337.17 427.48 180.37 427.46 23.56 427.46 C 23.56 415.15 23.56 402.84 23.56 390.54 C 180.38 390.53 337.19 390.53 494.01 390.53 C 482.73 379.28 471.48 368.01 460.32 356.63 C 468.68 348.39 477.03 340.15 485.31 331.84 Z' />
</g></svg>";$lightningstike="<svg id='i-lightning' viewBox='0 0 32 32' width='10' height='10' fill='#ccc' stroke='#ff8841' stroke-linecap='round' stroke-linejoin='round' stroke-width='2'>
    <path d='M18 13 L26 2 8 13 14 19 6 30 24 19 Z' /></svg>";
	$lightningstike2="<svg id='i-lightning' viewBox='0 0 32 32' width='15' height='15' fill='none' stroke='currentcolor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2'>
    <path d='M18 13 L26 2 8 13 14 19 6 30 24 19 Z' /></svg>";
	$info='<svg id=i-info viewBox="0 0 32 32" width=10 height=10 fill=none stroke=currentcolor stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 /></svg> ';
	$info3='<svg id=i-info viewBox="0 0 32 32" width="12px" height="12px" fill=none stroke=currentcolor stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 /></svg> ';
	$info2='<svg id=i-info1 viewBox="0 0 32 32" width=14 height=14 fill=none stroke=currentcolor stroke-linecap=round stroke-linejoin=round><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 /></svg> ';
	$menuinfo='<svg id=i-info1 viewBox="0 0 32 32" width=26 height=26 fill=none stroke=#aaa stroke-linecap=round stroke-linejoin=round stroke-width=4%><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 /></svg> ';
	$chartinfo='<svg viewBox="0 0 32 32" width=10 height=10 fill=none stroke=currentcolor stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M14 9 L3 9 3 29 23 29 23 18 M18 4 L28 4 28 14 M28 4 L14 18" /></svg>';$earthquakeinfo='<svg id=i-activity viewBox="0 0 32 32" width=10 height=10 fill=none stroke=currentcolor stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M4 16 L11 16 14 29 18 3 21 16 28 16" />
</svg>';$meteorinfo="<svg width='12px' height='12px' viewBox='0 0 16 16'><path fill='currentcolor' d='M0 0l14.527 13.615s.274.382-.081.764c-.355.382-.82.055-.82.055L0 0zm4.315 1.364l11.277 10.368s.274.382-.081.764c-.355.382-.82.055-.82.055L4.315 1.364zm-3.032 2.92l11.278 10.368s.273.382-.082.764c-.355.382-.819.054-.819.054L1.283 4.284zm6.679-1.747l7.88 7.244s.19.267-.058.534-.572.038-.572.038l-7.25-7.816zm-5.68 5.13l7.88 7.244s.19.266-.058.533-.572.038-.572.038l-7.25-7.815zm9.406-3.438l3.597 3.285s.094.125-.029.25c-.122.125-.283.018-.283.018L11.688 4.23zm-7.592 7.04l3.597 3.285s.095.125-.028.25-.283.018-.283.018l-3.286-3.553z'/></svg>";$fallingsymbol='<svg id="falling" width="12" height="12" viewBox="0 0 24 24">
    <polyline points="23 18 13.5 8.5 8.5 13.5 1 6" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
    <polyline points="17 18 23 18 23 12" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
</svg>';$risingsymbol='<svg id="rising" width="12" height="12" viewBox="0 0 24 24">
    <polyline points="23 6 13.5 15.5 8.5 10.5 1 18" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
    <polyline points="17 6 23 6 23 12" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
</svg>';$steadysymbol='<svg id="steadybarometer" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
    <polyline points="9 18 15 12 9 6"/></svg>';$arrowsymbol='<svg id="arrow" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
    <polyline points="9 18 15 12 9 6"/></svg>';$aurora="<svg width='15px' height='15px' viewBox='0 0 980 982' >
<g id='kp index'>
<path fill='currentcolor' opacity='1.00' d=' M 454.81 0.00 L 480.19 0.00 C 482.39 0.64 484.67 1.12 486.98 1.07 C 498.65 0.90 510.33 1.09 522.01 0.95 C 527.71 0.84 533.31 2.31 539.03 2.01 C 569.34 3.67 599.10 10.47 628.21 18.76 C 647.15 24.51 665.84 31.12 684.05 38.93 C 732.36 59.73 777.23 88.50 816.39 123.62 C 823.74 129.56 829.96 136.72 836.75 143.25 C 842.46 149.21 848.72 154.65 854.01 161.00 C 880.68 190.52 903.83 223.27 922.66 258.32 C 930.00 273.14 937.82 287.74 943.89 303.14 C 961.62 345.46 972.96 390.36 978.14 435.93 C 979.19 441.18 978.44 446.65 980.00 451.81 L 980.00 524.18 C 978.09 529.75 979.61 535.72 978.47 541.42 C 977.58 554.74 975.84 568.02 973.09 581.09 C 958.00 660.80 922.91 736.71 871.57 799.56 C 867.85 804.16 864.18 808.81 860.21 813.20 C 855.89 817.57 852.35 822.64 847.75 826.74 C 842.27 831.64 838.42 838.07 832.64 842.65 C 828.50 845.81 824.86 849.53 821.28 853.28 C 761.67 907.71 688.64 947.41 610.41 967.40 C 587.95 972.83 565.25 977.79 542.13 979.28 C 535.71 980.40 529.15 979.55 522.73 980.66 C 517.18 981.37 511.58 980.88 506.00 981.00 C 500.74 981.17 495.31 980.26 490.22 982.00 L 480.77 982.00 C 472.36 979.81 463.54 981.55 454.96 981.01 C 393.97 976.60 333.71 960.96 278.57 934.45 C 270.42 931.34 263.13 926.50 255.34 922.65 C 219.14 902.99 185.41 878.80 155.22 850.78 C 151.72 847.28 148.44 843.53 144.53 840.47 C 139.73 836.94 136.77 831.59 132.26 827.74 C 127.11 823.18 123.10 817.58 118.31 812.69 C 94.67 785.20 73.68 755.37 56.67 723.33 C 54.13 717.98 50.71 713.10 48.36 707.66 C 44.82 699.02 40.16 690.89 36.88 682.14 C 20.94 644.92 10.17 605.61 3.33 565.75 C 2.38 557.51 1.05 549.30 0.94 541.00 C 0.86 539.35 0.41 537.75 0.00 536.18 L 0.00 441.82 C 1.01 438.65 1.05 435.32 1.18 432.04 C 2.01 421.61 4.28 411.37 6.07 401.08 C 9.71 383.05 14.20 365.19 19.62 347.62 C 24.54 333.07 29.01 318.33 35.24 304.27 C 55.92 253.58 85.14 206.41 121.27 165.28 C 125.22 161.53 128.32 157.01 132.22 153.22 C 138.76 146.76 145.27 140.27 151.73 133.72 C 187.49 100.21 228.01 71.66 272.01 50.00 C 323.61 23.12 380.90 9.10 438.26 1.28 C 443.75 0.46 449.46 1.90 454.81 0.00 M 458.40 43.43 C 411.36 47.26 364.67 57.88 320.99 75.99 C 271.47 96.00 225.99 125.61 186.73 161.73 C 179.29 169.28 171.73 176.73 164.25 184.25 C 157.03 191.07 151.02 199.00 144.35 206.34 C 124.16 230.90 106.20 257.38 91.66 285.67 C 74.17 319.51 61.42 355.71 52.80 392.79 C 48.55 412.93 44.03 433.26 43.84 453.91 C 42.47 459.85 43.12 465.96 43.00 472.00 C 43.00 486.33 43.00 500.67 43.00 515.00 C 43.03 519.14 42.66 523.33 43.58 527.40 C 44.53 531.75 43.47 536.24 44.43 540.59 C 45.25 544.72 44.82 549.00 45.82 553.11 C 53.50 601.75 67.86 649.59 90.67 693.34 C 98.37 709.67 108.23 724.85 117.98 740.01 C 127.92 754.24 138.28 768.20 149.64 781.34 C 153.10 786.18 157.92 789.81 161.34 794.68 C 168.28 802.05 175.68 808.99 182.72 816.27 C 185.92 819.77 190.07 822.21 193.25 825.75 C 217.10 846.85 243.11 865.56 270.93 881.10 C 277.41 885.18 284.62 887.89 291.18 891.83 C 319.48 906.11 349.56 916.72 380.19 924.83 C 402.74 930.21 425.57 935.23 448.77 936.28 C 456.01 937.93 463.48 936.28 470.78 937.29 C 477.10 938.64 483.59 937.76 490.00 938.00 C 496.07 937.79 502.23 938.61 508.23 937.29 C 515.85 936.26 523.66 937.95 531.23 936.29 C 545.72 935.34 560.19 933.43 574.41 930.43 C 601.02 924.91 627.33 917.67 652.58 907.58 C 675.07 898.67 697.08 888.40 717.68 875.68 C 733.25 866.59 748.11 856.36 762.43 845.43 C 772.04 838.11 781.03 830.03 790.26 822.25 C 794.04 818.71 797.34 814.66 801.43 811.44 C 808.11 806.81 812.03 799.42 818.26 794.27 C 867.66 741.07 903.89 675.61 922.33 605.36 C 928.78 581.10 933.98 556.32 935.28 531.23 C 936.59 525.23 935.83 519.07 935.95 513.00 C 935.64 508.28 937.35 503.72 937.04 499.00 C 936.80 491.70 937.30 484.37 936.84 477.08 C 934.77 467.80 937.22 458.19 935.16 448.91 C 934.32 427.08 929.48 405.63 924.57 384.40 C 916.71 353.64 906.36 323.38 892.07 294.98 C 889.97 289.36 886.36 284.50 884.02 278.99 C 868.51 250.26 849.86 223.21 828.46 198.56 C 825.87 194.86 822.17 192.14 819.44 188.57 C 815.92 183.81 811.30 180.03 807.25 175.75 C 801.93 170.74 797.23 165.04 791.43 160.56 C 750.96 123.41 703.54 93.93 652.59 73.41 C 637.53 67.50 621.97 62.94 606.40 58.59 C 586.56 53.64 566.66 48.40 546.23 46.67 C 541.74 45.60 537.08 46.43 532.60 45.43 C 527.92 44.40 523.08 45.60 518.41 44.57 C 511.42 43.14 504.24 44.71 497.22 43.71 C 490.57 42.32 483.73 43.26 477.00 43.00 C 470.80 43.24 464.55 42.46 458.40 43.43 Z' />
<path fill='currentcolor' opacity='1.00' d=' M 222.75 276.13 C 225.33 272.94 228.20 268.27 232.95 268.97 C 244.65 269.03 256.36 269.00 268.07 268.98 C 271.94 268.38 274.16 272.08 276.58 274.40 C 277.68 275.26 277.71 276.68 277.74 277.96 C 277.70 322.31 277.73 366.66 277.72 411.00 C 277.81 417.03 277.50 423.07 277.88 429.09 C 281.97 428.18 286.52 427.55 289.91 424.96 C 329.14 373.15 368.01 321.03 407.35 269.30 C 417.19 268.56 427.12 269.22 437.00 269.00 C 444.27 269.12 451.56 268.77 458.83 269.13 C 461.00 272.52 462.79 276.19 464.20 279.96 C 458.97 287.67 452.80 294.73 447.22 302.20 C 414.28 344.62 381.27 386.97 348.36 429.40 C 343.84 434.73 337.32 437.84 332.57 442.94 C 339.99 450.07 349.79 454.72 355.67 463.40 C 396.70 515.69 437.77 567.94 478.80 620.22 C 479.65 621.05 479.83 622.25 479.17 623.27 C 477.74 626.41 476.29 629.56 474.51 632.53 C 460.03 633.00 445.50 632.58 431.00 632.72 C 426.83 632.60 422.63 633.07 418.49 632.48 C 376.13 579.16 334.24 525.42 291.99 472.01 C 291.71 471.74 291.15 471.21 290.87 470.94 C 286.57 470.48 282.22 470.59 277.92 470.92 C 277.44 485.60 277.86 500.31 277.72 515.00 C 277.69 551.65 277.78 588.31 277.68 624.96 C 276.76 628.22 273.43 630.70 270.75 632.58 C 257.84 632.94 244.89 632.59 231.97 632.75 C 228.48 633.20 226.52 629.76 224.28 627.70 C 222.87 626.52 222.39 624.81 222.54 623.03 C 222.59 511.02 222.55 399.01 222.56 287.00 C 222.62 283.38 222.31 279.74 222.75 276.13 Z' />
<path fill='currentcolor' opacity='1.00' d=' M 618.40 364.67 C 638.11 361.44 658.60 362.75 677.77 368.37 C 693.77 373.36 708.67 382.68 719.06 395.97 C 730.94 410.96 737.17 429.61 740.54 448.23 C 743.80 467.61 744.85 487.36 744.05 506.99 C 743.13 527.80 739.13 548.59 730.84 567.76 C 723.78 584.40 713.29 599.74 699.53 611.57 C 686.77 622.65 671.32 630.49 655.00 634.81 C 636.67 639.50 617.46 639.47 598.75 637.48 C 591.23 636.78 584.08 634.36 576.90 632.23 C 576.44 663.13 576.91 694.06 576.67 724.96 C 576.73 726.75 575.02 727.76 574.01 728.99 C 572.25 730.53 570.75 733.08 568.06 732.73 C 556.02 732.72 543.98 732.72 531.94 732.73 C 529.24 733.09 527.74 730.56 526.02 728.98 C 524.79 727.49 522.74 726.22 523.01 724.03 C 522.97 609.00 523.04 493.96 522.98 378.93 C 522.60 374.46 527.08 371.63 530.17 369.19 C 541.01 368.85 551.92 368.88 562.78 369.18 C 565.13 376.71 566.37 384.55 568.77 392.07 C 581.48 377.54 599.45 367.98 618.40 364.67 M 604.26 417.21 C 593.43 422.43 585.99 432.74 581.63 443.68 C 579.12 450.18 576.51 456.92 576.69 464.00 C 576.76 488.67 576.70 513.33 576.72 538.00 C 576.91 551.59 576.34 565.22 576.99 578.79 C 585.10 584.76 595.07 587.98 605.03 589.12 C 617.59 590.42 630.63 590.78 642.75 586.65 C 659.24 581.26 672.18 567.72 679.06 552.04 C 687.71 532.65 689.28 510.97 688.98 489.99 C 688.30 472.03 686.41 453.38 677.73 437.30 C 671.15 424.87 658.93 415.43 644.97 413.03 C 631.43 410.63 616.82 411.15 604.26 417.21 Z' />
</g>
</svg>
";$arrowsymbol='<svg id="arrow" width="13" height="13" viewBox="0 0 17 18" fill="none" stroke="currentcolor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
    <polyline points="9 18 15 12 9 6"/></svg>';$uvisvg='<svg width="14px" height="14px" viewBox="0 0 980 982">
<g id="uvi">
<path fill="currentcolor" opacity="1.00" d=" M 454.85 0.00 L 480.16 0.00 C 482.70 0.70 485.32 1.13 487.97 1.07 C 499.32 0.93 510.66 1.05 522.01 0.96 C 525.40 0.91 528.77 1.34 532.14 1.75 C 553.78 2.41 575.34 5.58 596.40 10.59 C 663.65 25.55 727.74 54.77 782.87 96.14 C 796.52 106.36 809.56 117.37 822.26 128.74 C 831.26 137.74 840.23 146.77 849.27 155.73 C 877.86 186.70 902.74 221.16 922.67 258.33 C 930.00 273.14 937.82 287.74 943.88 303.14 C 962.52 347.64 974.14 395.00 978.87 442.99 C 978.95 445.97 979.21 448.96 980.00 451.86 L 980.00 524.14 C 978.21 530.03 979.51 536.26 978.37 542.27 C 977.52 556.45 975.37 570.53 972.42 584.42 C 954.89 674.33 911.50 759.03 848.76 825.76 C 842.71 831.07 838.47 838.11 832.11 843.10 C 827.56 846.52 823.82 850.81 819.75 854.74 C 789.55 881.78 756.31 905.54 720.44 924.46 C 704.72 933.37 688.05 940.41 671.44 947.43 C 649.53 956.27 626.94 963.37 604.01 969.00 C 583.90 973.53 563.67 977.92 543.04 979.20 C 536.31 980.31 529.46 979.61 522.73 980.66 C 511.93 982.02 500.85 979.57 490.18 982.00 L 480.80 982.00 C 472.36 979.86 463.56 981.53 454.97 981.00 C 393.97 976.62 333.71 960.95 278.56 934.45 C 270.19 931.23 262.70 926.24 254.67 922.31 C 221.26 903.99 189.81 882.03 161.54 856.46 C 156.89 852.81 152.97 848.36 148.77 844.23 C 145.62 841.03 141.68 838.65 138.98 835.02 C 135.65 830.71 131.51 827.15 127.74 823.26 C 106.46 799.78 86.96 774.57 70.53 747.44 C 63.14 735.90 56.98 723.64 50.32 711.68 C 47.65 706.56 45.76 701.07 43.00 696.00 C 25.45 658.35 13.33 618.32 5.44 577.58 C 3.12 565.51 1.45 553.30 0.90 541.02 C 0.78 539.36 0.37 537.74 0.00 536.13 L 0.00 441.86 C 0.89 438.65 1.05 435.33 1.19 432.04 C 1.78 425.05 2.87 418.12 4.23 411.25 C 7.88 389.98 13.14 369.01 19.38 348.36 C 24.37 333.56 28.92 318.57 35.24 304.26 C 55.92 253.57 85.14 206.40 121.27 165.27 C 124.69 162.00 127.50 158.18 130.75 154.74 C 140.26 145.59 149.06 135.67 159.09 127.08 C 200.41 89.24 248.51 59.13 299.85 36.86 C 344.27 18.34 391.53 7.50 439.13 1.19 C 444.36 0.68 449.75 1.67 454.85 0.00 M 458.40 43.43 C 405.54 47.69 353.21 60.70 304.98 82.93 C 293.02 87.87 281.82 94.37 270.42 100.43 C 258.46 107.71 246.19 114.53 234.98 122.96 C 221.47 132.27 208.59 142.46 196.26 153.26 C 183.80 163.73 172.97 175.97 161.23 187.23 C 137.34 212.96 116.32 241.42 99.02 272.00 C 83.24 299.94 70.84 329.73 61.45 360.41 C 53.25 388.01 46.86 416.29 44.03 444.97 C 44.23 450.01 43.74 455.00 43.02 459.97 C 42.94 480.32 43.07 500.67 42.96 521.02 C 42.86 525.38 44.33 529.61 44.00 534.00 C 43.91 539.29 45.16 544.49 45.29 549.78 C 51.57 590.69 62.31 631.07 79.05 668.98 C 83.77 680.54 89.92 691.43 95.32 702.67 C 111.74 732.79 131.65 760.97 154.25 786.75 C 158.50 790.54 161.50 795.46 165.74 799.27 C 174.26 807.41 182.03 816.36 191.23 823.77 C 217.23 847.55 246.40 867.81 277.32 884.68 C 282.17 887.15 287.16 889.35 291.81 892.19 C 309.50 900.76 327.59 908.67 346.37 914.62 C 360.63 919.58 375.16 923.74 389.87 927.11 C 409.24 931.56 428.88 935.35 448.77 936.30 C 457.12 938.03 465.75 935.93 474.09 937.82 C 484.04 938.19 494.03 938.01 503.99 937.92 C 513.26 935.90 522.81 938.06 532.09 936.21 C 558.49 934.65 584.41 928.77 609.89 921.91 C 674.83 903.81 735.54 870.76 785.89 825.91 C 792.21 821.28 796.77 814.70 803.13 810.11 C 806.33 807.65 808.88 804.49 811.34 801.33 C 815.86 796.19 821.30 791.90 825.37 786.35 C 839.83 770.22 852.85 752.85 864.79 734.79 C 876.78 715.64 888.38 696.12 897.33 675.33 C 908.91 650.32 917.73 624.12 924.41 597.40 C 929.83 575.70 934.13 553.59 935.30 531.23 C 937.08 522.50 934.91 513.50 936.70 504.77 C 937.33 500.21 936.90 495.59 936.99 491.00 C 936.87 485.25 937.50 479.44 936.30 473.77 C 935.28 465.80 936.92 457.68 935.30 449.77 C 934.49 432.98 931.70 416.33 928.10 399.92 C 922.65 374.51 915.21 349.52 905.66 325.34 C 887.24 279.44 861.37 236.47 828.91 199.11 C 825.54 194.51 820.95 190.99 817.65 186.32 C 811.55 179.77 804.99 173.66 798.76 167.24 C 759.10 129.63 712.75 98.97 662.42 77.54 C 644.39 69.48 625.38 63.92 606.40 58.60 C 584.25 52.95 561.89 47.38 539.00 46.00 C 536.85 45.99 534.70 45.84 532.60 45.43 C 527.91 44.49 523.09 45.51 518.41 44.57 C 511.15 43.12 503.68 44.81 496.40 43.57 C 491.33 42.55 486.13 43.11 481.00 43.00 C 473.47 43.25 465.88 42.46 458.40 43.43 Z" />
<path fill="currentcolor" opacity="1.00" d=" M 198.29 339.14 C 200.11 338.50 202.09 338.76 203.99 338.69 C 212.34 338.80 220.70 338.66 229.05 338.73 C 232.58 338.47 234.83 341.79 236.78 344.25 C 237.25 347.47 236.96 350.75 237.01 354.01 C 236.99 404.00 237.00 454.00 237.00 504.00 C 237.11 521.90 236.15 540.27 241.46 557.60 C 244.25 566.67 249.01 575.44 256.55 581.43 C 265.61 588.87 277.53 591.41 288.94 592.44 C 302.40 593.32 316.58 592.92 328.92 586.82 C 338.12 582.22 344.72 573.47 347.83 563.79 C 354.91 543.97 353.31 522.65 353.45 502.00 C 353.45 452.67 353.46 403.33 353.45 354.00 C 353.49 350.84 353.21 347.66 353.63 344.53 C 355.73 341.92 358.15 338.35 361.94 338.72 C 371.57 338.86 381.23 338.44 390.85 338.93 C 393.46 340.89 397.08 343.26 396.75 346.97 C 396.71 406.31 396.73 465.65 396.74 524.99 C 396.89 544.45 395.39 564.41 387.49 582.44 C 380.94 598.24 369.35 612.03 354.38 620.43 C 336.46 630.66 315.39 633.87 295.00 633.46 C 274.88 633.12 254.23 630.25 236.17 620.86 C 222.22 613.84 210.40 602.46 203.46 588.41 C 194.62 571.42 192.50 551.89 192.72 533.00 C 192.74 470.99 192.73 408.97 192.72 346.95 C 192.49 343.39 195.85 341.14 198.29 339.14 Z" />
<path fill="currentcolor" opacity="1.00" d=" M 435.14 338.87 C 448.38 338.66 461.65 338.56 474.87 338.91 C 476.57 340.51 476.85 343.09 477.80 345.16 C 500.83 407.73 524.07 470.23 547.18 532.77 C 549.45 539.75 550.55 547.05 552.36 554.17 C 554.43 551.67 554.28 548.11 555.22 545.12 C 557.16 534.62 561.30 524.76 564.73 514.71 C 579.09 474.06 593.43 433.39 607.76 392.73 C 614.25 374.78 620.24 356.65 626.99 338.80 C 639.30 338.69 651.61 338.62 663.92 338.84 C 665.80 341.13 667.48 343.59 669.00 346.14 C 663.86 361.36 657.80 376.26 652.35 391.38 C 622.15 472.25 592.14 553.21 561.83 634.04 C 554.30 634.43 546.72 634.45 539.19 634.03 C 508.30 552.82 477.49 471.59 446.65 390.37 C 441.14 375.61 435.23 361.00 430.06 346.14 C 431.59 343.60 433.27 341.16 435.14 338.87 Z" />
<path fill="currentcolor" opacity="1.00" d=" M 715.37 339.24 C 717.42 338.33 719.80 338.83 722.00 338.69 C 730.63 338.91 739.29 338.44 747.91 338.89 C 750.85 340.45 754.38 343.25 754.27 346.95 C 754.27 438.65 754.27 530.35 754.27 622.04 C 754.52 625.58 751.20 627.83 748.75 629.78 C 738.84 630.34 728.88 629.81 718.95 630.03 C 714.58 630.58 710.02 626.34 709.99 622.05 C 710.01 533.03 710.00 444.02 710.00 355.00 C 710.07 351.44 709.67 347.84 710.28 344.33 C 711.68 342.37 713.41 340.63 715.37 339.24 Z" />
</g>
</svg>';
$weather34logo= '<svg width="45" height="45" viewBox="0 0 431 306" xmlns="http://www.w3.org/2000/svg"><path fill="#00a4b4" stroke="#00a4b4" stroke-width=".1" d="M91 30c39-20 87.4-19.5 126 1 28.5 14.6 51.5 39.5 64 69 2.4 5.6 4 11.4 6 17.2-3.2-3.6-6.6-8.2-12-8.4-7-.7-13.3 6.2-12 13 .6 4.8 4.8 7.4 7.3 11 7.6 10 8 25 1 35.4-2.2 3.6-6 6.4-6.4 10.7-1 6.7 5 13.3 12 12.6 5.6-.2 8.8-5.5 12-9.3-5 23-15.5 45-31 62.7-11.5 13-25.4 24.2-41 32.3-25.3 13.2-54.7 18-83 14.2-28.8-3.8-56.2-17.2-77-37.4-22.2-21-37-49.7-41.3-80-3.7-25.7-.2-52.3 10.4-76 13-29.3 36.3-53.8 65-68m48.5 21.6C133 55 131 63.3 132 70c.6 5.6 3.7 12.3 10 13.2 4 .2 7.3-3 9-6.2 3.4-7 3-16-1.7-22.3-2.2-3-6.3-4.7-9.8-3M77.3 77.3C74 78.4 72 81.7 72 85c0 7 4.8 13 10.4 16.7 4 2.5 10 4 14 .8 4.2-3.5 3.3-9.6 1-13.8-3.8-7-11.8-13.2-20-11.3m124.8-.2c-7.4 1.6-13.7 7.7-16 15-1.2 3.6-.6 8.4 3 10.7 3.4 2.2 8 1.4 11.6-.4 5.4-2.6 10-7.6 11.7-13.5.8-3 1-6.6-1.3-9.2-2-2.6-5.8-3.3-9-2.6m-65 17c-10 1-20 5-27.8 11-11 8.7-18.5 21.8-20 35.7-2 14 2.2 28.5 11 39.6 8.8 11.4 22.4 19 36.8 20.2 17.4 2 35.4-5.5 46.5-19 9.4-11.2 14-26.4 12-41-1.7-14-9.3-27.3-20.7-36-10.6-8-24.5-12-38-10.6m-80.6 43.3c-5.7 1-12.4 6.4-9.8 12.8 4 7.7 14.4 9.2 22 7 4.4-1.3 9-4.4 9.6-9.3.2-3.4-2.2-6.5-5-8.2-5-3-11.2-3.8-16.8-2.3m160 .2c-4.3 1.2-9 4.3-9.6 9.2-.3 3.7 2.5 7 5.6 8.6 6.4 3.6 14.7 3.5 21 0 3.2-1.8 6-5 5.6-8.6-.2-3.3-2.7-6-5.5-7.5-5-3-11.4-3.5-17-1.8m-130 53.8C79 194 72.6 201 72 209c-.5 4.2 2.6 8.6 7 9 7.8.6 14.8-5 18.3-11.7 2-3.8 3.2-9 .2-12.8-2.7-3.2-7.5-3.4-11-2m103.8 0c-4.4 1.7-5.5 7.3-4 11.4 2.5 8 10 15 18.7 15 4.4.2 8.2-3.7 8-8 0-6.7-4.4-12.6-9.7-16.2-3.8-2.5-8.6-4.2-13-2.4m-51 21c-3.3 1.7-5.4 5.2-6.5 8.7-2 7-1.2 15 3.8 20.4 3 3.3 8.7 3.4 11.7 0 6-6.5 6.4-17 2-24.6-2-3.6-6.8-6.4-11-4.3z"/><path fill="#9aba2f" stroke="#9aba2f" stroke-width=".1" d="M217 31c25-13.2 54-18.2 82-14.5 29.5 3.7 57.4 17.3 78.6 38 22 21 36.5 49.4 40.8 79.4 3.7 26 0 53.4-11 77.4-13.8 30.8-39.4 56-70.3 69.6-37.7 17-83.2 15.5-120-3.8 15.6-8 29.5-19 41-32.2 15.5-17.8 26-39.7 31-62.7 6.5-9 10-20.2 10-31.3 0-12.2-4.4-24.2-12-33.8-2-5.8-3.6-11.6-6-17.2-12.5-29.5-35.5-54.4-64-69m119.4 21.4c-6 1.2-10 7.7-8.5 13.6.6 3.5 3.3 6 5.7 8.3 20.7 20.5 32.7 49.5 32.2 78.7 0 27.4-10.8 54.5-29.4 74.5-4.2 4-4.8 11.3-.8 15.7 4 5 12 5.6 16.2.8 28.7-29.3 41.7-72.7 35-113-4.6-28.8-19-56-40.3-75.8-2.7-2.6-6.7-3.6-10.3-2.8m-34 31.2c-7 3-8.4 13.6-2.6 18.5 13.5 13 21.3 31.4 21 50 0 14.3-5.3 28.4-14 40-2.6 3.4-6.7 6.3-7 11-1.2 7 5.3 13.7 12.2 12.8 6.4-.6 10-6.6 13.6-11.2 11-14.4 17-32.5 17.8-50.6 1-25.6-9.6-51.5-28.5-68.8-3.5-3-8.6-3.7-12.5-1.6z"/><path fill="#f7f7f7" stroke="#f7f7f7" stroke-width=".1" d="M139.5 51.6c3.5-1.6 7.6 0 9.8 3C154 61 154.3 70 151 77c-1.8 3.3-5 6.4-9 6.2-6.3-1-9.4-7.6-10-13.2-1-6.7 1-15 7.5-18.4zM336.4 52.4c3.6-.8 7.6.2 10.3 2.8 21.3 20 35.7 47 40.3 75.8 6.7 40.3-6.3 83.7-35 113-4.3 4.8-12.3 4-16.2-.8-4-4.4-3.4-11.6.8-15.7 18.6-20 29.4-47 29.3-74.5.4-29.2-11.6-58.2-32.3-78.7-2.4-2.4-5-4.8-5.8-8.3-1.6-6 2.4-12.4 8.4-13.6zM77.3 77.4c8.3-2 16.3 4.3 20 11.3 2.4 4.2 3.3 10.3-.8 13.8-4 3.2-10 1.7-14-.8C76.7 98 72 92 72 85c0-3.3 2-6.6 5.3-7.6zM202.2 77.2c3.2-.7 7 0 9 2.6 2.2 2.6 2 6.3 1.3 9.3-1.8 6-6.3 11-11.7 13.6-3.6 1.8-8.2 2.6-11.7.3-3.4-2.4-4-7.2-2.8-11 2.3-7 8.6-13.2 16-14.8z"/><path fill="#f7f7f7" stroke="#f7f7f7" stroke-width=".1" d="M302.5 83.6c4-2 9-1.4 12.4 1.6 18.8 17.3 29.4 43.2 28.4 68.8-.7 18-6.7 36.2-17.8 50.6-3.6 4.6-7.2 10.6-13.6 11.2-7 1-13.4-5.8-12.3-12.7.4-4.7 4.5-7.6 7.2-11 8.5-11.6 13.7-25.7 13.7-40 .4-18.6-7.4-37-21-50-5.7-4.8-4.3-15.4 2.8-18.4zM137 94.2c13.5-1.5 27.4 2.5 38 10.7 11.4 8.5 19 21.8 20.7 36 2 14.4-2.6 29.6-12 40.8-11 13.5-29 21-46.5 19-14.4-1.3-28-8.8-37-20.2-8.6-11-12.8-25.7-11-39.7 1.7-14 9.2-27 20.2-35.7 8-6.2 17.7-10.2 27.7-11m-3.6 22.3c-13 3.8-23 16.6-23 30.4-.5 12.5 7.4 24.8 19 29.8 11.5 5.5 26.2 3 35.3-6 10.6-9.8 13-27 5.7-39.2-7-12.7-23-19.3-37-15z"/><path fill="#f7f7f7" stroke="#f7f7f7" stroke-width=".1" d="M263 122c-1.3-7 5-14 12-13.2 5.4.2 8.8 4.8 12 8.4 7.6 9.6 12 21.6 12 33.8 0 11-3.5 22.2-10 31.3-3.2 3.8-6.4 9-12 9.3-7 .7-13-6-12-12.7.3-4.4 4-7.2 6.2-10.8 7-10.5 6.7-25.3-1-35.4-2.4-3.6-6.6-6.2-7-11z"/><path fill="#00a4b4" stroke="#00a4b4" stroke-width=".1" d="M133.4 116.6c14-4.3 30 2.3 37 15 7.4 12.3 5 29.4-5.7 39-9 9-23.8 11.7-35.4 6.2-11.5-5-19.4-17.3-19-29.8 0-13.8 10-26.7 23-30.4z"/><path fill="#f7f7f7" stroke="#f7f7f7" stroke-width=".1" d="M56.4 137.5c5.6-1.5 12-.8 16.8 2.3 2.8 1.7 5.2 4.8 5 8.2-.6 5-5.2 8-9.6 9.3-7.6 2.2-18 .7-22-7-2.6-6.4 4-11.7 9.8-12.8zM216.4 137.7c5.7-1.7 12-1 17 1.8 3 1.5 5.4 4.2 5.6 7.5.3 3.7-2.4 6.8-5.5 8.5-6.4 3.6-14.7 3.7-21 0-3.2-1.6-6-4.8-5.7-8.6.6-5 5.3-8 9.6-9.3zM86.4 191.5c3.6-1.4 8.4-1.2 11 2 3 3.7 2 9 0 12.8-3.6 6.6-10.7 12.3-18.5 11.6-4.4-.4-7.5-4.8-7-9 .7-8 7-15 14.4-17.5zM190.3 191.4c4.4-1.8 9.2 0 13 2.4 5.3 3.6 9.7 9.5 9.7 16 .2 4.5-3.6 8.4-8 8.2-8.6 0-16.2-7-18.7-15-1.5-4.2-.4-9.8 4-11.6zM139.4 212.5c4-2 8.8.7 10.8 4.3 4.5 7.5 4 18-2 24.6-3 3.4-8.6 3.3-11.6 0-5-5.3-6-13.5-3.8-20.3 1-3.4 3.2-7 6.6-8.5z"/></svg>';
$ssllogo='<svg width="50" height="50" viewBox="0 0 431 306" xmlns="http://www.w3.org/2000/svg"><path fill="#00a4b4" stroke="#00a4b4" stroke-width=".1" d="M99 26.2c37.5-16 82-14.3 118 4.7 31.6 16 56.2 45 67.6 78.5-6.3-.6-13.5 0-18.2 4.8-5.4 5.2-5.3 14.8.3 20 6 5.3 14.5 5 21.4 8.3 3.6 1.4 3.3 6 .8 8-3.6 3-9 3-13 .8-3-1.7-4-5.2-5-8l-10.5 1c1 5.8 3 12 8.3 15 7 4 15.6 3.8 23.2 1.7-.5 6.8-1 13.6-2.8 20-.6 2-1 4-1.2 6-9 38.4-35.8 72-70.8 90-26 13.7-56 18.5-85 14-29-4.2-56.4-18.2-77-39-21.4-21.2-35.5-49.5-39.4-79.3-4-28.2 1-57.6 14.3-82.8 14.6-28.5 39.5-51.5 69-64m40 37c-15.4 4.6-27.7 17.6-32 33-2.6 8.8-1.6 18-1.8 27-1.8.3-3.8 0-5.5.7-4 1.7-6 6.2-5.7 10.3v71c-.2 5 3.6 10.3 9 10h94c3 0 5.8.2 8.7-.3 4-1.3 6.4-5.6 6.3-9.6v-25l61.6-81.3c1.8-2 2.2-5.4 0-7.3-3-2.6-6-5.3-9.4-7.4-2.8-2-5.7.8-7.4 2.8-15 19.8-30 39.4-44.8 59.2-.2-5.3.5-10.7-.4-16-1-4.8-6-7.6-10.8-7-.2-8.4.7-17.2-1.5-25.6-3-12.8-11.7-24-23.3-30.5-11-6.5-24.8-7.7-37-4m129.6 113.4c-3.8 1.8-4.8 7.7-1.5 10.4 3.5 2.3 7.7 2.4 11.3 4-.3 4.3-7.2 3-8-.6l-6.2 1c1.4 2.7 3 5.4 6 6 4 1 8.3 1.2 11.6-1 3.6-2.4 4-8.7 0-10.8-3.5-2-7.5-2.3-11.2-3.8 2-3.2 6.3-2.2 7.6 1l6-1.2c-1.8-6.6-10-7.5-15.4-5z"/><path fill="#9aba2f" stroke="#9aba2f" stroke-width=".1" d="M217 31c25-13.2 54-18.2 82-14.5 30 3.7 58.3 17.7 79.6 39 21.3 20.8 35.6 48.8 39.8 78.4 3.8 26.5 0 54.4-11.6 79-14.2 30.3-40 55.3-71 68.5-37.6 16.4-82.5 14.7-118.8-4.4 35-18 61.8-51.6 70.8-90 .5 3.3 1 7 4 9 3 2.4 7.3 2.4 10.8 1.3 2.7-1 4-3.7 5.5-6l-6-1c-1 1.2-2 3-4 2.8-2.4 0-3-2.7-4.2-4.4 4.8-.2 9.7 0 14.5 0-.3-3.8-.3-8-3.2-10.7-4.6-4.7-13.3-3-16 3 2-6.4 2.3-13.2 2.8-20 8.8-2.7 13-13.6 9-21.7-2-4.2-6.4-6.7-10.6-8-.6-3.3-1-6.6-2-9.8l2 4.8 11-.7c-.8-3.7-1.4-7.7-4-10.5-3-3.6-8-5-12.4-5.5C273.2 76 248.6 47 217 31m99.8 81.8c-7.4 4.8-7.6 16.8-.7 22.2 6 4.8 14.5 4.5 21 8 3.4 1.4 2.8 6 0 8-3.4 2.5-8.6 2.7-12.5.6-3-1.5-4-5-5-8.2-3.5.4-7 .8-10.4 1 .7 5 2.3 10.2 6 13.5 4.4 3.7 10.5 4.6 16 4.5 5.3-.2 11-1 15-4.7 6.5-6 6.5-17.8-.6-23.3-6.2-4.7-14.4-4.5-21.3-7.8-2.3-1-3.2-4.5-1-6 3.5-2.4 8-2.6 12-1 2.3 1.3 3 4 3.7 6.4l10.6-.5c0-6.5-3.8-13-10-15-7.3-2-15.8-2.2-22.4 2m43.5-1.8v50.6H397V152h-25.6v-41h-11m-46 67.4c-3.3 4-3.4 10-1.4 14.6 2.4 5.2 9.2 6 14 4.2 3-1.2 4.3-4.3 5.3-7-2-.4-4-.8-6.2-1-.4 2.2-2 4.8-5 4-4-1.6-3.6-7.4-2.4-10.8 1.8-3.4 6.4-2 7.4 1.2l5.8-1c-1.6-7.7-12.3-9.6-17.4-4.2m21.8-2.4c.3 6-.7 12 .5 17.8 2 5.7 9.7 5 13.6 1.8v2h5.5V176h-6c-.3 4.7.3 9.5-.4 14.2-.5 2.8-4.8 4.3-6.5 1.7-1.4-5.4-.5-10.8-.8-16h-6m25.4 0v21.5h6c.2-4.5-.3-9 .6-13.5 0-1.5 1.5-2.4 2.7-3.3l3 1.4c.6-1.7 1-3.6 1.7-5.4-3-1.6-6.4-1.4-8.5 1.4v-2h-5.6m18 2.5c-3.3 3.6-3.2 8.8-2.2 13.2 1.3 4.5 6 7 10.6 6.3 4.2.2 7.3-3 8.8-6.6l-6-1c-1 1-2 3.2-3.8 2.8-2.6 0-3.4-2.7-4.4-4.6H397c0-3-.2-6.2-1.8-9-3.2-5-11.7-5.7-15.6-1z"/><path fill="#fff" stroke="#fff" stroke-width=".1" d="M139 63c12.2-3.6 26-2.4 37 4 11.6 6.3 20.2 17.7 23.3 30.4 2.2 8.4 1.3 17.2 1.5 25.7 4.8-.5 9.7 2.3 10.8 7 1 5.4.2 10.8.4 16-3.4 4.7-7 9-10.3 13.8-1.4 2-2.8 3.7-4.7 5-2.2-.8-4-2.4-5.8-4-8-7-16.2-13.6-24.2-20.6-2.5-1.8-5.2-5-8.7-3.7-4 3-6.4 7.4-9.5 11.2-4.2 1.6-7.8 5-8.7 9.5-1 4.4 1 8.8 3.5 12.2.3 7.5-.3 15 .3 22.4 1 4 6 3 9.3 3.3 3.3-.2 8.3.7 9.4-3.4.6-7.4 0-15 .2-22.4 1-1 1.8-2.3 2.7-3.5 9.6 8 19.3 16.2 28.8 24.5 2 2 5.6 4.4 8.4 2 3.7-3.5 6.3-8 9.7-12v25c0 4-2.2 8.4-6.2 9.7-3 .4-5.8 0-8.7.2h-94c-5.3.3-9-5-9-10v-71c-.2-4 2-8.6 5.8-10.3 1.8-.7 3.7-.5 5.5-.7.2-9-.8-18.2 2-27 4-15.4 16.4-28.4 31.8-33m2.5 20.5c-8.8 4-15.2 12.8-16.2 22.4-.5 5.7-.2 11.5-.3 17.2h56c0-5.8.3-11.6-.2-17.3-1-9.4-7-18-15.5-22-7.4-4-16.5-4-24-.4z"/><path fill="#00a4b4" stroke="#00a4b4" stroke-width=".1" d="M141.4 83.5c7.4-3.6 16.5-3.5 24 .3 8.3 4 14.4 12.7 15.4 22 .5 5.8.2 11.6.3 17.4h-56c0-5.7-.2-11.5.3-17.3 1-9.8 7.4-18.6 16.2-22.6z"/><path fill="#9aba2f" stroke="#9aba2f" stroke-width=".1" d="M256.8 86.8c1.7-2 4.6-4.7 7.4-3 3.4 2.2 6.5 5 9.5 7.5 2 2 1.7 5.3 0 7.3L212 180c-3.4 4-6 8.5-9.7 12-2.8 2.4-6.2 0-8.3-2-9.5-8.3-19.2-16.4-28.8-24.5-4.6-4-9.4-7.7-13.8-12-1.8-1.5-2.6-3.7-2.6-6 3-3.8 5.6-8.2 9.5-11.2 3.5-1.4 6.2 2 8.7 3.8l24.2 21c1.8 1.4 3.6 3 5.8 4 2-1.5 3.3-3.4 4.7-5 3.3-4.8 7-9.3 10.3-14 15-19.7 30-39.3 44.8-59z"/><path fill="#f7f7f7" stroke="#f7f7f7" stroke-width=".1" d="M266.4 114.3c4.7-4.6 12-5.3 18.2-4.7 4.5.6 9.3 2 12.3 5.6 2.5 2.8 3 6.8 4 10.5l-11 .6-2-4.7c-2.4-2.4-6-2.8-9-2.4-2.5.4-5.4 1.3-6 4 0 1.8 1.2 3.3 3 4 4.3 2 9.3 2.5 14 4 4.2 1.5 8.5 4 10.5 8.2 4 8 0 19-9 21.8-7.5 2-16 2.4-23-1.7-5.4-3-7.4-9.2-8.4-15l10.7-1c1 2.8 1.8 6.3 4.8 8 4 2.2 9.5 2.2 13-.7 2.6-2 3-6.7-.5-8-6.8-3.4-15.4-3-21.3-8.5-5.6-5-5.7-14.7-.3-20zm50.4-1.5c6.6-4.2 15-4 22.3-2 6.5 2 10.4 8.5 10.3 15-3.6 0-7 .3-10.6.6-.8-2.3-1.4-5-3.8-6.3-3.8-1.5-8.5-1.3-12 1-2.2 1.6-1.3 5 1 6 7 3.3 15 3 21.4 7.8 7 5.5 7 17.3.5 23.2-4 3.6-9.7 4.4-15 4.6-5.5 0-11.6-.8-16-4.7-3.7-3.5-5.3-8.7-6-13.6l10.5-1c1 3 2 6.6 5 8 4 2.2 9 2 12.7-.6 2.7-2 3.3-6.6 0-8-6.6-3.5-15-3.2-21-8-6.8-5.4-6.6-17.4.8-22.2zm43.6-1.8h11v41.2h25.4v9.4h-36.4V111z"/><path fill="#00a4b4" stroke="#00a4b4" stroke-width=".1" d="M273 123.2c.7-2.7 3.6-3.6 6-4 3-.5 6.7 0 9 2.4 1 3.2 1.4 6.5 2 9.7-4.6-1.6-9.6-2.2-14-4.2-1.7-.4-3-2-3-3.7zM140 157c1-4.5 4.6-8 8.8-9.5 0 2.3.8 4.5 2.6 6 4.4 4.3 9.2 8 13.8 12l-2.7 3.6c-.2 7.7.4 15-.2 22.6-1 4-6.2 3.2-9.3 3.4-3.2-.3-8.2.6-9.3-3.4-.6-7.5 0-15-.3-22.4-2.6-3.4-4.6-7.8-3.3-12.2z"/><path fill="#f7f7f7" stroke="#f7f7f7" stroke-width=".1" d="M268.6 176.5c5.3-2.4 13.6-1.5 15.3 5.2l-6 1c-1.5-3-6-4-7.8-1 3.7 1.6 7.7 2 11.3 4 4 2 3.5 8.3 0 10.7-3.4 2.2-7.8 2-11.5 1-3-.6-4.7-3.3-6-6l6-1c1 3.7 8 5 8.2.5-3.6-1.7-7.8-1.8-11-4-3.4-3-2.4-8.8 1.4-10.6zm20.4 4.7c2.6-6 11.3-7.8 16-3.2 3 2.7 3 7 3.2 10.6h-14.5c1.2 1.8 1.8 4.4 4.3 4.7 2 0 3-1.7 4-2.8l6 1c-1.4 2.2-2.7 5-5.4 6-3.5 1-7.8 1-10.8-1.3-3-2-3.5-5.8-4-9l1-6m8.7-.8c-2.2.3-2.8 2.5-3.6 4.2h8.2c-.7-2-2-5-4.8-4.2zm17-2c5-5.4 15.7-3.5 17.3 4.3l-6 1c-1-3.4-5.5-4.7-7.3-1.3-1.2 3.4-1.6 9.2 2.6 10.8 3 .8 4.6-1.8 5-4 2.3.2 4.3.6 6.4 1-1 2.7-2.3 5.8-5.3 7-4.7 2-11.5 1-14-4.2-2-4.6-2-10.7 1.5-14.6zM336 176h6c.4 5.3-.5 10.7.7 16 1.5 2.5 6 1 6.3-1.8.7-4.7 0-9.5.3-14.2h6v21.6H350v-2c-3.7 3.2-11.4 4-13.4-1.8-1.2-5.8-.2-12-.5-17.8zm25.5 0h5.6v2c2-3 5.5-3 8.5-1.5-.6 1.8-1 3.7-1.7 5.6l-3-1.2c-1 1-2.5 1.8-2.6 3.4-1 4.6-.4 9-.5 13.6h-6V176zm18 2.5c4-4.6 12.3-4 15.5 1.2 1.6 2.7 1.7 6 2 9-5 0-9.7-.2-14.6 0 1 1.8 1.8 4.6 4.4 4.5 2 .4 2.7-1.7 3.8-2.8l6 1c-1.5 3.6-4.6 6.8-8.7 6.6-4.3.7-9.2-1.8-10.4-6.3-1-4.4-1-9.6 2-13.2m3.2 6c2.8.2 5.6.2 8.4 0-.6-1.7-1.5-4.3-4-4-2.5-.4-3.5 2.3-4.3 4z"/><path fill="#9aba2f" stroke="#9aba2f" stroke-width=".1" d="M297.5 180.4c2.7-.7 4 2.2 4.8 4.2H294c.8-1.7 1.3-4 3.5-4.2zm85.2 4.2c.8-1.8 1.8-4.5 4.3-4.2 2.5-.2 3.4 2.4 4 4.2h-8.3z"/></svg>';
$touchme= '<svg id="email me" viewBox="0 0 106 106">
<path fill="#fff" id="hand" d="M29 80.7c4.3-5.1 11.6-6.4 17.4-3.2l3.2 1.7-11-36c-1.1-3.8 1-7.8 4.7-8.9 3.7-1.1 7.8 1 8.9 4.8l5.7 18.5c.7-2 2.3-3.5 4.4-4.2 1.5-.4 3-.4 4.3.1l17.3 4.1c2.3.6 5.2 4.8 5.9 7.4l3.5 11.2c3.7 12.2-3.8 22.7-16 26.4-5.9 1.8-12 1.1-17-1.5L29.7 84.9c-1.2-.7-1.7-2.2-1.1-3.6.1-.3.2-.5.4-.6z"/>
<path fill="#fff" id="outer" d="M18.5 38.3c.7 4.9 2.7 9.6 5.9 13.4 1.1 1.4 1 3.3-.4 4.4-.5.4-1 .6-1.6.7-1.1.1-2.1-.2-2.8-1.1-3.9-4.8-6.5-10.6-7.4-16.6C9.7 21.3 21.9 4.8 39.3 2.3c17.5-2.5 33.8 10.1 36.2 28 .4 2.6.4 5.3.1 7.9-.1 1.7-1.7 3-3.5 2.8-1.7-.1-3-1.7-2.8-3.5.2-2.1.1-4.3-.1-6.4C67.2 16.7 54 6.6 40 8.6c-13.7 2-23.5 15.3-21.5 29.7z"/>
<path fill="#fff" id="inner" d="M60.8 40.8c-1.7-.2-2.8-1.8-2.6-3.7.2-1.5.2-2.8 0-4.3-1.1-8-8.4-13.6-16.1-12.4S28.8 28.8 30 36.7c.4 2.3 1.2 4.7 2.6 6.5 1 1.4.7 3.5-.6 4.4-.4.4-.9.5-1.4.6-1.1.1-2.2-.4-3-1.2-2-2.8-3.3-6-3.8-9.5-1.6-11.4 6.2-22 17.4-23.5s21.6 6.4 23.2 17.9c.2 2.1.2 4.2 0 6.2-.3 1.7-1.9 2.9-3.6 2.7z"/></svg>';
$touchme2 ='<svg id="email me" class="arrow" width="28" height="28" viewBox="0 0 106 106" >
<path fill="#ff8841" id="hand" d="M29 80.7c4.3-5.1 11.6-6.4 17.4-3.2l3.2 1.7-11-36c-1.1-3.8 1-7.8 4.7-8.9 3.7-1.1 7.8 1 8.9 4.8l5.7 18.5c.7-2 2.3-3.5 4.4-4.2 1.5-.4 3-.4 4.3.1l17.3 4.1c2.3.6 5.2 4.8 5.9 7.4l3.5 11.2c3.7 12.2-3.8 22.7-16 26.4-5.9 1.8-12 1.1-17-1.5L29.7 84.9c-1.2-.7-1.7-2.2-1.1-3.6.1-.3.2-.5.4-.6z"/>
<path fill="#ff8841" id="outer" d="M18.5 38.3c.7 4.9 2.7 9.6 5.9 13.4 1.1 1.4 1 3.3-.4 4.4-.5.4-1 .6-1.6.7-1.1.1-2.1-.2-2.8-1.1-3.9-4.8-6.5-10.6-7.4-16.6C9.7 21.3 21.9 4.8 39.3 2.3c17.5-2.5 33.8 10.1 36.2 28 .4 2.6.4 5.3.1 7.9-.1 1.7-1.7 3-3.5 2.8-1.7-.1-3-1.7-2.8-3.5.2-2.1.1-4.3-.1-6.4C67.2 16.7 54 6.6 40 8.6c-13.7 2-23.5 15.3-21.5 29.7z"/>
<path fill="#ff8841" id="inner" d="M60.8 40.8c-1.7-.2-2.8-1.8-2.6-3.7.2-1.5.2-2.8 0-4.3-1.1-8-8.4-13.6-16.1-12.4S28.8 28.8 30 36.7c.4 2.3 1.2 4.7 2.6 6.5 1 1.4.7 3.5-.6 4.4-.4.4-.9.5-1.4.6-1.1.1-2.2-.4-3-1.2-2-2.8-3.3-6-3.8-9.5-1.6-11.4 6.2-22 17.4-23.5s21.6 6.4 23.2 17.9c.2 2.1.2 4.2 0 6.2-.3 1.7-1.9 2.9-3.6 2.7z"/></svg>';
$close ='<svg id="i-close" viewBox="0 0 32 32" width="32" height="32" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
    <path d="M2 30 L30 2 M30 30 L2 2" />
</svg>';
$svgmail= '<svg id="i-mail" viewBox="0 0 32 32" width="32" height="32" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
    <path d="M2 26 L30 26 30 6 2 6 Z M2 6 L16 16 30 6" />
</svg>';$arrow34icon ='<svg x="0px" y="0px" width=14 height=14 fill=#ccc stroke=#ccc viewBox="0 0 1000 1000" enable-background="new 0 0 1000 1000" >
<g><path d="M500,10C229.4,10,10,229.4,10,500c0,270.6,219.4,490,490,490c270.6,0,490-219.4,490-490C990,229.4,770.6,10,500,10z M500,967.9C241.6,967.9,32.1,758.4,32.1,500C32.1,241.6,241.6,32.1,500,32.1c258.4,0,467.9,209.5,467.9,467.9C967.9,758.4,758.4,967.9,500,967.9z M634.6,501.4l-247,248.3L371,733l230.3-231.6L371,269.8l16.6-16.7L634.6,501.4L634.6,501.4z"/></g></svg>'; 
$webcam34icon='<svg x="0px" y="0px" width=14 height=14 fill=#ccc stroke=#ccc viewBox="0 0 1000 1000" enable-background="new 0 0 1000 1000" >
<g><g transform="translate(0.000000,511.000000) scale(0.100000,-0.100000)"><path d="M4546.8,4991.7c-966.9-124.5-1867.7-618.7-2498-1369.6c-647.9-770.4-978.6-1776.2-900.8-2731.5c99.2-1212,716-2266.5,1721.8-2941.6c1535-1031.1,3531.1-834.6,4848.2,478.6c1180.9,1177,1480.5,2939.7,749,4408.5c-593.4,1192.6-1721.8,1994.1-3036.9,2155.6C5237.5,5017.1,4739.4,5015.1,4546.8,4991.7z M5642.1,4546.2c1237.4-229.6,2235.4-1091.4,2626.4-2268.5c124.5-375.5,161.5-585.6,171.2-1019.4c17.5-675.1-85.6-1149.8-375.5-1712.1c-169.3-326.8-344.4-568.1-601.2-826.8c-597.3-603.1-1311.3-931.9-2182.9-1005.8c-846.3-72-1700.4,173.2-2373.5,679C2116.9-1014,1616.9-80.2,1560.5,908.1c-60.3,1089.5,317.1,2066.1,1073.9,2772.4c252.9,235.4,486.4,396.9,801.6,554.5c377.4,188.7,745.1,299.6,1157.6,350.2C4834.8,4614.3,5389.2,4594.9,5642.1,4546.2z"/><path d="M4718,1715.5c-268.5-58.4-501.9-182.9-719.8-385.2c-260.7-243.2-431.9-570.1-472.8-910.5C3420.4-420.7,4146-1231.9,5002.1-1231.9c657.6,0,1272.4,488.3,1441.6,1144c179,698.5-231.5,1463-933.8,1733.4C5247.2,1746.6,4970.9,1770,4718,1715.5z M5354.2,1277.8c332.7-101.2,597.3-383.3,686.8-733.5c38.9-149.8,38.9-431.9,1.9-577.8c-101.2-383.3-408.6-679-797.7-760.7c-589.5-124.5-1138.1,200.4-1284,760.7c-37,144-37,433.9,0,577.8c105.1,404.7,424.1,696.5,842.4,772.4C4939.8,1342,5210.2,1322.5,5354.2,1277.8z"/><path d="M4762.8,919.8c-299.6-126.5-505.8-441.6-472.8-727.6c27.2-223.7,188.7-453.3,404.7-568.1c237.3-126.5,511.7-97.3,735.4,79.8c190.7,149.8,311.3,414.4,282.1,620.6C5681,554,5492.3,805,5278.3,904.2C5118.8,978.2,4916.5,984,4762.8,919.8z M5157.7,522.9c91.4-46.7,142-138.1,142-266.5c0-184.8-112.8-301.6-291.8-301.6c-165.4,0-262.6,70-297.7,214c-25.3,105-1.9,235.4,54.5,299.6C4844.5,557.9,5035.1,585.2,5157.7,522.9z"/><path d="M1877.6-2156c-33.1-17.5-70-50.6-81.7-73.9c-13.6-23.3-149.8-418.3-307.4-879.4c-324.9-955.2-330.7-990.3-231.5-1175.1c105.1-192.6,342.4-352.1,671.2-453.3l145.9-44.7l2854.1-5.8c2770.4-3.9,2861.8-3.9,3042.8,33.1c498.1,103.1,879.4,428,838.5,719.9c-5.8,38.9-140.1,455.2-297.7,926.1c-319.1,947.5-326.9,963-472.8,963c-114.8,0-206.2-83.7-204.3-186.8c2-42.8,126.4-447.5,287.9-920.2c165.4-492.2,280.2-859.9,274.3-879.3c-31.1-97.3-245.1-194.6-501.9-229.6c-212.1-29.2-5573.9-29.2-5786,0c-173.1,23.3-330.7,73.9-412.4,132.3c-120.6,85.6-122.6,70,196.5,1015.5c272.4,813.2,289.9,867.7,268.5,937.7C2126.6-2156,1990.4-2099.6,1877.6-2156z"/></g></g>
</svg>';
$weather34menuicon='<svg width="32pt" height="32pt" viewBox="0 0 1003 799" id="weather34 menu">
<path fill="#aaa" stroke="#aaa" stroke-width="0.09375" opacity="1.00" d=" M 144.01 44.74 C 394.00 44.73 644.00 44.73 893.99 44.74 C 894.00 65.56 894.00 86.38 893.99 107.20 C 644.00 107.20 394.00 107.20 144.01 107.20 C 144.00 86.38 143.99 65.56 144.01 44.74 Z" />
<path fill="#aaa" stroke="#aaa" stroke-width="0.09375" opacity="1.00" d=" M 138.01 208.74 C 388.00 208.73 638.00 208.73 887.99 208.74 C 888.00 229.56 888.00 250.38 887.99 271.20 C 638.00 271.20 388.00 271.20 138.01 271.20 C 138.00 250.38 137.99 229.56 138.01 208.74 Z" />
<path fill="#aaa" stroke="#aaa" stroke-width="0.09375" opacity="1.00" d=" M 142.01 368.74 C 392.00 368.73 642.00 368.73 891.99 368.74 C 892.00 389.56 892.00 410.38 891.99 431.20 C 642.00 431.20 392.00 431.20 142.01 431.20 C 142.00 410.38 142.00 389.56 142.01 368.74 Z" />
<path fill="#aaa" stroke="#aaa" stroke-width="0.09375" opacity="1.00" d=" M 117.50 783.24 C 117.50 711.74 117.49 640.25 117.51 568.75 C 127.61 568.73 137.72 568.78 147.82 568.72 C 171.59 631.16 195.13 693.69 218.85 756.15 C 243.45 693.70 267.94 631.22 292.52 568.76 C 302.59 568.74 312.67 568.75 322.75 568.76 C 322.76 640.25 322.76 711.75 322.75 783.24 C 315.83 783.25 308.92 783.25 302.01 783.25 C 301.96 721.39 302.06 659.54 301.96 597.69 C 277.46 659.52 253.00 721.36 228.59 783.22 C 222.12 783.29 215.65 783.21 209.18 783.27 C 185.46 721.39 162.18 659.34 138.27 597.53 C 138.22 659.44 138.27 721.34 138.24 783.24 C 131.33 783.25 124.42 783.26 117.50 783.24 Z" />
<path fill="#aaa" stroke="#aaa" stroke-width="0.09375" opacity="1.00" d=" M 364.51 783.25 C 364.49 711.75 364.49 640.25 364.51 568.76 C 413.92 568.75 463.33 568.75 512.75 568.75 C 512.75 574.67 512.76 580.58 512.74 586.50 C 470.25 586.50 427.75 586.50 385.26 586.50 C 385.25 612.17 385.23 637.84 385.27 663.51 C 425.01 663.49 464.75 663.50 504.50 663.50 C 504.50 669.42 504.51 675.33 504.49 681.25 C 464.75 681.26 425.00 681.24 385.25 681.25 C 385.25 709.33 385.25 737.41 385.25 765.49 C 428.25 765.51 471.25 765.48 514.24 765.51 C 514.25 771.42 514.25 777.33 514.24 783.24 C 464.33 783.25 414.42 783.25 364.51 783.25 Z" />
<path fill="#aaa" stroke="#aaa" stroke-width="0.09375" opacity="1.00" d=" M 542.01 568.75 C 549.72 568.74 557.44 568.76 565.16 568.74 C 606.89 629.21 648.48 689.79 690.23 750.24 C 690.28 689.75 690.23 629.25 690.25 568.76 C 697.17 568.74 704.08 568.75 710.99 568.75 C 711.00 640.25 711.00 711.75 710.99 783.25 C 703.33 783.26 695.66 783.24 688.00 783.26 C 646.23 722.74 604.62 662.10 562.81 601.61 C 562.68 662.15 562.80 722.70 562.75 783.24 C 555.83 783.25 548.92 783.25 542.01 783.25 C 542.00 711.75 542.00 640.25 542.01 568.75 Z" />
<path fill="#aaa" stroke="#aaa" stroke-width="0.09375" opacity="1.00" d=" M 751.50 693.04 C 751.50 651.61 751.49 610.18 751.51 568.75 C 758.42 568.75 765.33 568.74 772.24 568.76 C 772.27 614.87 772.21 660.99 772.27 707.10 C 772.86 724.12 776.71 742.43 789.22 754.85 C 801.13 766.74 818.76 770.03 834.98 770.03 C 850.97 769.96 868.30 766.80 880.18 755.22 C 892.72 743.07 896.77 724.95 897.47 708.09 C 897.54 661.65 897.47 615.20 897.51 568.75 C 904.42 568.75 911.33 568.74 918.24 568.76 C 918.25 615.52 918.26 662.28 918.24 709.04 C 917.68 726.52 913.52 744.58 902.77 758.73 C 892.88 772.00 877.76 780.72 861.82 784.53 C 847.77 787.77 833.15 787.97 818.87 786.48 C 799.04 784.25 779.26 775.13 767.14 758.87 C 758.33 747.49 754.00 733.32 752.28 719.20 C 751.17 710.52 751.56 701.76 751.50 693.04 Z" /></svg>';
$weather34homeicon='<svg width=14 height=14 fill=#ccc stroke=#ccc  viewBox="0 0 93 97.06" ><title/><g data-name="Layer 2" id="Layer_2"><g id="weather34 icon home"><path d="M92.56,45.42l-45-45a1.54,1.54,0,0,0-2.12,0l-45,45a1.5,1.5,0,0,0,0,2.12l8.12,8.12a1.54,1.54,0,0,0,2.12,0l2.16-2.16V95.56a1.5,1.5,0,0,0,1.5,1.5H78.66a1.5,1.5,0,0,0,1.5-1.5V53.5l2.16,2.16a1.5,1.5,0,0,0,2.12,0l8.12-8.12A1.5,1.5,0,0,0,92.56,45.42ZM37.66,94.06V70.65H55.34V94.06ZM77.16,50.63V94.06H58.34V69.15a1.5,1.5,0,0,0-1.5-1.5H36.16a1.5,1.5,0,0,0-1.5,1.5V94.06H15.84V50.63s0-.08,0-.11L46.5,19.84,77.17,50.51S77.16,50.59,77.16,50.63Zm6.23,1.86L47.56,16.66a1.54,1.54,0,0,0-2.12,0L9.62,52.48l-6-6L46.5,3.6,89.38,46.48Z"/></g></g></svg>';
$weather34settingsicon='<svg id="i-settings" viewBox="0 0 32 32" width=14 height=14 fill=none stroke=#ccc stroke-linecap="round" stroke-linejoin="round" stroke-width="6.25%">
<path d="M13 2 L13 6 11 7 8 4 4 8 7 11 6 13 2 13 2 19 6 19 7 21 4 24 8 28 11 25 13 26 13 30 19 30 19 26 21 25 24 28 28 24 25 21 26 19 30 19 30 13 26 13 25 11 28 8 24 4 21 7 19 6 19 2 Z" />  <circle cx="16" cy="16" r="4" /></svg>';
$pollution='<svg enable-background="new 0 0 100 100" id="Layer_1" version="1.1" viewBox="0 0 100 100" width=28 height=24><g><path d="M49.3,77.7c-3.2,0-5.9,2.6-5.9,5.8s2.6,5.8,5.9,5.8c3.2,0,5.9-2.6,5.9-5.8S52.6,77.7,49.3,77.7z M49.3,87.6   c-2.3,0-4.2-1.9-4.2-4.2c0-2.3,1.9-4.2,4.2-4.2s4.2,1.9,4.2,4.2C53.6,85.7,51.7,87.6,49.3,87.6z" fill="currentcolor"/><path d="M86.5,77.7c-3.2,0-5.9,2.6-5.9,5.8s2.6,5.8,5.9,5.8c3.2,0,5.9-2.6,5.9-5.8S89.8,77.7,86.5,77.7z M86.5,87.6   c-2.3,0-4.2-1.9-4.2-4.2c0-2.3,1.9-4.2,4.2-4.2c2.3,0,4.2,1.9,4.2,4.2C90.8,85.7,88.9,87.6,86.5,87.6z" fill="currentcolor"/><path d="M97.5,75c-1.7-2-12.5-2.8-17-3.1c0,0-7.9-8.5-18.3-8.3L53,64l-0.4,0c0,0-0.2-0.1-0.9,0.4   c-0.7,0.5-6.5,4.3-9,6.7l-4.2,0c0,0-1.1,0-1.5,0.7c-0.4,0.6-1.3,4.5,0,9.7c0,0,0.7,1.6,4.7,2.4c0.3-3.9,3.6-7,7.7-7   c3.6,0,6.6,2.5,7.5,5.8l22.3-0.1c0.9-3.2,3.9-5.6,7.4-5.6c4.3,0,7.7,3.4,7.7,7.6c0,0.2,0,0.3,0,0.5l3.1-0.2c0,0,0.9,0.1,1.3-0.9   c0.4-0.9,0.3-5.4,0.3-5.4S99.2,76.9,97.5,75z M48.9,71.3c0,0,2.1-4.7,4.2-6.1c0,0,4.6-0.5,8.3-0.6l1.4,6.9L48.9,71.3z M64.1,71.5   l-1.4-6.9c2,0.1,7.9,0.6,12.5,4.5c0,0-1.8-1.7,0,0l-0.6,0.1l0.3,1.7c0,0,0,0.1,0.3,0.1l0.2,0.7L64.1,71.5z" fill="currentcolor"/><path d="M35.5,69.7c-0.1-1.1-0.6-2-1.3-2.8c0.1,0,0.2,0,0.3,0c2.4-0.2,4.3-2.3,4.2-4.6c3.5-0.9,5.8-4.2,5.5-7.8   c0-0.4-0.1-0.9-0.3-1.3c1.6-1.5,2.4-3.6,2.2-5.7c0-0.1,0-0.1,0-0.2c3.2-1.7,5.1-5.1,4.7-8.6c-0.2-2.5-1.5-4.8-3.6-6.3   c0.2-0.7,0.3-1.3,0.3-2c-0.1-0.8-0.4-1.6-0.9-2.3c0.7-1.2,1.1-2.6,0.9-4c-0.3-3.6-3.6-6.3-7.3-6c-0.1,0-0.2,0-0.4,0   c-0.7-2.2-2.8-3.7-5.2-3.5c-0.4,0-0.8,0.1-1.2,0.2c-1.5-2.6-4.4-4.1-7.6-3.9c-2.6,0.2-4.9,1.7-6.2,3.9c-0.7,0.1-1.3,0.3-2,0.6   c-0.9-0.3-1.9-0.3-2.8-0.3c-2.1,0.2-4,1.2-5.4,2.8c-1.2,1.4-1.9,3.2-1.8,5.2c-1.8,1-2.9,2.9-2.7,5c0,0.4,0.1,0.7,0.2,1.1   c-2,0.9-3.3,3-3.1,5.2c0.1,0.7,0.3,1.4,0.6,2c-1.4,1.5-2,3.5-1.9,5.5c0.3,3.4,2.9,6.1,6.3,6.6c-0.4,1-0.6,2.2-0.5,3.3   c0.3,3.3,2.8,5.9,6,6.5c-0.1,0.6-0.1,1.2-0.1,1.7c0,0.4,0.1,0.8,0.2,1.2c-1.1,1.4-1.6,3.2-1.4,5c0.4,4,3.8,6.9,7.9,6.7   c-0.1,0.5-0.1,1,0,1.4c0.3,3.2,3.2,5.6,6.4,5.3c0.8-0.1,1.6-0.3,2.3-0.7c0.5,1.2,1.7,2,3.1,2c0.1,0,0.2,0,0.3,0   c1.8-0.2,3.2-1.7,3-3.5c0-0.3-0.1-0.7-0.3-1c0.5-0.8,0.8-1.8,0.7-2.8c0-0.4-0.1-0.8-0.3-1.1C35.3,71.6,35.6,70.7,35.5,69.7z    M32.6,67.7c0.7,0.5,1.2,1.3,1.3,2.2c0.1,0.7-0.1,1.4-0.6,2L33,72.3l0.2,0.4c0.2,0.3,0.3,0.7,0.3,1c0.1,0.8-0.2,1.5-0.7,2.1   l-0.4,0.5l0.3,0.5c0.2,0.2,0.3,0.5,0.3,0.8c0.1,0.9-0.6,1.7-1.5,1.8l-0.2,0c-0.9,0-1.6-0.6-1.7-1.5c0-0.1,0-0.1,0-0.2l0.1-1.9   L28.4,77c-0.7,0.6-1.6,1-2.5,1.1c-2.4,0.2-4.5-1.5-4.7-3.8c-0.1-0.7,0-1.3,0.3-2l0.6-1.5l-1.6,0.4c-0.3,0.1-0.6,0.1-0.9,0.2   c-3.3,0.3-6-2.1-6.3-5.2c-0.1-1.5,0.3-3,1.3-4.2l0.3-0.3l-0.1-0.4c-0.1-0.4-0.2-0.9-0.3-1.3c-0.1-0.7,0-1.4,0.2-2.1l0.3-0.9l-1-0.1   c-2.9-0.2-5.2-2.4-5.4-5.2c-0.1-1.2,0.2-2.4,0.8-3.4L9.9,47H8.5c-3,0-5.5-2.2-5.8-5.2c-0.2-1.8,0.5-3.5,1.8-4.7L5,36.6L4.6,36   c-0.4-0.5-0.6-1.1-0.7-1.8c-0.2-1.8,1-3.4,2.7-3.8l1-0.3l-0.5-0.9c-0.2-0.4-0.4-0.9-0.4-1.3c-0.1-1.6,0.8-3,2.2-3.7L9.5,24   l-0.1-0.6c-0.1-1.6,0.4-3.2,1.4-4.5c1.1-1.3,2.6-2,4.3-2.2c0.9-0.1,1.7,0,2.5,0.3l0.3,0.1l0.3-0.2c0.6-0.3,1.4-0.6,2.1-0.7l0.4-0.1   l0.2-0.4c1-2,2.9-3.2,5.1-3.4c2.7-0.2,5.2,1.2,6.3,3.6l0.4,0.8l0.8-0.4c0.4-0.2,0.8-0.3,1.3-0.4c1.8-0.2,3.5,1.2,3.7,2.9l0.1,0.9   l0.9-0.3c0.3-0.1,0.6-0.1,0.9-0.2c2.8-0.3,5.3,1.8,5.5,4.6c0.1,1.2-0.2,2.4-1,3.4L44.6,28l0.4,0.5c0.5,0.5,0.8,1.2,0.8,1.9   c0.1,0.6-0.1,1.3-0.4,1.8l-0.3,0.7l0.6,0.4c2,1.2,3.2,3.2,3.4,5.5c0.3,3.1-1.5,6-4.4,7.3l-0.6,0.3l0.1,0.6c0,0.2,0.1,0.4,0.1,0.6   c0.2,1.8-0.6,3.6-2,4.7L42,52.7l0.2,0.5c0.2,0.5,0.3,1,0.3,1.5c0.3,3-1.9,5.7-4.9,6.2L36.8,61l0.2,0.8c0,0.1,0,0.2,0,0.3   c0.1,1.6-1.1,3.1-2.7,3.2c-0.2,0-0.4,0-0.5,0l-0.6,0l-0.2,0.5c-0.1,0.3-0.3,0.5-0.5,0.7l-0.6,0.7L32.6,67.7z" fill="currentcolor"/><path d="M35.1,43.1c-1.5-13.7-4-16.8,0.2-22c0,0-18.8,8.6-20.6,21.4c-1.6,11.3,4.6,11.1,6.9,13.8   c-0.2,2.2-0.3,6.8,1.4,9l2.2-0.6c0,0-1.6-5.1-1-7.9c0.5-0.3,1-0.5,1.6-0.6C25.9,56.3,36.3,54.4,35.1,43.1z M29.9,26.7   c-0.5,0.7-1,1.5-1.6,2.2c-0.5,0.8-1.1,1.7-1.5,2.6c-0.2,0.5-0.5,0.9-0.8,1.4c-0.2,0.5-0.4,1-0.7,1.5c-0.5,1-0.8,2.1-1.2,3.1   c-0.4,1-0.6,2.1-1,3.2c-0.2,1.1-0.5,2.1-0.7,3.2c-0.1,1-0.3,2-0.4,3c-0.2,1-0.1,1.9-0.2,2.7c0,0.8-0.1,1.6-0.1,2.3   c0,0.7,0,1.3,0,1.8c0,1,0,1.6,0,1.6s-0.1-0.6-0.3-1.5c-0.1-0.5-0.2-1.1-0.3-1.8c-0.1-0.7-0.2-1.5-0.2-2.3c0-0.9-0.2-1.8-0.1-2.8   c0.1-1,0.1-2,0.2-3.1c0.2-1.1,0.3-2.2,0.6-3.3c0.3-1.1,0.6-2.2,1-3.3c0.4-1.1,0.8-2.2,1.3-3.2c0.3-0.5,0.5-1,0.8-1.5   c0.3-0.5,0.6-1,0.9-1.4c0.5-1,1.2-1.8,1.8-2.6c0.6-0.8,1.2-1.5,1.9-2.1c1.2-1.3,2.4-2.2,3.1-2.8c0.8-0.6,1.3-0.9,1.3-0.9   s-0.4,0.4-1.1,1.1C31.8,24.3,30.9,25.4,29.9,26.7z" fill="currentcolor"/></g></svg>';
$earthquakeinfo2='<svg id=i-activity viewBox="0 0 32 32" width=43 height=43 fill=none stroke=currentcolor stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M4 16 L11 16 14 29 18 3 21 16 28 16" />
</svg>';
$earthquaketime='<svg id="i-clock" viewBox="0 0 32 32" width="12" height="12" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
<circle cx="16" cy="16" r="14" /><path d="M16 8 L16 16 20 20" /></svg>';
$locationinfo='<svg id="i-location2" viewBox="0 0 32 32" width="12px" height="12px" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
<circle cx="16" cy="11" r="4" /><path d="M24 15 C21 22 16 30 16 30 16 30 11 22 8 15 5 8 10 2 16 2 22 2 27 8 24 15 Z" /></svg>';
$meteorinfo2="<svg width='32px' height='32px' viewBox='0 0 16 16'><path fill='currentcolor' d='M0 0l14.527 13.615s.274.382-.081.764c-.355.382-.82.055-.82.055L0 0zm4.315 1.364l11.277 10.368s.274.382-.081.764c-.355.382-.82.055-.82.055L4.315 1.364zm-3.032 2.92l11.278 10.368s.273.382-.082.764c-.355.382-.819.054-.819.054L1.283 4.284zm6.679-1.747l7.88 7.244s.19.267-.058.534-.572.038-.572.038l-7.25-7.816zm-5.68 5.13l7.88 7.244s.19.266-.058.533-.572.038-.572.038l-7.25-7.815zm9.406-3.438l3.597 3.285s.094.125-.029.25c-.122.125-.283.018-.283.018L11.688 4.23zm-7.592 7.04l3.597 3.285s.095.125-.028.25-.283.018-.283.018l-3.286-3.553z'/></svg>";
//moon phases weather34 svg
$newmoonsvg='<svg version="1.1" id="weather34 newmoon"  x="0px" y="0px"  width="100px" height="100px" viewBox="0 0 107.112 107.112" fill="RGBA(255, 255, 255, 0.6)" stroke="none"><g>
<path d="M53.556,107.112C24.025,107.112,0,83.087,0,53.556S24.025,0,53.556,0s53.556,24.025,53.556,53.556 S83.087,107.112,53.556,107.112z M53.556,0.75C24.439,0.75,0.75,24.439,0.75,53.556c0,29.118,23.689,52.806,52.806,52.806 c29.118,0,52.806-23.688,52.806-52.806C106.362,24.439,82.674,0.75,53.556,0.75z"/>
<path d="M53.556,107.112C24.025,107.112,0,83.087,0,53.556S24.025,0,53.556,0s53.556,24.025,53.556,53.556 S83.087,107.112,53.556,107.112z M53.556,0.75C24.439,0.75,0.75,24.439,0.75,53.556c0,29.118,23.689,52.806,52.806,52.806 c29.118,0,52.806-23.688,52.806-52.806C106.362,24.439,82.674,0.75,53.556,0.75z"/></g></svg>';
$waxingcrescentsvg='<svg version="1.1" id="weather34 waxingcrescent" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M27.057,108.226c13.555,0,25.189-5.286,34.908-15.856c9.717-10.574,14.576-23.326,14.576-38.256 c0-14.891-4.859-27.629-14.576-38.226C52.246,5.297,40.612,0,27.057,0C41.904,0,54.635,5.297,65.25,15.889
c10.611,10.596,15.918,23.335,15.918,38.225c0,14.93-5.307,27.682-15.918,38.254C54.635,102.939,41.904,108.226,27.057,108.226z"/></g></svg>';
$waxingcrescent2svg='<svg version="1.1" id="weather34 waxing crescent2" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g><path d="M27.12,108.226c10.342,0,19.204-5.286,26.586-15.856c7.383-10.574,11.072-23.326,11.072-38.256 	c0-14.891-3.689-27.629-11.072-38.226C46.324,5.297,37.461,0,27.12,0c14.764,0,27.452,5.297,38.064,15.889
c10.615,10.596,15.922,23.335,15.922,38.225c0,14.93-5.307,27.682-15.922,38.254C54.572,102.939,41.884,108.226,27.12,108.226z"/></g></svg>';
$waxingcrescent3svg='<svg version="1.1" id="weather34 waxing crescent2" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M27.025,108.226c5.881,0,10.958-5.286,15.234-15.856c4.273-10.574,6.411-23.326,6.411-38.256 c0-14.891-2.139-27.629-6.411-38.226C37.983,5.297,32.906,0,27.025,0c14.89,0,27.642,5.297,38.255,15.889
c10.613,10.596,15.921,23.335,15.921,38.225c0,14.93-5.308,27.682-15.921,38.254C54.666,102.939,41.915,108.226,27.025,108.226z"/></g></svg>';
$firstquartersvg='<svg version="1.1" id="firstquarter weather34" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M27.087,108.226V0c14.806,0,27.515,5.297,38.13,15.889c10.613,10.596,15.921,23.335,15.921,38.225 c0,14.93-5.308,27.682-15.921,38.254C54.603,102.939,41.894,108.226,27.087,108.226z"/></g></svg>';
$waxinggibboussvg='<svg version="1.1" id="waxing-gibbous weather34" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none">
<g><path d="M45.854,108.227c-10.385,0-19.257-5.284-26.617-15.857C11.875,81.797,8.194,69.047,8.194,54.114 c0-14.889,3.682-27.63,11.043-38.222C26.598,5.298,35.47,0,45.854,0c14.891,0,27.643,5.298,38.255,15.892
c10.614,10.592,15.923,23.333,15.923,38.222c0,14.933-5.309,27.683-15.923,38.255C73.497,102.942,60.745,108.227,45.854,108.227z"/></g></svg>';
$fullmoonsvg='<svg height="120" width="120" id="weather34 fullmoon"> <circle cx="50%" cy="50%" r="50%" fill="#fff" /></svg>';
$waninggibboussvg='<svg version="1.1" id="weather34 waning-gibbous" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M70.316,108.227c-14.849,0-27.566-5.287-38.16-15.857C21.563,81.795,16.266,69.044,16.266,54.114 	c0-14.89,5.297-27.629,15.891-38.224C42.75,5.299,55.469,0,70.316,0c5.881,0,10.957,5.299,15.232,15.89
c4.273,10.595,6.412,23.334,6.412,38.224c0,14.931-2.139,27.683-6.412,38.255C81.273,102.939,76.197,108.227,70.316,108.227z"/> </g></svg>';
$waninggibbous2svg='<svg version="1.1" id="weather34 waning-gibbous2"x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M65.938,108.227c-14.889,0-27.63-5.286-38.223-15.857C17.12,81.797,11.823,69.045,11.823,54.114 c0-14.89,5.296-27.629,15.891-38.224C38.308,5.299,51.048,0,65.938,0c8.341,0,15.504,5.299,21.489,15.89
c5.983,10.595,8.977,23.334,8.977,38.224c0,14.931-2.992,27.683-8.979,38.255C81.441,102.94,74.277,108.227,65.938,108.227z"/></g></svg>';
$lastquartersvg='<svg version="1.1" id="weather34 last quarter" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M81.201,108.227c-14.887,0-27.639-5.286-38.253-15.857C32.333,81.797,27.025,69.045,27.025,54.114 c0-14.89,5.307-27.629,15.922-38.224C53.562,5.299,66.314,0,81.201,0V108.227z"/></g></svg>';	
$waningcrescentsvg='<svg version="1.1" id="weather34 waning-crescent" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M81.232,108.227c-14.932,0-27.704-5.284-38.316-15.856C32.3,81.797,26.994,69.045,26.994,54.114 c0-14.889,5.306-27.629,15.921-38.224C53.527,5.298,66.301,0,81.231,0c-5.923,0-11.021,5.298-15.296,15.89
c-4.274,10.596-6.41,23.336-6.41,38.224c0,14.931,2.137,27.683,6.411,38.255C70.211,102.942,75.311,108.227,81.232,108.227z"/></g></svg>';	
$waningcrescent2svg='<svg version="1.1" id="weather34 waning-crescent2" x="0px" y="0px"  width="100px" height="130px" viewBox="0 0 107.112 107.112" fill="#fff" stroke="none"><g>
<path d="M81.202,108.227c-14.89,0-27.642-5.284-38.254-15.856C32.333,81.797,27.024,69.045,27.024,54.114 	c0-14.889,5.308-27.629,15.922-38.224C53.56,5.298,66.312,0,81.2,0C69.062,0,58.667,5.298,50.015,15.89
c-8.653,10.596-12.979,23.336-12.979,38.224c0,14.931,4.326,27.683,12.979,38.255C58.667,102.942,69.062,108.227,81.202,108.227z"/></g></svg>';	
$eqalert2a='<svg width="12px" height="12px" viewBox="0 0 50 47"><path fill="#f8f8f8" stroke="#f8f8f8" stroke-width=".1" d="M21.6 2c7.8-1.2 16.4 2 21 8.5 4.6 6.2 5.6 14.8 2.8 22C41 44 26.4 50 15.4 44.3c-11-4.6-16.3-19-10.8-29.8C7.6 7.8 14.3 3 21.6 2m-2.2 3.6c-9.8 2.7-16.3 14-13 24 2.2 7.3 9 12.7 16.6 13.7 7.4.4 15-3.3 18.5-10 4.4-7.6 2.4-18-4.2-23.8-4.8-4-11.8-5.6-18-4z"/><path fill="#f8f8f8" stroke="#f8f8f8" stroke-width=".1" d="M20.5 8.7c6-1.6 13.4.4 17 5.8 4 5.5 4.3 13.6 0 19-2.7 4-7.6 6-12.3 6.6-7.8.3-15.2-6-16.4-13.8-1-7.6 4-15.7 11.7-17.5m-1.2 3.8c-4 1.8-6.7 5.7-7.2 10C10.7 31 20 39.2 28.5 36 36 34.4 40 24.8 36 18.2c-3-6-10.7-8.7-16.7-5.7z"/><path fill="#f8f8f8" stroke="#f8f8f8" stroke-width=".1" d="M20.4 15.5c6.3-3.6 15 2.4 14 9.6-.6 7.3-10.5 11.7-15.8 6.4-5-4.2-4.3-13 1.8-16z"/></svg>';	
$goodbattery='<svg version="1.1" width="30px" height="14px" viewBox="0 0 900 578" id="good battery">
<path fill="#8bc34a" stroke="#8bc34a" stroke-width="0.09375" opacity="1.00" d=" M 37.65 60.64 C 45.15 50.59 57.38 44.05 69.98 43.99 C 271.69 44.03 473.39 43.96 675.10 44.02 C 675.31 150.01 675.13 256.01 675.19 362.00 C 675.13 422.66 675.31 483.32 675.10 543.98 C 473.40 544.04 271.69 543.97 69.99 544.01 C 57.63 543.94 45.62 537.64 38.08 527.92 C 32.33 520.61 29.16 511.34 29.24 502.04 C 29.25 363.35 29.25 224.66 29.24 85.96 C 29.17 76.90 32.15 67.85 37.65 60.64 Z" />
<path fill="#cfd8dc" stroke="#cfd8dc" stroke-width="0.09375" opacity="1.00" d=" M 675.10 44.02 C 709.74 43.97 744.37 44.02 779.01 44.00 C 789.57 43.88 800.07 48.01 807.75 55.24 C 815.92 62.83 820.88 73.80 820.98 84.97 C 821.06 119.93 820.94 154.89 821.03 189.84 C 828.37 189.87 835.71 189.74 843.04 189.89 C 848.96 190.04 854.98 192.60 858.58 197.42 C 861.73 201.54 862.79 206.85 862.67 211.95 C 862.65 266.98 862.68 322.02 862.66 377.06 C 862.71 382.52 861.08 388.21 857.19 392.19 C 853.29 396.27 847.57 398.15 842.02 398.15 C 835.02 398.21 828.03 398.15 821.04 398.15 C 820.95 432.77 821.03 467.39 821.00 502.01 C 821.08 511.60 817.74 521.17 811.63 528.58 C 803.82 538.30 791.48 544.16 779.01 544.00 C 744.37 543.99 709.74 544.03 675.10 543.98 C 675.31 483.32 675.13 422.66 675.19 362.00 C 675.13 256.01 675.31 150.01 675.10 44.02 Z" />
</svg>';
$poorbattery='<svg version="1.1" width="30px" height="14px" viewBox="0 0 900 578" id="low battery">
<path fill="#d65b4a" stroke="#d65b4a" stroke-width="0.09375" opacity="1.00" d=" M 37.58 60.48 C 44.69 50.98 56.05 44.57 67.96 44.00 C 266.66 44.01 465.36 44.00 664.06 44.00 C 668.02 44.04 671.99 43.85 675.95 44.22 C 674.66 44.61 673.36 44.88 672.04 45.00 C 483.04 45.00 294.03 44.93 105.03 45.04 C 105.02 210.99 105.04 376.94 105.02 542.89 C 114.98 543.54 124.97 543.26 134.94 543.32 C 313.64 543.30 492.34 543.35 671.03 543.29 C 672.63 543.32 674.22 543.58 675.82 543.83 C 622.88 544.20 569.93 543.88 516.98 543.99 C 368.65 544.00 220.32 543.96 71.99 544.01 C 58.92 544.78 45.88 538.32 37.96 528.01 C 32.15 520.68 29.14 511.32 29.06 502.01 C 29.08 363.34 29.08 224.67 29.06 86.00 C 29.14 76.89 32.00 67.73 37.58 60.48 Z" />
<path fill="#cfd8dc" stroke="#cfd8dc" stroke-width="0.09375" opacity="1.00" d=" M 675.95 44.22 C 710.92 43.74 745.97 44.08 780.97 44.05 C 795.03 44.44 808.43 52.67 815.39 64.84 C 819.13 71.22 821.04 78.61 821.00 85.99 C 821.00 120.61 821.00 155.22 821.00 189.83 C 828.33 189.87 835.66 189.75 843.00 189.88 C 848.68 190.03 854.46 192.37 858.11 196.83 C 861.37 200.75 862.70 205.95 862.66 210.97 C 862.67 266.31 862.67 321.64 862.66 376.98 C 862.73 382.47 861.10 388.20 857.18 392.20 C 853.26 396.30 847.48 398.18 841.89 398.15 C 834.93 398.20 827.96 398.15 821.00 398.17 C 821.00 432.77 821.00 467.38 821.00 501.99 C 821.10 511.82 817.57 521.63 811.18 529.12 C 803.36 538.52 791.25 544.15 779.02 544.00 C 744.62 543.89 710.20 544.23 675.82 543.83 C 674.22 543.58 672.63 543.32 671.03 543.29 C 492.34 543.35 313.64 543.30 134.94 543.32 C 124.97 543.26 114.98 543.54 105.02 542.89 C 105.04 376.94 105.02 210.99 105.03 45.04 C 294.03 44.93 483.04 45.00 672.04 45.00 C 673.36 44.88 674.66 44.61 675.95 44.22 M 381.42 221.69 C 367.41 223.12 353.39 229.48 344.87 241.00 C 334.75 254.79 330.74 272.12 330.17 288.98 C 329.42 308.70 332.58 329.46 344.02 345.99 C 352.11 357.93 366.09 364.75 380.16 366.41 C 395.83 368.33 412.82 366.29 425.96 356.93 C 435.24 350.50 441.07 340.32 444.99 329.97 C 450.54 314.72 451.51 298.15 450.17 282.09 C 448.65 265.79 443.61 249.02 432.31 236.77 C 419.34 223.28 399.36 219.74 381.42 221.69 M 229.03 223.45 C 228.93 225.64 228.85 227.83 228.88 230.02 C 229.00 274.94 228.73 319.86 229.02 364.77 C 257.11 364.94 285.20 364.80 313.30 364.85 C 313.63 360.57 313.59 356.29 313.31 352.02 C 289.99 351.97 266.66 352.03 243.34 351.98 C 243.36 310.32 243.33 268.66 243.35 227.01 C 243.31 225.78 243.22 224.56 243.09 223.35 C 238.40 223.45 233.72 223.34 229.03 223.45 M 474.34 223.80 C 487.31 270.81 500.26 317.83 513.23 364.85 C 518.46 364.85 523.70 364.84 528.94 364.85 C 539.38 325.45 549.68 286.01 560.15 246.62 C 561.49 248.43 561.70 250.74 562.33 252.85 C 572.21 290.18 582.12 327.51 592.03 364.84 C 597.27 364.84 602.51 364.85 607.75 364.84 C 620.10 320.46 632.47 276.10 644.83 231.72 C 645.56 228.97 646.61 226.27 646.74 223.40 C 641.57 223.41 636.39 223.38 631.22 223.40 C 620.68 264.33 610.14 305.26 599.59 346.19 C 588.87 305.27 578.25 264.33 567.54 223.40 C 562.84 223.39 558.14 223.39 553.44 223.40 C 542.74 264.31 532.09 305.23 521.41 346.14 C 510.82 305.24 500.49 264.28 489.91 223.39 C 484.72 223.62 479.47 222.91 474.34 223.80 Z" />
<path fill="#d65b4a" stroke="#d65b4a" stroke-width="0.09375" opacity="1.00" d=" M 381.42 221.69 C 399.36 219.74 419.34 223.28 432.31 236.77 C 443.61 249.02 448.65 265.79 450.17 282.09 C 451.51 298.15 450.54 314.72 444.99 329.97 C 441.07 340.32 435.24 350.50 425.96 356.93 C 412.82 366.29 395.83 368.33 380.16 366.41 C 366.09 364.75 352.11 357.93 344.02 345.99 C 332.58 329.46 329.42 308.70 330.17 288.98 C 330.74 272.12 334.75 254.79 344.87 241.00 C 353.39 229.48 367.41 223.12 381.42 221.69 M 386.31 234.36 C 375.80 234.89 364.96 238.81 358.20 247.19 C 349.81 257.75 346.48 271.40 345.45 284.61 C 344.64 296.45 345.14 308.48 347.88 320.06 C 350.29 330.11 355.16 340.07 363.68 346.30 C 373.18 353.34 385.64 354.82 397.11 353.66 C 407.53 352.62 417.97 347.84 424.22 339.21 C 431.52 329.05 434.53 316.48 435.49 304.17 C 436.47 290.83 435.78 277.14 431.68 264.32 C 428.77 255.59 424.17 246.96 416.54 241.50 C 407.85 235.29 396.73 233.75 386.31 234.36 Z" />
<path fill="#d65b4a" stroke="#d65b4a" stroke-width="0.09375" opacity="1.00" d=" M 229.03 223.45 C 233.72 223.34 238.40 223.45 243.09 223.35 C 243.22 224.56 243.31 225.78 243.35 227.01 C 243.33 268.66 243.36 310.32 243.34 351.98 C 266.66 352.03 289.99 351.97 313.31 352.02 C 313.59 356.29 313.63 360.57 313.30 364.85 C 285.20 364.80 257.11 364.94 229.02 364.77 C 228.73 319.86 229.00 274.94 228.88 230.02 C 228.85 227.83 228.93 225.64 229.03 223.45 Z" />
<path fill="#d65b4a" stroke="#d65b4a" stroke-width="0.09375" opacity="1.00" d=" M 474.34 223.80 C 479.47 222.91 484.72 223.62 489.91 223.39 C 500.49 264.28 510.82 305.24 521.41 346.14 C 532.09 305.23 542.74 264.31 553.44 223.40 C 558.14 223.39 562.84 223.39 567.54 223.40 C 578.25 264.33 588.87 305.27 599.59 346.19 C 610.14 305.26 620.68 264.33 631.22 223.40 C 636.39 223.38 641.57 223.41 646.74 223.40 C 646.61 226.27 645.56 228.97 644.83 231.72 C 632.47 276.10 620.10 320.46 607.75 364.84 C 602.51 364.85 597.27 364.84 592.03 364.84 C 582.12 327.51 572.21 290.18 562.33 252.85 C 561.70 250.74 561.49 248.43 560.15 246.62 C 549.68 286.01 539.38 325.45 528.94 364.85 C 523.70 364.84 518.46 364.85 513.23 364.85 C 500.26 317.83 487.31 270.81 474.34 223.80 Z" />
<path fill="#cfd8dc" stroke="#cfd8dc" stroke-width="0.09375" opacity="1.00" d=" M 386.31 234.36 C 396.73 233.75 407.85 235.29 416.54 241.50 C 424.17 246.96 428.77 255.59 431.68 264.32 C 435.78 277.14 436.47 290.83 435.49 304.17 C 434.53 316.48 431.52 329.05 424.22 339.21 C 417.97 347.84 407.53 352.62 397.11 353.66 C 385.64 354.82 373.18 353.34 363.68 346.30 C 355.16 340.07 350.29 330.11 347.88 320.06 C 345.14 308.48 344.64 296.45 345.45 284.61 C 346.48 271.40 349.81 257.75 358.20 247.19 C 364.96 238.81 375.80 234.89 386.31 234.36 Z" />
</svg>';
$batteryok ='<svg version="1.1" id="weaher34 ok" x="0px" y="0px" width="12px" height="12px" viewBox="0 0 363.025 363.024" style="enable-background:new 0 0 363.025 363.024;"><g><g><g>
<path style="fill:currentcolor;" d="M181.512,363.024C81.43,363.024,0,281.601,0,181.513C0,81.424,81.43,0,181.512,0 c100.083,0,181.513,81.424,181.513,181.513C363.025,281.601,281.595,363.024,181.512,363.024z M181.512,11.71
C87.88,11.71,11.71,87.886,11.71,181.513s76.17,169.802,169.802,169.802c93.633,0,169.803-76.175,169.803-169.802 S275.145,11.71,181.512,11.71z"/></g></g><g><polygon style="fill:currentcolor;" points="147.957,258.935 83.068,194.046 91.348,185.767 147.957,242.375 271.171,119.166 279.451,127.445 "/></g></svg>';
$batterypoor ='<svg id="weather34 poor" viewBox="0 0 32 32" width="11" height="11" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><circle cx="16" cy="16" r="14" />
<path d="M6 6 L26 26" /></svg>';
$newalert='<svg width="28pt" height="29pt" viewBox="0 0 460 478" id="weather34 orange alert notification" >
<path fill="#ff8841" opacity="1.00" d=" M 171.06 10.38 C 171.29 10.41 171.76 10.48 171.99 10.52 C 225.57 103.02 279.13 195.53 332.76 288.00 C 225.25 288.00 117.74 288.00 10.24 288.00 C 63.88 195.48 117.50 102.94 171.06 10.38 M 151.00 68.81 C 151.06 89.55 150.88 110.30 151.09 131.04 C 153.46 162.21 156.21 193.36 158.53 224.54 C 167.07 224.61 175.62 224.57 184.17 224.57 C 186.64 193.06 189.30 161.57 191.75 130.07 C 191.86 109.67 191.76 89.26 191.80 68.86 C 189.52 66.56 187.24 64.27 184.94 62.00 C 175.89 62.00 166.85 62.00 157.81 62.00 C 155.52 64.25 153.25 66.52 151.00 68.81 M 155.47 231.04 C 153.23 233.34 150.93 235.60 148.68 237.90 C 148.67 248.30 148.67 258.70 148.68 269.10 C 150.92 271.38 153.21 273.62 155.42 275.94 C 166.01 276.08 176.60 275.96 187.20 276.00 C 189.48 273.74 191.75 271.48 194.00 269.19 C 194.00 258.73 194.00 248.27 194.00 237.81 C 191.75 235.52 189.48 233.26 187.20 231.00 C 176.62 231.02 166.05 230.95 155.47 231.04 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 151.00 68.81 C 153.25 66.52 155.52 64.25 157.81 62.00 C 166.85 62.00 175.89 62.00 184.94 62.00 C 187.24 64.27 189.52 66.56 191.80 68.86 C 191.76 89.26 191.86 109.67 191.75 130.07 C 189.30 161.57 186.64 193.06 184.17 224.57 C 175.62 224.57 167.07 224.61 158.53 224.54 C 156.21 193.36 153.46 162.21 151.09 131.04 C 150.88 110.30 151.06 89.55 151.00 68.81 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 155.47 231.04 C 166.05 230.95 176.62 231.02 187.20 231.00 C 189.48 233.26 191.75 235.52 194.00 237.81 C 194.00 248.27 194.00 258.73 194.00 269.19 C 191.75 271.48 189.48 273.74 187.20 276.00 C 176.60 275.96 166.01 276.08 155.42 275.94 C 153.21 273.62 150.92 271.38 148.68 269.10 C 148.67 258.70 148.67 248.30 148.68 237.90 C 150.93 235.60 153.23 233.34 155.47 231.04 Z" />
</svg>';
$airalertorange='<svg width="58pt" height="59pt" viewBox="0 0 460 478" id="weather34 orange alert notification" >
<path fill="#ff8841" opacity="1.00" d=" M 171.06 10.38 C 171.29 10.41 171.76 10.48 171.99 10.52 C 225.57 103.02 279.13 195.53 332.76 288.00 C 225.25 288.00 117.74 288.00 10.24 288.00 C 63.88 195.48 117.50 102.94 171.06 10.38 M 151.00 68.81 C 151.06 89.55 150.88 110.30 151.09 131.04 C 153.46 162.21 156.21 193.36 158.53 224.54 C 167.07 224.61 175.62 224.57 184.17 224.57 C 186.64 193.06 189.30 161.57 191.75 130.07 C 191.86 109.67 191.76 89.26 191.80 68.86 C 189.52 66.56 187.24 64.27 184.94 62.00 C 175.89 62.00 166.85 62.00 157.81 62.00 C 155.52 64.25 153.25 66.52 151.00 68.81 M 155.47 231.04 C 153.23 233.34 150.93 235.60 148.68 237.90 C 148.67 248.30 148.67 258.70 148.68 269.10 C 150.92 271.38 153.21 273.62 155.42 275.94 C 166.01 276.08 176.60 275.96 187.20 276.00 C 189.48 273.74 191.75 271.48 194.00 269.19 C 194.00 258.73 194.00 248.27 194.00 237.81 C 191.75 235.52 189.48 233.26 187.20 231.00 C 176.62 231.02 166.05 230.95 155.47 231.04 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 151.00 68.81 C 153.25 66.52 155.52 64.25 157.81 62.00 C 166.85 62.00 175.89 62.00 184.94 62.00 C 187.24 64.27 189.52 66.56 191.80 68.86 C 191.76 89.26 191.86 109.67 191.75 130.07 C 189.30 161.57 186.64 193.06 184.17 224.57 C 175.62 224.57 167.07 224.61 158.53 224.54 C 156.21 193.36 153.46 162.21 151.09 131.04 C 150.88 110.30 151.06 89.55 151.00 68.81 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 155.47 231.04 C 166.05 230.95 176.62 231.02 187.20 231.00 C 189.48 233.26 191.75 235.52 194.00 237.81 C 194.00 248.27 194.00 258.73 194.00 269.19 C 191.75 271.48 189.48 273.74 187.20 276.00 C 176.60 275.96 166.01 276.08 155.42 275.94 C 153.21 273.62 150.92 271.38 148.68 269.10 C 148.67 258.70 148.67 248.30 148.68 237.90 C 150.93 235.60 153.23 233.34 155.47 231.04 Z" />
</svg>';
$airalertred='<svg width="58pt" height="59pt" viewBox="0 0 460 478" id="weather34 orange alert notification" >
<path fill="rgba(211,93,78,1)" opacity="1.00" d=" M 171.06 10.38 C 171.29 10.41 171.76 10.48 171.99 10.52 C 225.57 103.02 279.13 195.53 332.76 288.00 C 225.25 288.00 117.74 288.00 10.24 288.00 C 63.88 195.48 117.50 102.94 171.06 10.38 M 151.00 68.81 C 151.06 89.55 150.88 110.30 151.09 131.04 C 153.46 162.21 156.21 193.36 158.53 224.54 C 167.07 224.61 175.62 224.57 184.17 224.57 C 186.64 193.06 189.30 161.57 191.75 130.07 C 191.86 109.67 191.76 89.26 191.80 68.86 C 189.52 66.56 187.24 64.27 184.94 62.00 C 175.89 62.00 166.85 62.00 157.81 62.00 C 155.52 64.25 153.25 66.52 151.00 68.81 M 155.47 231.04 C 153.23 233.34 150.93 235.60 148.68 237.90 C 148.67 248.30 148.67 258.70 148.68 269.10 C 150.92 271.38 153.21 273.62 155.42 275.94 C 166.01 276.08 176.60 275.96 187.20 276.00 C 189.48 273.74 191.75 271.48 194.00 269.19 C 194.00 258.73 194.00 248.27 194.00 237.81 C 191.75 235.52 189.48 233.26 187.20 231.00 C 176.62 231.02 166.05 230.95 155.47 231.04 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 151.00 68.81 C 153.25 66.52 155.52 64.25 157.81 62.00 C 166.85 62.00 175.89 62.00 184.94 62.00 C 187.24 64.27 189.52 66.56 191.80 68.86 C 191.76 89.26 191.86 109.67 191.75 130.07 C 189.30 161.57 186.64 193.06 184.17 224.57 C 175.62 224.57 167.07 224.61 158.53 224.54 C 156.21 193.36 153.46 162.21 151.09 131.04 C 150.88 110.30 151.06 89.55 151.00 68.81 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 155.47 231.04 C 166.05 230.95 176.62 231.02 187.20 231.00 C 189.48 233.26 191.75 235.52 194.00 237.81 C 194.00 248.27 194.00 258.73 194.00 269.19 C 191.75 271.48 189.48 273.74 187.20 276.00 C 176.60 275.96 166.01 276.08 155.42 275.94 C 153.21 273.62 150.92 271.38 148.68 269.10 C 148.67 258.70 148.67 248.30 148.68 237.90 C 150.93 235.60 153.23 233.34 155.47 231.04 Z" />
</svg>';
$airalertpurple='<svg width="58pt" height="59pt" viewBox="0 0 460 478" id="weather34 orange alert notification" >
<path fill="#a475cb" opacity="1.00" d=" M 171.06 10.38 C 171.29 10.41 171.76 10.48 171.99 10.52 C 225.57 103.02 279.13 195.53 332.76 288.00 C 225.25 288.00 117.74 288.00 10.24 288.00 C 63.88 195.48 117.50 102.94 171.06 10.38 M 151.00 68.81 C 151.06 89.55 150.88 110.30 151.09 131.04 C 153.46 162.21 156.21 193.36 158.53 224.54 C 167.07 224.61 175.62 224.57 184.17 224.57 C 186.64 193.06 189.30 161.57 191.75 130.07 C 191.86 109.67 191.76 89.26 191.80 68.86 C 189.52 66.56 187.24 64.27 184.94 62.00 C 175.89 62.00 166.85 62.00 157.81 62.00 C 155.52 64.25 153.25 66.52 151.00 68.81 M 155.47 231.04 C 153.23 233.34 150.93 235.60 148.68 237.90 C 148.67 248.30 148.67 258.70 148.68 269.10 C 150.92 271.38 153.21 273.62 155.42 275.94 C 166.01 276.08 176.60 275.96 187.20 276.00 C 189.48 273.74 191.75 271.48 194.00 269.19 C 194.00 258.73 194.00 248.27 194.00 237.81 C 191.75 235.52 189.48 233.26 187.20 231.00 C 176.62 231.02 166.05 230.95 155.47 231.04 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 151.00 68.81 C 153.25 66.52 155.52 64.25 157.81 62.00 C 166.85 62.00 175.89 62.00 184.94 62.00 C 187.24 64.27 189.52 66.56 191.80 68.86 C 191.76 89.26 191.86 109.67 191.75 130.07 C 189.30 161.57 186.64 193.06 184.17 224.57 C 175.62 224.57 167.07 224.61 158.53 224.54 C 156.21 193.36 153.46 162.21 151.09 131.04 C 150.88 110.30 151.06 89.55 151.00 68.81 Z" />
<path fill="#ffffff" opacity="1.00" d=" M 155.47 231.04 C 166.05 230.95 176.62 231.02 187.20 231.00 C 189.48 233.26 191.75 235.52 194.00 237.81 C 194.00 248.27 194.00 258.73 194.00 269.19 C 191.75 271.48 189.48 273.74 187.20 276.00 C 176.60 275.96 166.01 276.08 155.42 275.94 C 153.21 273.62 150.92 271.38 148.68 269.10 C 148.67 258.70 148.67 248.30 148.68 237.90 C 150.93 235.60 153.23 233.34 155.47 231.04 Z" />
</svg>';
$sunricon ='<svg id="weather34 sunrise" width="10px" height="10px" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" ><g>
<path fill="#ff8841" d="M32,2.8c-16,0-29.1,13-29.2,29h58.4C61.1,15.8,48,2.8,32,2.8z"/><path class="st1" d="M32,2C15.5,2,2,15.5,2,32s13.5,30,30,30c16.5,0,30-13.5,30-30S48.5,2,32,2z M61.6,32
c0,16.4-13.3,29.6-29.6,29.6C15.6,61.6,2.4,48.4,2.4,32c0-0.1,0-0.2,0-0.2C2.5,15.5,15.7,2.4,32,2.4c16.3,0,29.5,13.1,29.6,29.4 C61.6,31.8,61.6,31.9,61.6,32z"/></g></svg>';
$sunsicon ='<svg id="weather34 sunset" width="10px" height="10px" x="0px" y="0px" viewBox="0 0 64 64" style="enable-background:new 0 0 64 64;" ><g>	
<path fill="#d86858" d="M32,61.2c16.1,0,29.2-13.1,29.2-29.2c0-0.1,0-0.2,0-0.2H2.8c0,0.1,0,0.2,0,0.2C2.8,48.1,15.9,61.2,32,61.2z"/>	<path class="st1" d="M32,2C15.5,2,2,15.5,2,32s13.5,30,30,30c16.5,0,30-13.5,30-30S48.5,2,32,2z M61.6,32
c0,16.4-13.3,29.6-29.6,29.6C15.6,61.6,2.4,48.4,2.4,32c0-0.1,0-0.2,0-0.2C2.5,15.5,15.7,2.4,32,2.4c16.3,0,29.5,13.1,29.6,29.4	C61.6,31.8,61.6,31.9,61.6,32z"/></g></svg>';
$sunlight="<svg version='1.1' id='weather34 daylight' x='0px' y='0px' width='12' height='12' fill='#ff8841' viewBox='0 0 1000 1000' enable-background='new 0 0 1000 1000' xml:space='preserve'>
<g><path  fill='#ff8841' d='M270.3,500c0,126.9,102.8,229.7,229.7,229.7S729.7,626.9,729.7,500c0-126.9-102.8-229.7-229.7-229.7S270.3,373.1,270.3,500z'/><path d='M500,193.8c16.8,0,30.6-13.8,30.6-30.6V40.6c0-16.8-13.8-30.6-30.6-30.6c-16.8,0-30.6,13.8-30.6,30.6v122.5C469.4,180,483.2,193.8,500,193.8z'/><path d='M500,806.3c-16.8,0-30.6,13.8-30.6,30.6v122.5c0,16.8,13.8,30.6,30.6,30.6c16.8,0,30.6-13.8,30.6-30.6V836.9C530.6,820,516.8,806.3,500,806.3z'/><path d='M959.4,469.4H836.9c-16.8,0-30.6,13.8-30.6,30.6c0,16.8,13.8,30.6,30.6,30.6h122.5c16.8,0,30.6-13.8,30.6-30.6C990,483.2,976.2,469.4,959.4,469.4z'/><path d='M193.8,500c0-16.8-13.8-30.6-30.6-30.6H40.6C23.8,469.4,10,483.2,10,500c0,16.8,13.8,30.6,30.6,30.6h122.5C180,530.6,193.8,516.8,193.8,500z'/><path d='M239.7,284.1c6.1,6.1,13.8,9.2,21.4,9.2s15.3-3.1,21.4-9.2c12.3-12.3,12.3-30.6,0-42.9l-87.3-87.3c-12.3-12.3-30.6-12.3-42.9,0s-12.3,30.6,0,42.9L239.7,284.1z'/><path d='M760.3,715.9c-12.3-12.3-30.6-12.3-42.9,0s-12.3,30.6,0,42.9l87.3,87.3c6.1,6.1,13.8,9.2,21.4,9.2s15.3-3.1,21.4-9.2c12.3-12.3,12.3-30.6,0-42.9L760.3,715.9z'/><path d='M738.9,291.8c7.7,0,15.3-3.1,21.4-9.2l87.3-87.3c12.3-12.3,12.3-30.6,0-42.9s-30.6-12.3-42.9,0l-88.8,87.3c-12.3,12.3-12.3,30.6,0,42.9C722,288.7,729.7,291.8,738.9,291.8z'/><path d='M239.7,715.9l-87.3,87.3c-12.3,12.3-12.3,30.6,0,42.9c6.1,6.1,13.8,9.2,21.4,9.2s15.3-3.1,21.4-9.2l87.3-87.3c12.3-12.3,12.3-30.6,0-42.9C271.8,705.2,251.9,705.2,239.7,715.9z'/></g>
</svg>";
$sundown='<svg x="0px" y="0px" fill="#d86858" width="12.5px" height="12.5px" viewBox="0 0 363.5 363.5" style="enable-background:new 0 0 363.5 363.5;">
<g>	<g>	<path d="M181.7,86.05c5.701,0,9.6-3.8,9.6-9.6v-38.2c0-5.7-3.8-9.6-9.6-9.6c-5.8,0-9.6,3.8-9.6,9.6v38.2 C172.2,82.25,176,86.05,181.7,86.05z"/>
<path d="M283.1,122.45l26.8-26.8c3.801-3.8,3.801-9.6,0-13.4c-3.8-3.8-9.6-3.8-13.399,0l-26.8,26.8c-3.801,3.8-3.801,9.6,0,13.4 C273.5,126.25,279.3,126.25,283.1,122.45z"/>
<path d="M76.5,219.95h210.399c0-3.8,0-5.699,0-9.6c0-57.4-47.8-105.2-105.2-105.2s-105.2,47.8-105.2,105.2 C76.5,214.25,76.5,216.15,76.5,219.95z"/>
<path d="M306.1,210.45c0,5.7,3.8,9.601,9.601,9.601h38.199c5.7,0,9.601-3.8,9.601-9.601c0-5.8-3.8-9.6-9.601-9.6H315.7 C311.8,200.85,306.1,206.55,306.1,210.45z"/>
<path d="M353.899,258.25H237.2l-23,19.1l-34.4,28.7l-30.6-28.7l-22.9-19.1H9.6c-3.8,0-9.6,3.8-9.6,9.6s5.7,9.6,9.6,9.6h105.2 l66.9,57.4l66.9-57.4h105.2c5.7,0,9.6-3.8,9.6-9.6S359.6,258.25,353.899,258.25z"/>
<path d="M80.4,122.45c3.8,3.8,9.6,3.8,13.4,0c3.8-3.8,3.8-9.6,0-13.4L67,82.25c-3.8-3.8-9.6-3.8-13.4,0c-3.8,3.8-3.8,9.6,0,13.4 L80.4,122.45z"/>
<path d="M9.6,219.95h38.2c3.8,0,9.6-3.8,9.6-9.6c0-3.8-3.8-9.601-9.6-9.601H9.6c-5.7,0-9.6,5.7-9.6,9.601 C0.1,216.15,3.9,219.95,9.6,219.95z"/></g>
</svg>';
$menuclocksvg ='<svg id="menu clock" viewBox="0 0 32 32" width="12" height="12" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><circle cx="16" cy="16" r="14" /><path d="M16 8 L16 16 20 20" /></svg>';
$offline='<svg id=i-info viewBox="0 0 32 32" width=7 height=7 fill=#ff8841 stroke=#ff8841 stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 />
</svg>';
$online='<svg id=i-info viewBox="0 0 32 32" width=7 height=7 fill=#9aba2f stroke=#9aba2f stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 />
</svg>';
$menuclocksvg ='<svg id="menu clock" viewBox="0 0 32 32" width="12" height="12" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><circle cx="16" cy="16" r="14" /><path d="M16 8 L16 16 20 20" /></svg>';
$offline='<svg id=i-info viewBox="0 0 32 32" width=7 height=7 fill=#ff8841 stroke=#ff8841 stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 />
</svg>';
$online='<svg id=i-info viewBox="0 0 32 32" width=7 height=7 fill=#9aba2f stroke=#9aba2f stroke-linecap=round stroke-linejoin=round stroke-width=6.25%><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx=16 cy=16 r=14 />
</svg>';
$aqiok ='<svg id="aqi-checkmark" viewBox="0 0 32 32" width="26" height="26" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="5">
<path d="M2 20 L12 28 30 4" /></svg>';
$aqiexclamationmark='<svg id="aqi-info" viewBox="0 0 32 32" width="32" height="32" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M16 14 L16 23 M16 8 L16 10" /><circle cx="16" cy="16" r="14" /></svg>';
$aqialert='<svg id="aqi-alert" viewBox="0 0 32 32" width="28" height="28" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M16 3 L30 29 2 29 Z M16 11 L16 19 M16 23 L16 25" /></svg>';
$aqiclock='<svg id="aqi-clock" viewBox="0 0 32 32" width="10" height="10" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><circle cx="16" cy="16" r="14" /><path d="M16 8 L16 16 20 20" /></svg>';
$moonpopup ='<svg id="weather34 moon popup icon" viewBox="0 0 32 32" width="9" height="9" fill="currentcolor" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="6.25%">
<circle cx="16" cy="16" r="14" /><path d="M6 6 L26 26" /></svg>';
$calendar34 ='<svg id="weather34 clock" viewBox="0 0 32 32" width="22" height="22" fill="none" stroke="currentcolor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><circle cx="16" cy="16" r="14" /><path d="M16 8 L16 16 20 20" /></svg>';
$rainsvg= '<svg id="weather34 raindrop" x="0px" y="0px" viewBox="0 0 512 512" width="8px" fill="#01a4b5" stroke="#01a4b5" stroke-width="3%"><g><g><path d="M348.242,124.971C306.633,58.176,264.434,4.423,264.013,3.889C262.08,1.433,259.125,0,256,0	c-3.126,0-6.079,1.433-8.013,3.889c-0.422,0.535-42.621,54.287-84.229,121.083c-56.485,90.679-85.127,161.219-85.127,209.66
			C78.632,432.433,158.199,512,256,512c97.802,0,177.368-79.567,177.368-177.369C433.368,286.19,404.728,215.65,348.242,124.971z
			 M256,491.602c-86.554,0-156.97-70.416-156.97-156.97c0-93.472,123.907-263.861,156.971-307.658
			C289.065,70.762,412.97,241.122,412.97,334.632C412.97,421.185,342.554,491.602,256,491.602z"/></g></g><g>
	<g><path d="M275.451,86.98c-1.961-2.815-3.884-5.555-5.758-8.21c-3.249-4.601-9.612-5.698-14.215-2.45
			c-4.601,3.249-5.698,9.613-2.45,14.215c1.852,2.623,3.75,5.328,5.688,8.108c1.982,2.846,5.154,4.369,8.377,4.369
			c2.012,0,4.046-0.595,5.822-1.833C277.536,97.959,278.672,91.602,275.451,86.98z"/></g></g><g>	<g>
		<path d="M362.724,231.075c-16.546-33.415-38.187-70.496-64.319-110.213c-3.095-4.704-9.42-6.01-14.126-2.914
			c-4.706,3.096-6.01,9.421-2.914,14.127c25.677,39.025,46.9,75.379,63.081,108.052c1.779,3.592,5.391,5.675,9.148,5.675
			c1.521,0,3.064-0.342,4.517-1.062C363.159,242.241,365.224,236.123,362.724,231.075z"/>
	</g></svg>';
	$airok='<svg id="weather34 air quality ok" x="50px" y="0px" width="48px" fill="#9aba2f"  viewBox="0 0 1000 1000">
	<g><path d="M959.4,469.4c-16.9,0-30.6,13.7-30.6,30.6c0,236.4-192.3,428.7-428.7,428.7S71.3,736.4,71.3,500C71.3,263.6,263.6,71.3,500,71.3c93.7,0,182.7,29.7,257.4,85.8c13.5,10.2,32.7,7.4,42.9-6.1c10.2-13.5,7.4-32.7-6.1-42.8C708.8,43.9,607.1,10,500,10C229.8,10,10,229.8,10,500c0,270.2,219.8,490,490,490s490-219.8,490-490C990,483.1,976.3,469.4,959.4,469.4z"/><path d="M215.4,447.7c-12-12-31.3-12-43.3,0c-12,12-12,31.3,0,43.3l245,245c6,6,13.8,9,21.7,9c7.8,0,15.7-3,21.7-9L981,215.4c12-12,12-31.3,0-43.3c-12-12-31.3-12-43.3,0l-499,499L215.4,447.7z"/></g>
</svg>';
$airokyellow='<svg id="weather34 air quality ok yellow" x="0px" y="0px" width="48px" fill="rgba(233, 171, 74, 1.000)"  viewBox="0 0 1000 1000">
	<g><path d="M959.4,469.4c-16.9,0-30.6,13.7-30.6,30.6c0,236.4-192.3,428.7-428.7,428.7S71.3,736.4,71.3,500C71.3,263.6,263.6,71.3,500,71.3c93.7,0,182.7,29.7,257.4,85.8c13.5,10.2,32.7,7.4,42.9-6.1c10.2-13.5,7.4-32.7-6.1-42.8C708.8,43.9,607.1,10,500,10C229.8,10,10,229.8,10,500c0,270.2,219.8,490,490,490s490-219.8,490-490C990,483.1,976.3,469.4,959.4,469.4z"/><path d="M215.4,447.7c-12-12-31.3-12-43.3,0c-12,12-12,31.3,0,43.3l245,245c6,6,13.8,9,21.7,9c7.8,0,15.7-3,21.7-9L981,215.4c12-12,12-31.3,0-43.3c-12-12-31.3-12-43.3,0l-499,499L215.4,447.7z"/></g>
</svg>';
?>